/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.BlockObjQueue;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectWalk
extends RevWalk {
    private static final int ID_SZ = 20;
    private static final int TYPE_SHIFT = 12;
    private static final int TYPE_TREE = 4;
    private static final int TYPE_SYMLINK = 10;
    private static final int TYPE_FILE = 8;
    private static final int TYPE_GITLINK = 14;
    private static final int IN_PENDING = 8;
    private List<RevObject> rootObjects = new ArrayList<RevObject>();
    private BlockObjQueue pendingObjects = new BlockObjQueue();
    private RevCommit firstCommit;
    private RevCommit lastCommit;
    private TreeVisit freeVisit;
    private TreeVisit currVisit;
    private byte[] pathBuf = new byte[256];
    private int pathLen;
    private boolean boundary;

    public ObjectWalk(Repository repo) {
        this(repo.newObjectReader());
    }

    public ObjectWalk(ObjectReader or) {
        super(or);
    }

    public void markStart(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            this.addObject(o);
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markStart((RevCommit)o);
        } else {
            this.addObject(o);
        }
    }

    public void markUninteresting(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            o.flags |= 4;
            if (this.boundary) {
                this.addObject(o);
            }
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markUninteresting((RevCommit)o);
        } else if (o instanceof RevTree) {
            this.markTreeUninteresting((RevTree)o);
        } else {
            o.flags |= 4;
        }
        if (o.getType() != 1 && this.boundary) {
            this.addObject(o);
        }
    }

    @Override
    public void sort(RevSort s) {
        super.sort(s);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    @Override
    public void sort(RevSort s, boolean use) {
        super.sort(s, use);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    @Override
    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit r;
        block4: {
            do {
                if ((r = super.next()) == null) {
                    if (this.firstCommit != null) {
                        this.reader.walkAdviceBeginTrees(this, this.firstCommit, this.lastCommit);
                    }
                    return null;
                }
                if ((r.flags & 4) == 0) break block4;
                this.markTreeUninteresting(r.getTree());
            } while (!this.boundary);
            return r;
        }
        if (this.firstCommit == null) {
            this.firstCommit = r;
        }
        this.lastCommit = r;
        this.pendingObjects.add(r.getTree());
        return r;
    }

    public RevObject nextObject() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        this.pathLen = 0;
        TreeVisit tv = this.currVisit;
        while (tv != null) {
            byte[] buf = tv.buf;
            block6: for (int ptr = tv.ptr; ptr < buf.length; ptr += 20) {
                int startPtr = ptr;
                ptr = ObjectWalk.findObjectId(buf, ptr);
                this.idBuffer.fromRaw(buf, ptr);
                RevObject obj = (RevObject)this.objects.get(this.idBuffer);
                if (obj != null && (obj.flags & 2) != 0) continue;
                int mode = ObjectWalk.parseMode(buf, startPtr, ptr, tv);
                switch (mode >>> 12) {
                    case 8: 
                    case 10: {
                        int flags;
                        if (obj == null) {
                            obj = new RevBlob(this.idBuffer);
                            obj.flags = 2;
                            this.objects.add(obj);
                            return obj;
                        }
                        if (!(obj instanceof RevBlob)) {
                            throw new IncorrectObjectTypeException((ObjectId)obj, 3);
                        }
                        obj.flags = flags = obj.flags | 2;
                        if ((flags & 4) != 0) continue block6;
                        return obj;
                    }
                    case 4: {
                        int flags;
                        if (obj == null) {
                            obj = new RevTree(this.idBuffer);
                            obj.flags = 2;
                            this.objects.add(obj);
                            return this.enterTree(obj);
                        }
                        if (!(obj instanceof RevTree)) {
                            throw new IncorrectObjectTypeException((ObjectId)obj, 2);
                        }
                        obj.flags = flags = obj.flags | 2;
                        if ((flags & 4) != 0) continue block6;
                        return this.enterTree(obj);
                    }
                    case 14: {
                        continue block6;
                    }
                }
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", mode), this.idBuffer.name(), RawParseUtils.decode(buf, tv.namePtr, tv.nameEnd), tv.obj));
            }
            this.currVisit = tv.parent;
            this.releaseTreeVisit(tv);
            tv = this.currVisit;
        }
        while (true) {
            if ((o = this.pendingObjects.next()) == null) {
                this.reader.walkAdviceEnd();
                return null;
            }
            int flags = o.flags;
            if ((flags & 2) != 0) continue;
            o.flags = flags |= 2;
            if ((flags & 4) == 0 | this.boundary) break;
        }
        if (o instanceof RevTree) {
            tv = this.newTreeVisit(o);
            tv.parent = null;
            this.currVisit = tv;
        }
        return o;
    }

    private RevObject enterTree(RevObject obj) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        TreeVisit tv = this.newTreeVisit(obj);
        tv.parent = this.currVisit;
        this.currVisit = tv;
        return obj;
    }

    private static int findObjectId(byte[] buf, int ptr) {
        do {
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] != 0) continue;
            return ++ptr;
        } while (buf[++ptr] != 0);
        return ++ptr;
    }

    private static int parseMode(byte[] buf, int startPtr, int recEndPtr, TreeVisit tv) {
        byte c;
        int mode = buf[startPtr] - 48;
        while (32 != (c = buf[++startPtr])) {
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
        }
        tv.ptr = recEndPtr;
        tv.namePtr = startPtr + 1;
        tv.nameEnd = recEndPtr - 21;
        return mode;
    }

    public void checkConnectivity() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        RevCommit c;
        while ((c = this.next()) != null) {
        }
        while ((o = this.nextObject()) != null) {
            if (!(o instanceof RevBlob) || this.reader.has(o)) continue;
            throw new MissingObjectException((ObjectId)o, 3);
        }
    }

    public String getPathString() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
            if (this.pathLen == 0) {
                return null;
            }
        }
        return RawParseUtils.decode(this.pathBuf, 0, this.pathLen);
    }

    public int getPathHashCode() {
        int ptr;
        byte[] buf;
        TreeVisit tv = this.currVisit;
        if (tv == null) {
            return 0;
        }
        int nameEnd = tv.nameEnd;
        if (nameEnd == 0) {
            tv = tv.parent;
            if (tv == null) {
                return 0;
            }
            nameEnd = tv.nameEnd;
        }
        if (16 <= nameEnd - tv.namePtr) {
            buf = tv.buf;
            ptr = nameEnd - 16;
        } else {
            nameEnd = this.pathLen;
            if (nameEnd == 0) {
                this.pathLen = nameEnd = this.updatePathBuf(this.currVisit);
            }
            buf = this.pathBuf;
            ptr = Math.max(0, nameEnd - 16);
        }
        int hash = 0;
        while (ptr < nameEnd) {
            byte c = buf[ptr];
            if (c != 32) {
                hash = (hash >>> 2) + (c << 24);
            }
            ++ptr;
        }
        return hash;
    }

    public byte[] getPathBuffer() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathBuf;
    }

    public int getPathLength() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathLen;
    }

    private int updatePathBuf(TreeVisit tv) {
        if (tv == null) {
            return 0;
        }
        int nameEnd = tv.nameEnd;
        if (nameEnd == 0) {
            return this.updatePathBuf(tv.parent);
        }
        int ptr = tv.pathLen;
        if (ptr == 0) {
            ptr = this.updatePathBuf(tv.parent);
            if (ptr == this.pathBuf.length) {
                this.growPathBuf(ptr);
            }
            if (ptr != 0) {
                this.pathBuf[ptr++] = 47;
            }
            tv.pathLen = ptr;
        }
        int namePtr = tv.namePtr;
        int nameLen = nameEnd - namePtr;
        int end = ptr + nameLen;
        while (this.pathBuf.length < end) {
            this.growPathBuf(ptr);
        }
        System.arraycopy(tv.buf, namePtr, this.pathBuf, ptr, nameLen);
        return end;
    }

    private void growPathBuf(int ptr) {
        byte[] newBuf = new byte[this.pathBuf.length << 1];
        System.arraycopy(this.pathBuf, 0, newBuf, 0, ptr);
        this.pathBuf = newBuf;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pendingObjects = new BlockObjQueue();
        this.firstCommit = null;
        this.lastCommit = null;
        this.currVisit = null;
        this.freeVisit = null;
    }

    @Override
    protected void reset(int retainFlags) {
        super.reset(retainFlags);
        for (RevObject obj : this.rootObjects) {
            obj.flags &= 0xFFFFFFF7;
        }
        this.rootObjects = new ArrayList<RevObject>();
        this.pendingObjects = new BlockObjQueue();
        this.firstCommit = null;
        this.lastCommit = null;
        this.currVisit = null;
        this.freeVisit = null;
    }

    private void addObject(RevObject o) {
        if ((o.flags & 8) == 0) {
            o.flags |= 8;
            this.rootObjects.add(o);
            this.pendingObjects.add(o);
        }
    }

    private void markTreeUninteresting(RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((tree.flags & 4) != 0) {
            return;
        }
        tree.flags |= 4;
        byte[] raw = this.reader.open(tree, 2).getCachedBytes();
        block5: for (int ptr = 0; ptr < raw.length; ptr += 20) {
            byte c = raw[ptr];
            int mode = c - 48;
            while (32 != (c = raw[++ptr])) {
                mode <<= 3;
                mode += c - 48;
            }
            while (raw[++ptr] != 0) {
            }
            ++ptr;
            switch (mode >>> 12) {
                case 8: 
                case 10: {
                    this.idBuffer.fromRaw(raw, ptr);
                    this.lookupBlob((AnyObjectId)this.idBuffer).flags |= 4;
                    continue block5;
                }
                case 4: {
                    this.idBuffer.fromRaw(raw, ptr);
                    this.markTreeUninteresting(this.lookupTree(this.idBuffer));
                    continue block5;
                }
                case 14: {
                    continue block5;
                }
                default: {
                    this.idBuffer.fromRaw(raw, ptr);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", mode), this.idBuffer.name(), "", tree));
                }
            }
        }
    }

    private TreeVisit newTreeVisit(RevObject obj) throws LargeObjectException, MissingObjectException, IncorrectObjectTypeException, IOException {
        TreeVisit tv = this.freeVisit;
        if (tv != null) {
            this.freeVisit = tv.parent;
            tv.ptr = 0;
            tv.namePtr = 0;
            tv.nameEnd = 0;
            tv.pathLen = 0;
        } else {
            tv = new TreeVisit();
        }
        tv.obj = obj;
        tv.buf = this.reader.open(obj, 2).getCachedBytes();
        return tv;
    }

    private void releaseTreeVisit(TreeVisit tv) {
        tv.buf = null;
        tv.parent = this.freeVisit;
        this.freeVisit = tv;
    }

    private static class TreeVisit {
        TreeVisit parent;
        RevObject obj;
        byte[] buf;
        int ptr;
        int namePtr;
        int nameEnd;
        int pathLen;

        private TreeVisit() {
        }
    }
}

