/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.Holder;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.io.AutoLFInputStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    protected static final Entry[] EOF = new Entry[0];
    static final int BUFFER_SIZE = 2048;
    private static final long MAXIMUM_FILE_SIZE_TO_READ_FULLY = 65536L;
    private final IteratorState state;
    private byte[] contentId;
    private int contentIdFromPtr;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    private Holder<String> cleanFilterCommandHolder;
    private Holder<CoreConfig.EolStreamType> eolStreamTypeHolder;
    protected Repository repository;
    private long canonLen = -1L;
    private int contentIdOffset;
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry a, Entry b) {
            return Paths.compare(a.encodedName, 0, a.encodedNameLen, a.getMode().getBits(), b.encodedName, 0, b.encodedNameLen, b.getMode().getBits());
        }
    };

    protected WorkingTreeIterator(WorkingTreeOptions options) {
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(String prefix, WorkingTreeOptions options) {
        super(prefix);
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.state = p.state;
        this.repository = p.repository;
    }

    protected void initRootIterator(Repository repo) {
        this.repository = repo;
        Entry entry = this.ignoreNode instanceof PerDirectoryIgnoreNode ? ((PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new RootIgnoreNode(entry, repo);
    }

    public void setDirCacheIterator(TreeWalk walk, int treeId) {
        this.state.walk = walk;
        this.state.dirCacheTree = treeId;
    }

    @Override
    public boolean hasId() {
        if (this.contentIdFromPtr == this.ptr) {
            return true;
        }
        return (this.mode & 0xF000) == 32768;
    }

    @Override
    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        if (this.state.walk != null) {
            DirCacheIterator i = this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
            if (i != null) {
                DirCacheEntry ent = i.getDirCacheEntry();
                if (ent != null && this.compareMetadata(ent) == MetadataDiff.EQUAL) {
                    this.contentIdOffset = i.idOffset();
                    this.contentIdFromPtr = this.ptr;
                    this.contentId = i.idBuffer();
                    return this.contentId;
                }
                this.contentIdOffset = 0;
            } else {
                this.contentIdOffset = 0;
            }
        }
        switch (this.mode & 0xF000) {
            case 32768: 
            case 40960: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 57344: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idSubmodule(this.entries[this.ptr]);
                return this.contentId;
            }
        }
        return zeroid;
    }

    protected byte[] idSubmodule(Entry e) {
        File directory;
        if (this.repository == null) {
            return zeroid;
        }
        try {
            directory = this.repository.getWorkTree();
        }
        catch (NoWorkTreeException nwte) {
            return zeroid;
        }
        return this.idSubmodule(directory, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] idSubmodule(File directory, Entry e) {
        ObjectId head;
        Repository submoduleRepo;
        try {
            submoduleRepo = SubmoduleWalk.getSubmoduleRepository(directory, e.getName());
        }
        catch (IOException exception) {
            return zeroid;
        }
        if (submoduleRepo == null) {
            return zeroid;
        }
        try {
            head = submoduleRepo.resolve("HEAD");
        }
        catch (IOException exception) {
            byte[] byArray = zeroid;
            return byArray;
        }
        finally {
            submoduleRepo.close();
        }
        if (head == null) {
            return zeroid;
        }
        byte[] id = new byte[20];
        head.copyRawTo(id, 0);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] idBufferBlob(Entry e) {
        byte[] byArray;
        InputStream is = e.openInputStream();
        if (is == null) {
            return zeroid;
        }
        try {
            this.state.initializeDigestAndReadBuffer();
            long len = e.getLength();
            InputStream filteredIs = this.possiblyFilteredInputStream(e, is, len);
            byArray = this.computeHash(filteredIs, this.canonLen);
        }
        catch (Throwable throwable) {
            try {
                WorkingTreeIterator.safeClose(is);
                throw throwable;
            }
            catch (IOException err) {
                return zeroid;
            }
        }
        WorkingTreeIterator.safeClose(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream possiblyFilteredInputStream(Entry e, InputStream is, long len) throws IOException {
        if (this.getCleanFilterCommand() == null && this.getEolStreamType() == CoreConfig.EolStreamType.DIRECT) {
            this.canonLen = len;
            return is;
        }
        if (len <= 65536L) {
            int n;
            ByteBuffer rawbuf = IO.readWholeStream(is, (int)len);
            byte[] raw = rawbuf.array();
            if (!WorkingTreeIterator.isBinary(raw, n = rawbuf.limit())) {
                rawbuf = this.filterClean(raw, n);
                raw = rawbuf.array();
                n = rawbuf.limit();
            }
            this.canonLen = n;
            return new ByteArrayInputStream(raw, 0, n);
        }
        if (this.getCleanFilterCommand() == null && WorkingTreeIterator.isBinary(e)) {
            this.canonLen = len;
            return is;
        }
        InputStream lenIs = this.filterClean(e.openInputStream());
        try {
            this.canonLen = WorkingTreeIterator.computeLength(lenIs);
        }
        finally {
            WorkingTreeIterator.safeClose(lenIs);
        }
        return this.filterClean(is);
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isBinary(byte[] content, int sz) {
        return RawText.isBinary(content, sz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isBinary(Entry entry) throws IOException {
        InputStream in = entry.openInputStream();
        try {
            boolean bl = RawText.isBinary(in);
            return bl;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer filterClean(byte[] src, int n) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        try {
            ByteBuffer byteBuffer = IO.readWholeStream(this.filterClean(in), n);
            return byteBuffer;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    private InputStream filterClean(InputStream in) throws IOException {
        in = this.handleAutoCRLF(in);
        String filterCommand = this.getCleanFilterCommand();
        if (filterCommand != null) {
            FS.ExecutionResult result;
            FS fs = this.repository.getFS();
            ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
            filterProcessBuilder.directory(this.repository.getWorkTree());
            filterProcessBuilder.environment().put("GIT_DIR", this.repository.getDirectory().getAbsolutePath());
            try {
                result = fs.execute(filterProcessBuilder, in);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException(new FilterFailedException(e, filterCommand, this.getEntryPathString()));
            }
            int rc = result.getRc();
            if (rc != 0) {
                throw new IOException(new FilterFailedException(rc, filterCommand, this.getEntryPathString(), result.getStdout().toByteArray(10240), RawParseUtils.decode(result.getStderr().toByteArray(10240))));
            }
            return result.getStdout().openInputStream();
        }
        return in;
    }

    private InputStream handleAutoCRLF(InputStream in) throws IOException {
        return EolStreamTypeUtil.wrapInputStream(in, this.getEolStreamType());
    }

    public WorkingTreeOptions getOptions() {
        return this.state.options;
    }

    @Override
    public int idOffset() {
        return this.contentIdOffset;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = 0;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == 0;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    @Override
    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    @Override
    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e = this.entries[this.ptr];
        this.mode = e.getMode().getBits();
        int nameLen = e.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
        this.canonLen = -1L;
        this.cleanFilterCommandHolder = null;
        this.eolStreamTypeHolder = null;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryContentLength() throws IOException {
        if (this.canonLen == -1L) {
            long rawLen = this.getEntryLength();
            if (rawLen == 0L) {
                this.canonLen = 0L;
            }
            InputStream is = this.current().openInputStream();
            try {
                this.possiblyFilteredInputStream(this.current(), is, this.current().getLength());
            }
            finally {
                WorkingTreeIterator.safeClose(is);
            }
        }
        return this.canonLen;
    }

    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    public InputStream openEntryStream() throws IOException {
        InputStream rawis = this.current().openInputStream();
        if (this.getCleanFilterCommand() == null && this.getEolStreamType() == CoreConfig.EolStreamType.DIRECT) {
            return rawis;
        }
        return this.filterClean(rawis);
    }

    public boolean isEntryIgnored() throws IOException {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int pLen) throws IOException {
        return this.isEntryIgnored(pLen, this.mode, false);
    }

    private boolean isEntryIgnored(int pLen, int fileMode, boolean negatePrevious) throws IOException {
        IgnoreNode rules = this.getIgnoreNode();
        if (rules != null) {
            int pOff = this.pathOffset;
            if (0 < pOff) {
                --pOff;
            }
            String p = TreeWalk.pathOf(this.path, pOff, pLen);
            switch (rules.isIgnored(p, FileMode.TREE.equals(fileMode), negatePrevious)) {
                case IGNORED: {
                    return true;
                }
                case NOT_IGNORED: {
                    return false;
                }
                case CHECK_PARENT: {
                    negatePrevious = false;
                    break;
                }
                case CHECK_PARENT_NEGATE_FIRST_MATCH: {
                    negatePrevious = true;
                }
            }
        }
        if (this.parent instanceof WorkingTreeIterator) {
            return ((WorkingTreeIterator)this.parent).isEntryIgnored(pLen, fileMode, negatePrevious);
        }
        return false;
    }

    private IgnoreNode getIgnoreNode() throws IOException {
        if (this.ignoreNode instanceof PerDirectoryIgnoreNode) {
            this.ignoreNode = ((PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    public AttributesNode getEntryAttributesNode() throws IOException {
        if (this.attributesNode instanceof PerDirectoryAttributesNode) {
            this.attributesNode = ((PerDirectoryAttributesNode)this.attributesNode).load();
        }
        return this.attributesNode;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        CharsetEncoder nameEncoder = this.state.nameEncoder;
        int o = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            String name;
            Entry e = this.entries[i];
            if (e == null || ".".equals(name = e.getName()) || "..".equals(name) || ".git".equals(name)) continue;
            if (".gitignore".equals(name)) {
                this.ignoreNode = new PerDirectoryIgnoreNode(e);
            }
            if (".gitattributes".equals(name)) {
                this.attributesNode = new PerDirectoryAttributesNode(e);
            }
            if (i != o) {
                this.entries[o] = e;
            }
            e.encodeName(nameEncoder);
            ++o;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        } else if (this.pathLen == 0) {
            this.pathLen = this.pathOffset;
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModeDifferent(int rawMode) {
        int modeDiff = this.getEntryRawMode() ^ rawMode;
        if (modeDiff == 0) {
            return false;
        }
        if (this.getOptions().getSymLinks() == CoreConfig.SymLinks.FALSE && FileMode.SYMLINK.equals(rawMode)) {
            return false;
        }
        if (!this.state.options.isFileMode()) {
            modeDiff &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        return modeDiff != 0;
    }

    public MetadataDiff compareMetadata(DirCacheEntry entry) {
        if (entry.isAssumeValid()) {
            return MetadataDiff.EQUAL;
        }
        if (entry.isUpdateNeeded()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (!entry.isSmudged() && entry.getLength() != (int)this.getEntryLength()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (this.isModeDifferent(entry.getRawMode())) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        long cacheLastModified = entry.getLastModified();
        long fileLastModified = this.getEntryLastModified();
        long lastModifiedMillis = fileLastModified % 1000L;
        long cacheMillis = cacheLastModified % 1000L;
        if (this.getOptions().getCheckStat() == CoreConfig.CheckStat.MINIMAL) {
            fileLastModified -= lastModifiedMillis;
            cacheLastModified -= cacheMillis;
        } else if (cacheMillis == 0L) {
            fileLastModified -= lastModifiedMillis;
        } else if (lastModifiedMillis == 0L) {
            cacheLastModified -= cacheMillis;
        }
        if (fileLastModified != cacheLastModified) {
            return MetadataDiff.DIFFER_BY_TIMESTAMP;
        }
        if (!entry.isSmudged()) {
            return MetadataDiff.EQUAL;
        }
        return MetadataDiff.SMUDGED;
    }

    public boolean isModified(DirCacheEntry entry, boolean forceContentCheck, ObjectReader reader) throws IOException {
        if (entry == null) {
            return !FileMode.MISSING.equals(this.getEntryFileMode());
        }
        MetadataDiff diff = this.compareMetadata(entry);
        switch (diff) {
            case DIFFER_BY_TIMESTAMP: {
                if (forceContentCheck) {
                    return this.contentCheck(entry, reader);
                }
                return true;
            }
            case SMUDGED: {
                return this.contentCheck(entry, reader);
            }
            case EQUAL: {
                return false;
            }
            case DIFFER_BY_METADATA: {
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(entry, reader);
                }
                return true;
            }
        }
        throw new IllegalStateException(MessageFormat.format(JGitText.get().unexpectedCompareResult, diff.name()));
    }

    public FileMode getIndexFileMode(DirCacheIterator indexIter) {
        FileMode wtMode = this.getEntryFileMode();
        if (indexIter == null) {
            return wtMode;
        }
        if (this.getOptions().isFileMode()) {
            return wtMode;
        }
        FileMode iMode = indexIter.getEntryFileMode();
        if (FileMode.REGULAR_FILE == wtMode && FileMode.EXECUTABLE_FILE == iMode) {
            return iMode;
        }
        if (FileMode.EXECUTABLE_FILE == wtMode && FileMode.REGULAR_FILE == iMode) {
            return iMode;
        }
        return wtMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentCheck(DirCacheEntry entry, ObjectReader reader) throws IOException {
        if (this.getEntryObjectId().equals(entry.getObjectId())) {
            entry.setLength((int)this.getEntryLength());
            return false;
        }
        if (this.mode == FileMode.SYMLINK.getBits()) {
            if (new File(WorkingTreeIterator.readContentAsNormalizedString(this.current())).equals(new File(WorkingTreeIterator.readContentAsNormalizedString(entry, reader)))) return false;
            return true;
        }
        if (reader == null) {
            return true;
        }
        switch (this.getEolStreamType()) {
            case DIRECT: {
                return true;
            }
        }
        try {
            long dcInLen;
            Throwable throwable;
            AutoLFInputStream dcIn;
            ObjectLoader loader = reader.open(entry.getObjectId());
            if (loader == null) {
                return true;
            }
            try {
                dcIn = new AutoLFInputStream(loader.openStream(), true, true);
                throwable = null;
                try {
                    dcInLen = WorkingTreeIterator.computeLength(dcIn);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (dcIn != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)dcIn).close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            ((InputStream)dcIn).close();
                        }
                    }
                }
            }
            catch (AutoLFInputStream.IsBinaryException e) {
                return true;
            }
            dcIn = new AutoLFInputStream(loader.openStream(), true);
            throwable = null;
            try {
                boolean changed;
                byte[] autoCrLfHash = this.computeHash(dcIn, dcInLen);
                boolean bl = changed = this.getEntryObjectId().compareTo(autoCrLfHash, 0) != 0;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dcIn != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)dcIn).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((InputStream)dcIn).close();
                    }
                }
            }
        }
        catch (IOException e) {
            return true;
        }
    }

    private static String readContentAsNormalizedString(DirCacheEntry entry, ObjectReader reader) throws MissingObjectException, IOException {
        ObjectLoader open = reader.open(entry.getObjectId());
        byte[] cachedBytes = open.getCachedBytes();
        return FS.detect().normalize(RawParseUtils.decode(cachedBytes));
    }

    private static String readContentAsNormalizedString(Entry entry) throws IOException {
        long length = entry.getLength();
        byte[] content = new byte[(int)length];
        InputStream is = entry.openInputStream();
        IO.readFully(is, content, 0, (int)length);
        return FS.detect().normalize(RawParseUtils.decode(content));
    }

    private static long computeLength(InputStream in) throws IOException {
        long n;
        long length = 0L;
        while ((n = in.skip(0x100000L)) > 0L) {
            length += n;
        }
        return length;
    }

    private byte[] computeHash(InputStream in, long length) throws IOException {
        int r;
        MessageDigest contentDigest = this.state.contentDigest;
        byte[] contentReadBuffer = this.state.contentReadBuffer;
        contentDigest.reset();
        contentDigest.update(hblob);
        contentDigest.update((byte)32);
        long sz = length;
        if (sz == 0L) {
            contentDigest.update((byte)48);
        } else {
            int bufn;
            int p = bufn = contentReadBuffer.length;
            do {
                contentReadBuffer[--p] = digits[(int)(sz % 10L)];
            } while ((sz /= 10L) > 0L);
            contentDigest.update(contentReadBuffer, p, bufn - p);
        }
        contentDigest.update((byte)0);
        while ((r = in.read(contentReadBuffer)) > 0) {
            contentDigest.update(contentReadBuffer, 0, r);
            sz += (long)r;
        }
        if (sz != length) {
            return zeroid;
        }
        return contentDigest.digest();
    }

    public String getCleanFilterCommand() throws IOException {
        if (this.cleanFilterCommandHolder == null) {
            String cmd = null;
            if (this.state.walk != null) {
                cmd = this.state.walk.getFilterCommand("clean");
            }
            this.cleanFilterCommandHolder = new Holder<Object>(cmd);
        }
        return this.cleanFilterCommandHolder.get();
    }

    public CoreConfig.EolStreamType getEolStreamType() throws IOException {
        if (this.eolStreamTypeHolder == null) {
            CoreConfig.EolStreamType type = null;
            if (this.state.walk != null) {
                type = this.state.walk.getEolStreamType();
            } else {
                switch (this.getOptions().getAutoCRLF()) {
                    case FALSE: {
                        type = CoreConfig.EolStreamType.DIRECT;
                        break;
                    }
                    case TRUE: 
                    case INPUT: {
                        type = CoreConfig.EolStreamType.AUTO_LF;
                    }
                }
            }
            this.eolStreamTypeHolder = new Holder<CoreConfig.EolStreamType>(type);
        }
        return this.eolStreamTypeHolder.get();
    }

    protected static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        protected Entry() {
        }

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b;
            try {
                b = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()));
            }
            this.encodedNameLen = b.limit();
            if (b.hasArray() && b.arrayOffset() == 0) {
                this.encodedName = b.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b.get(this.encodedName);
            }
        }

        public String toString() {
            return this.getMode().toString() + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        public abstract long getLastModified();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }

    private static final class IteratorState {
        final WorkingTreeOptions options;
        final CharsetEncoder nameEncoder;
        MessageDigest contentDigest;
        byte[] contentReadBuffer;
        TreeWalk walk;
        int dirCacheTree;

        IteratorState(WorkingTreeOptions options) {
            this.options = options;
            this.nameEncoder = Constants.CHARSET.newEncoder();
        }

        void initializeDigestAndReadBuffer() {
            if (this.contentDigest == null) {
                this.contentDigest = Constants.newMessageDigest();
                this.contentReadBuffer = new byte[2048];
            }
        }
    }

    public static enum MetadataDiff {
        EQUAL,
        DIFFER_BY_METADATA,
        SMUDGED,
        DIFFER_BY_TIMESTAMP;

    }

    private static class PerDirectoryAttributesNode
    extends AttributesNode {
        final Entry entry;

        PerDirectoryAttributesNode(Entry entry) {
            super(Collections.emptyList());
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributesNode load() throws IOException {
            AttributesNode r = new AttributesNode();
            try (InputStream in = this.entry.openInputStream();){
                r.parse(in);
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    private static class PerDirectoryIgnoreNode
    extends IgnoreNode {
        final Entry entry;

        PerDirectoryIgnoreNode(Entry entry) {
            super(Collections.emptyList());
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IgnoreNode load() throws IOException {
            IgnoreNode r = new IgnoreNode();
            try (InputStream in = this.entry.openInputStream();){
                r.parse(in);
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    private static class RootIgnoreNode
    extends PerDirectoryIgnoreNode {
        final Repository repository;

        RootIgnoreNode(Entry entry, Repository repository) {
            super(entry);
            this.repository = repository;
        }

        @Override
        IgnoreNode load() throws IOException {
            IgnoreNode r;
            if (this.entry != null) {
                r = super.load();
                if (r == null) {
                    r = new IgnoreNode();
                }
            } else {
                r = new IgnoreNode();
            }
            FS fs = this.repository.getFS();
            String path = this.repository.getConfig().get(CoreConfig.KEY).getExcludesFile();
            if (path != null) {
                File excludesfile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
                RootIgnoreNode.loadRulesFromFile(r, excludesfile);
            }
            File exclude = fs.resolve(this.repository.getDirectory(), "info/exclude");
            RootIgnoreNode.loadRulesFromFile(r, exclude);
            return r.getRules().isEmpty() ? null : r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void loadRulesFromFile(IgnoreNode r, File exclude) throws FileNotFoundException, IOException {
            if (FS.DETECTED.exists(exclude)) {
                try (FileInputStream in = new FileInputStream(exclude);){
                    r.parse(in);
                }
            }
        }
    }
}

