/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.ObjectId;

public final class FetchV2Request {
    private final List<ObjectId> peerHas;
    private final TreeMap<String, ObjectId> wantedRefs;
    private final Set<ObjectId> wantsIds;
    private final Set<ObjectId> clientShallowCommits;
    private final int shallowSince;
    private final List<String> shallowExcludeRefs;
    private final int depth;
    private final long filterBlobLimit;
    private final Set<String> options;

    private FetchV2Request(List<ObjectId> peerHas, TreeMap<String, ObjectId> wantedRefs, Set<ObjectId> wantsIds, Set<ObjectId> clientShallowCommits, int shallowSince, List<String> shallowExcludeRefs, int depth, long filterBlobLimit, Set<String> options) {
        this.peerHas = peerHas;
        this.wantedRefs = wantedRefs;
        this.wantsIds = wantsIds;
        this.clientShallowCommits = clientShallowCommits;
        this.shallowSince = shallowSince;
        this.shallowExcludeRefs = shallowExcludeRefs;
        this.depth = depth;
        this.filterBlobLimit = filterBlobLimit;
        this.options = options;
    }

    @NonNull
    List<ObjectId> getPeerHas() {
        return this.peerHas;
    }

    @NonNull
    Map<String, ObjectId> getWantedRefs() {
        return this.wantedRefs;
    }

    @NonNull
    Set<ObjectId> getWantsIds() {
        return this.wantsIds;
    }

    @NonNull
    Set<ObjectId> getClientShallowCommits() {
        return this.clientShallowCommits;
    }

    int getShallowSince() {
        return this.shallowSince;
    }

    @NonNull
    List<String> getShallowExcludeRefs() {
        return this.shallowExcludeRefs;
    }

    int getDepth() {
        return this.depth;
    }

    long getFilterBlobLimit() {
        return this.filterBlobLimit;
    }

    @NonNull
    Set<String> getOptions() {
        return this.options;
    }

    static Builder builder() {
        return new Builder();
    }

    /* synthetic */ FetchV2Request(List list, TreeMap treeMap, Set set, Set set2, int n, List list2, int n2, long l, Set set3, FetchV2Request fetchV2Request) {
        this(list, treeMap, set, set2, n, list2, n2, l, set3);
    }

    static final class Builder {
        List<ObjectId> peerHas = new ArrayList<ObjectId>();
        TreeMap<String, ObjectId> wantedRefs = new TreeMap();
        Set<ObjectId> wantsIds = new HashSet<ObjectId>();
        Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        List<String> shallowExcludeRefs = new ArrayList<String>();
        Set<String> options = new HashSet<String>();
        int depth;
        int shallowSince;
        long filterBlobLimit = -1L;

        private Builder() {
        }

        Builder addPeerHas(ObjectId objectId) {
            this.peerHas.add(objectId);
            return this;
        }

        Builder addWantedRef(String refName, ObjectId oid) {
            this.wantedRefs.put(refName, oid);
            return this;
        }

        Builder addOption(String option) {
            this.options.add(option);
            return this;
        }

        Builder addWantsIds(ObjectId objectId) {
            this.wantsIds.add(objectId);
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasShallowExcludeRefs() {
            return this.shallowExcludeRefs.size() > 0;
        }

        Builder addShallowExcludeRefs(String shallowExcludeRef) {
            this.shallowExcludeRefs.add(shallowExcludeRef);
            return this;
        }

        Builder setShallowSince(int value) {
            this.shallowSince = value;
            return this;
        }

        int getShallowSince() {
            return this.shallowSince;
        }

        Builder setFilterBlobLimit(long filterBlobLimit) {
            this.filterBlobLimit = filterBlobLimit;
            return this;
        }

        FetchV2Request build() {
            return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantsIds, this.clientShallowCommits, this.shallowSince, this.shallowExcludeRefs, this.depth, this.filterBlobLimit, this.options, null);
        }
    }
}

