/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.logging.PerformanceLogRecord;

public class PerformanceLogContext {
    private static final PerformanceLogContext INSTANCE = new PerformanceLogContext();
    private final ThreadLocal<List<PerformanceLogRecord>> eventRecords = new ThreadLocal();

    private PerformanceLogContext() {
        this.eventRecords.set(new ArrayList());
    }

    public static PerformanceLogContext getInstance() {
        return INSTANCE;
    }

    public List<PerformanceLogRecord> getEventRecords() {
        return Collections.unmodifiableList(this.eventRecords.get());
    }

    public void addEvent(PerformanceLogRecord record) {
        this.eventRecords.get().add(record);
    }

    public void cleanEvents() {
        this.eventRecords.get().clear();
    }
}

