/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(PackDirectory.class);
    private static final PackList NO_PACKS = new PackList(FileSnapshot.DIRTY, new PackFile[0]);
    private final Config config;
    private final File directory;
    private final AtomicReference<PackList> packList;

    PackDirectory(Config config, File directory) {
        this.config = config;
        this.directory = directory;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
    }

    File getDirectory() {
        return this.directory;
    }

    void create() throws IOException {
        FileUtils.mkdir(this.directory);
    }

    void close() {
        PackList packs = this.packList.get();
        if (packs != NO_PACKS && this.packList.compareAndSet(packs, NO_PACKS)) {
            PackFile[] packFileArray = packs.packs;
            int n = packs.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                p.close();
                ++n2;
            }
        }
    }

    Collection<PackFile> getPacks() {
        PackList list = this.packList.get();
        if (list == NO_PACKS) {
            list = this.scanPacks(list);
        }
        PackFile[] packs = list.packs;
        return Collections.unmodifiableCollection(Arrays.asList(packs));
    }

    public String toString() {
        return "PackDirectory[" + this.getDirectory() + "]";
    }

    boolean has(AnyObjectId objectId) {
        PackList pList;
        do {
            pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    if (p.hasObject(objectId)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.warn(MessageFormat.format(JGitText.get().unableToReadPackfile, p.getPackFile().getAbsolutePath()), (Throwable)e);
                    this.remove(p);
                }
                ++n2;
            }
        } while (this.searchPacksAgain(pList));
        return false;
    }

    boolean resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) {
        PackList pList;
        int oldSize = matches.size();
        do {
            pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    p.resolve(matches, id, matchLimit);
                    p.resetTransientErrorCount();
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                if (matches.size() > matchLimit) {
                    return false;
                }
                ++n2;
            }
        } while (matches.size() == oldSize && this.searchPacksAgain(pList));
        return true;
    }

    ObjectLoader open(WindowCursor curs, AnyObjectId objectId) {
        block3: while (true) {
            PackList pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    ObjectLoader ldr = p.get(curs, objectId);
                    p.resetTransientErrorCount();
                    if (ldr != null) {
                        return ldr;
                    }
                }
                catch (PackMismatchException e) {
                    if (this.searchPacksAgain(pList)) {
                        continue block3;
                    }
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n2;
            }
            if (!this.searchPacksAgain(pList)) break;
        }
        return null;
    }

    long getSize(WindowCursor curs, AnyObjectId id) {
        block3: while (true) {
            PackList pList = this.packList.get();
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    long len = p.getObjectSize(curs, id);
                    p.resetTransientErrorCount();
                    if (0L <= len) {
                        return len;
                    }
                }
                catch (PackMismatchException e) {
                    if (this.searchPacksAgain(pList)) {
                        continue block3;
                    }
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n2;
            }
            if (!this.searchPacksAgain(pList)) break;
        }
        return -1L;
    }

    void selectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) {
        PackList pList = this.packList.get();
        block3: while (true) {
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    LocalObjectRepresentation rep = p.representation(curs, otp);
                    p.resetTransientErrorCount();
                    if (rep != null) {
                        packer.select(otp, rep);
                    }
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                    continue block3;
                }
                catch (IOException e) {
                    this.handlePackError(e, p);
                }
                ++n2;
            }
            break;
        }
    }

    private void handlePackError(IOException e, PackFile p) {
        String warnTmpl = null;
        int transientErrorCount = 0;
        String errTmpl = JGitText.get().exceptionWhileReadingPack;
        if (e instanceof CorruptObjectException || e instanceof PackInvalidException) {
            warnTmpl = JGitText.get().corruptPack;
            LOG.warn(MessageFormat.format(warnTmpl, p.getPackFile().getAbsolutePath()), (Throwable)e);
            this.remove(p);
        } else if (e instanceof FileNotFoundException) {
            if (p.getPackFile().exists()) {
                errTmpl = JGitText.get().packInaccessible;
                transientErrorCount = p.incrementTransientErrorCount();
            } else {
                warnTmpl = JGitText.get().packWasDeleted;
                this.remove(p);
            }
        } else if (FileUtils.isStaleFileHandleInCausalChain(e)) {
            warnTmpl = JGitText.get().packHandleIsStale;
            this.remove(p);
        } else {
            transientErrorCount = p.incrementTransientErrorCount();
        }
        if (warnTmpl != null) {
            LOG.warn(MessageFormat.format(warnTmpl, p.getPackFile().getAbsolutePath()), (Throwable)e);
        } else if (this.doLogExponentialBackoff(transientErrorCount)) {
            LOG.error(MessageFormat.format(errTmpl, p.getPackFile().getAbsolutePath(), transientErrorCount), (Throwable)e);
        }
    }

    private boolean doLogExponentialBackoff(int n) {
        return (n & n - 1) == 0;
    }

    boolean searchPacksAgain(PackList old) {
        boolean trustFolderStat = this.config.getBoolean("core", "trustfolderstat", true);
        return (!trustFolderStat || old.snapshot.isModified(this.directory)) && old != this.scanPacks(old);
    }

    void insert(PackFile pf) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            String name = pf.getPackFile().getName();
            PackFile[] packFileArray = oldList;
            int n2 = oldList.length;
            int n3 = 0;
            while (n3 < n2) {
                PackFile p = packFileArray[n3];
                if (name.equals(p.getPackFile().getName())) {
                    return;
                }
                ++n3;
            }
            newList = new PackFile[1 + oldList.length];
            newList[0] = pf;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
    }

    private void remove(PackFile deadPack) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            int j = PackDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new PackFile[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
        deadPack.close();
    }

    private static int indexOf(PackFile[] list, PackFile pack) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == pack) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, PackFile> forReuse = PackDirectory.reuseMap(old);
        FileSnapshot snapshot = FileSnapshot.save(this.directory);
        Set<String> names = this.listPackDirectory();
        ArrayList<PackFile> list = new ArrayList<PackFile>(names.size() >> 2);
        boolean foundNew = false;
        for (String indexName : names) {
            if (indexName.length() != 49 || !indexName.endsWith(".idx")) continue;
            String base = indexName.substring(0, indexName.length() - 3);
            int extensions = 0;
            PackExt[] packExtArray = PackExt.values();
            int n = packExtArray.length;
            int n2 = 0;
            while (n2 < n) {
                PackExt ext = packExtArray[n2];
                if (names.contains(String.valueOf(base) + ext.getExtension())) {
                    extensions |= ext.getBit();
                }
                ++n2;
            }
            if ((extensions & PackExt.PACK.getBit()) == 0) continue;
            String packName = String.valueOf(base) + PackExt.PACK.getExtension();
            File packFile = new File(this.directory, packName);
            PackFile oldPack = forReuse.get(packName);
            if (oldPack != null && !oldPack.getFileSnapshot().isModified(packFile)) {
                forReuse.remove(packName);
                list.add(oldPack);
                continue;
            }
            list.add(new PackFile(packFile, extensions));
            foundNew = true;
        }
        if (!foundNew && forReuse.isEmpty() && snapshot.equals(old.snapshot)) {
            old.snapshot.setClean(snapshot);
            return old;
        }
        for (PackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(snapshot, PackDirectory.NO_PACKS.packs);
        }
        PackFile[] r = list.toArray(new PackFile[0]);
        Arrays.sort(r, PackFile.SORT);
        return new PackList(snapshot, r);
    }

    private static Map<String, PackFile> reuseMap(PackList old) {
        HashMap<String, PackFile> forReuse = new HashMap<String, PackFile>();
        PackFile[] packFileArray = old.packs;
        int n = old.packs.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile p = packFileArray[n2];
            if (p.invalid()) {
                p.close();
            } else {
                PackFile prior = forReuse.put(p.getPackFile().getName(), p);
                if (prior != null) {
                    forReuse.put(prior.getPackFile().getName(), prior);
                    p.close();
                }
            }
            ++n2;
        }
        return forReuse;
    }

    private Set<String> listPackDirectory() {
        String[] nameList = this.directory.list();
        if (nameList == null) {
            return Collections.emptySet();
        }
        HashSet<String> nameSet = new HashSet<String>(nameList.length << 1);
        String[] stringArray = nameList;
        int n = nameList.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith("pack-")) {
                nameSet.add(name);
            }
            ++n2;
        }
        return nameSet;
    }

    static final class PackList {
        final FileSnapshot snapshot;
        final PackFile[] packs;

        PackList(FileSnapshot monitor, PackFile[] packs) {
            this.snapshot = monitor;
            this.packs = packs;
        }
    }
}

