/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.diffmergetool.CommandExecutor;
import org.eclipse.jgit.internal.diffmergetool.CommandLineDiffTool;
import org.eclipse.jgit.internal.diffmergetool.DiffToolConfig;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.ExternalToolUtils;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.PreDefinedDiffTool;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class DiffTools {
    private final Repository repo;
    private final DiffToolConfig config;
    private final Map<String, ExternalDiffTool> predefinedTools;
    private final Map<String, ExternalDiffTool> userDefinedTools;

    public DiffTools(Repository repo) {
        this.repo = repo;
        this.config = repo.getConfig().get(DiffToolConfig.KEY);
        this.predefinedTools = DiffTools.setupPredefinedTools();
        this.userDefinedTools = DiffTools.setupUserDefinedTools(this.config, this.predefinedTools);
    }

    public FS.ExecutionResult compare(FileElement localFile, FileElement remoteFile, FileElement mergedFile, String toolName, BooleanTriState prompt, BooleanTriState gui, BooleanTriState trustExitCode) throws ToolException {
        try {
            String command = ExternalToolUtils.prepareCommand(this.guessTool(toolName, gui).getCommand(), localFile, remoteFile, mergedFile, null);
            Map<String, String> env = ExternalToolUtils.prepareEnvironment(this.repo, localFile, remoteFile, mergedFile, null);
            boolean trust = this.config.isTrustExitCode();
            if (trustExitCode != BooleanTriState.UNSET) {
                trust = trustExitCode == BooleanTriState.TRUE;
            }
            CommandExecutor cmdExec = new CommandExecutor(this.repo.getFS(), trust);
            FS.ExecutionResult executionResult = cmdExec.run(command, this.repo.getWorkTree(), env);
            return executionResult;
        }
        catch (IOException | InterruptedException e) {
            throw new ToolException(e);
        }
        finally {
            localFile.cleanTemporaries();
            remoteFile.cleanTemporaries();
            mergedFile.cleanTemporaries();
        }
    }

    public Set<String> getToolNames() {
        return this.config.getToolNames();
    }

    public Map<String, ExternalDiffTool> getUserDefinedTools() {
        return Collections.unmodifiableMap(this.userDefinedTools);
    }

    public Map<String, ExternalDiffTool> getAvailableTools() {
        return Collections.unmodifiableMap(this.predefinedTools);
    }

    public Map<String, ExternalDiffTool> getNotAvailableTools() {
        return Collections.unmodifiableMap(new TreeMap());
    }

    public String getDefaultToolName(BooleanTriState gui) {
        return gui != BooleanTriState.UNSET ? "my_gui_tool" : this.config.getDefaultToolName();
    }

    public boolean isInteractive() {
        return this.config.isPrompt();
    }

    private ExternalDiffTool guessTool(String toolName, BooleanTriState gui) throws ToolException {
        ExternalDiffTool tool;
        if (StringUtils.isEmptyOrNull(toolName)) {
            toolName = this.getDefaultToolName(gui);
        }
        if ((tool = this.getTool(toolName)) == null) {
            throw new ToolException("Unknown diff tool " + toolName);
        }
        return tool;
    }

    private ExternalDiffTool getTool(String name) {
        ExternalDiffTool tool = this.userDefinedTools.get(name);
        if (tool == null) {
            tool = this.predefinedTools.get(name);
        }
        return tool;
    }

    private static Map<String, ExternalDiffTool> setupPredefinedTools() {
        TreeMap<String, ExternalDiffTool> tools = new TreeMap<String, ExternalDiffTool>();
        CommandLineDiffTool[] commandLineDiffToolArray = CommandLineDiffTool.values();
        int n = commandLineDiffToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineDiffTool tool = commandLineDiffToolArray[n2];
            tools.put(tool.name(), new PreDefinedDiffTool(tool));
            ++n2;
        }
        return tools;
    }

    private static Map<String, ExternalDiffTool> setupUserDefinedTools(DiffToolConfig cfg, Map<String, ExternalDiffTool> predefTools) {
        TreeMap<String, ExternalDiffTool> tools = new TreeMap<String, ExternalDiffTool>();
        Map<String, ExternalDiffTool> userTools = cfg.getTools();
        for (String name : userTools.keySet()) {
            PreDefinedDiffTool predefTool;
            ExternalDiffTool userTool = userTools.get(name);
            if (userTool.getCommand() != null) {
                tools.put(name, userTool);
                continue;
            }
            if (userTool.getPath() == null || (predefTool = (PreDefinedDiffTool)predefTools.get(name)) == null) continue;
            predefTool.setPath(userTool.getPath());
        }
        return tools;
    }
}

