/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.lib.Repository;

public class ExternalToolUtils {
    public static String prepareCommand(String command, FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile) throws IOException {
        command = localFile.replaceVariable(command);
        command = remoteFile.replaceVariable(command);
        command = mergedFile.replaceVariable(command);
        if (baseFile != null) {
            command = baseFile.replaceVariable(command);
        }
        return command;
    }

    public static Map<String, String> prepareEnvironment(Repository repo, FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile) throws IOException {
        TreeMap<String, String> env = new TreeMap<String, String>();
        env.put("GIT_DIR", repo.getDirectory().getAbsolutePath());
        localFile.addToEnv(env);
        remoteFile.addToEnv(env);
        mergedFile.addToEnv(env);
        if (baseFile != null) {
            baseFile.addToEnv(env);
        }
        return env;
    }
}

