/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class FileElement {
    private final String path;
    private final Type type;
    private InputStream stream;
    private File tempFile;

    public FileElement(String path, Type type) {
        this(path, type, null, null);
    }

    public FileElement(String path, Type type, File tempFile, InputStream stream) {
        this.path = path;
        this.type = type;
        this.tempFile = tempFile;
        this.stream = stream;
    }

    public String getPath() {
        return this.path;
    }

    public Type getType() {
        return this.type;
    }

    public File getFile(File directory, String midName) throws IOException {
        if (this.tempFile != null && this.stream == null) {
            return this.tempFile;
        }
        this.tempFile = FileElement.getTempFile(this.path, directory, midName);
        return FileElement.copyFromStream(this.tempFile, this.stream);
    }

    public File getFile() throws IOException {
        if (this.tempFile != null && this.stream == null) {
            return this.tempFile;
        }
        File file = new File(this.path);
        if (this.stream != null || this.isNullPath()) {
            this.tempFile = FileElement.getTempFile(file);
            return FileElement.copyFromStream(this.tempFile, this.stream);
        }
        return file;
    }

    public boolean isNullPath() {
        return this.path.equals("/dev/null");
    }

    public File createTempFile(File directory) throws IOException {
        if (this.tempFile == null) {
            File file = new File(this.path);
            this.tempFile = directory != null ? FileElement.getTempFile(file, directory, this.type.name()) : FileElement.getTempFile(file);
        }
        return this.tempFile;
    }

    private static File getTempFile(File file) throws IOException {
        return File.createTempFile(".__", "__" + file.getName());
    }

    private static File getTempFile(File file, File directory, String midName) throws IOException {
        String[] fileNameAndExtension = FileElement.splitBaseFileNameAndExtension(file);
        return File.createTempFile(String.valueOf(fileNameAndExtension[0]) + "_" + midName + "_", fileNameAndExtension[1], directory);
    }

    private static File getTempFile(String path, File directory, String midName) throws IOException {
        return FileElement.getTempFile(new File(path), directory, midName);
    }

    public void cleanTemporaries() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
        this.tempFile = null;
    }

    private static File copyFromStream(File file, InputStream stream) throws IOException, FileNotFoundException {
        if (stream != null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileOutputStream outStream = new FileOutputStream(file);){
                    int read = 0;
                    byte[] bytes = new byte[8192];
                    while ((read = stream.read(bytes)) != -1) {
                        ((OutputStream)outStream).write(bytes, 0, read);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private static String[] splitBaseFileNameAndExtension(File file) {
        String[] result = new String[]{file.getName(), ""};
        int idx = result[0].lastIndexOf(".");
        if (idx > 0) {
            result[1] = result[0].substring(idx, result[0].length());
            result[0] = result[0].substring(0, idx);
        }
        return result;
    }

    public String replaceVariable(String input) throws IOException {
        return input.replace("$" + this.type.name(), this.getFile().getPath());
    }

    public void addToEnv(Map<String, String> env) throws IOException {
        env.put(this.type.name(), this.getFile().getPath());
    }

    public static enum Type {
        LOCAL,
        REMOTE,
        MERGED,
        BASE,
        BACKUP;

    }
}

