/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.diffmergetool.CommandExecutor;
import org.eclipse.jgit.internal.diffmergetool.CommandLineMergeTool;
import org.eclipse.jgit.internal.diffmergetool.ExternalMergeTool;
import org.eclipse.jgit.internal.diffmergetool.ExternalToolUtils;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.MergeToolConfig;
import org.eclipse.jgit.internal.diffmergetool.PreDefinedMergeTool;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.util.FS;

public class MergeTools {
    Repository repo;
    private final MergeToolConfig config;
    private final Map<String, ExternalMergeTool> predefinedTools;
    private final Map<String, ExternalMergeTool> userDefinedTools;

    public MergeTools(Repository repo) {
        this.repo = repo;
        this.config = repo.getConfig().get(MergeToolConfig.KEY);
        this.predefinedTools = this.setupPredefinedTools();
        this.userDefinedTools = this.setupUserDefinedTools(this.config, this.predefinedTools);
    }

    public FS.ExecutionResult merge(FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile, File tempDir, String toolName, BooleanTriState prompt, BooleanTriState gui) throws ToolException {
        ExternalMergeTool tool = this.guessTool(toolName, gui);
        FileElement backup = null;
        FS.ExecutionResult result = null;
        try {
            File workingDir = this.repo.getWorkTree();
            backup = this.createBackupFile(mergedFile.getPath(), tempDir != null ? tempDir : workingDir);
            boolean trust = tool.getTrustExitCode() == BooleanTriState.TRUE;
            String command = ExternalToolUtils.prepareCommand(tool.getCommand(baseFile != null), localFile, remoteFile, mergedFile, baseFile);
            Map<String, String> env = ExternalToolUtils.prepareEnvironment(this.repo, localFile, remoteFile, mergedFile, baseFile);
            CommandExecutor cmdExec = new CommandExecutor(this.repo.getFS(), trust);
            result = cmdExec.run(command, workingDir, env);
            if (backup != null) {
                this.keepBackupFile(mergedFile.getPath(), backup);
            }
            FS.ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (IOException | InterruptedException e) {
            throw new ToolException(e);
        }
        finally {
            if (backup != null) {
                backup.cleanTemporaries();
            }
            if (result != null || !this.config.isKeepTemporaries()) {
                localFile.cleanTemporaries();
                remoteFile.cleanTemporaries();
                if (baseFile != null) {
                    baseFile.cleanTemporaries();
                }
                if (this.config.isWriteToTemp() && tempDir != null && tempDir.exists()) {
                    tempDir.delete();
                }
            }
        }
    }

    private FileElement createBackupFile(String filePath, File parentDir) throws IOException {
        FileElement backup = null;
        Path path = Paths.get(filePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            backup = new FileElement(filePath, FileElement.Type.BACKUP);
            Files.copy(path, backup.createTempFile(parentDir).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return backup;
    }

    public File createTempDirectory() throws IOException {
        return this.config.isWriteToTemp() ? Files.createTempDirectory("jgit-mergetool-", new FileAttribute[0]).toFile() : null;
    }

    public Set<String> getToolNames() {
        return this.config.getToolNames();
    }

    public Map<String, ExternalMergeTool> getUserDefinedTools() {
        return this.userDefinedTools;
    }

    public Map<String, ExternalMergeTool> getAvailableTools() {
        return this.predefinedTools;
    }

    public Map<String, ExternalMergeTool> getNotAvailableTools() {
        return new TreeMap<String, ExternalMergeTool>();
    }

    public String getDefaultToolName(BooleanTriState gui) {
        return gui != BooleanTriState.UNSET ? "my_gui_tool" : this.config.getDefaultToolName();
    }

    public boolean isInteractive() {
        return this.config.isPrompt();
    }

    private ExternalMergeTool guessTool(String toolName, BooleanTriState gui) throws ToolException {
        ExternalMergeTool tool;
        if (toolName == null || toolName.isEmpty()) {
            toolName = this.getDefaultToolName(gui);
        }
        if ((tool = this.getTool(toolName)) == null) {
            throw new ToolException("Unknown diff tool " + toolName);
        }
        return tool;
    }

    private ExternalMergeTool getTool(String name) {
        ExternalMergeTool tool = this.userDefinedTools.get(name);
        if (tool == null) {
            tool = this.predefinedTools.get(name);
        }
        return tool;
    }

    private void keepBackupFile(String mergedFilePath, FileElement backup) throws IOException {
        if (this.config.isKeepBackup()) {
            Path backupPath = backup.getFile().toPath();
            Files.move(backupPath, backupPath.resolveSibling(Paths.get(mergedFilePath, new String[0]).getFileName() + ".orig"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Map<String, ExternalMergeTool> setupPredefinedTools() {
        TreeMap<String, ExternalMergeTool> tools = new TreeMap<String, ExternalMergeTool>();
        CommandLineMergeTool[] commandLineMergeToolArray = CommandLineMergeTool.values();
        int n = commandLineMergeToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineMergeTool tool = commandLineMergeToolArray[n2];
            tools.put(tool.name(), new PreDefinedMergeTool(tool));
            ++n2;
        }
        return tools;
    }

    private Map<String, ExternalMergeTool> setupUserDefinedTools(MergeToolConfig cfg, Map<String, ExternalMergeTool> predefTools) {
        TreeMap<String, ExternalMergeTool> tools = new TreeMap<String, ExternalMergeTool>();
        Map<String, ExternalMergeTool> userTools = cfg.getTools();
        for (String name : userTools.keySet()) {
            PreDefinedMergeTool predefTool;
            ExternalMergeTool userTool = userTools.get(name);
            if (userTool.getCommand() != null) {
                tools.put(name, userTool);
                continue;
            }
            if (userTool.getPath() == null || (predefTool = (PreDefinedMergeTool)predefTools.get(name)) == null) continue;
            predefTool.setPath(userTool.getPath());
            if (userTool.getTrustExitCode() == BooleanTriState.UNSET) continue;
            predefTool.setTrustExitCode(userTool.getTrustExitCode());
        }
        return tools;
    }
}

