/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class WorkTreeUpdater
implements Closeable {
    Result result = new Result();
    @Nullable
    private final Repository repo;
    private final boolean inCore;
    private final ObjectInserter inserter;
    private final ObjectReader reader;
    private DirCache dirCache;
    private boolean implicitDirCache = false;
    private DirCacheBuilder builder = null;
    private WorkingTreeOptions workingTreeOptions;
    private int inCoreFileSizeLimit;
    private final Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
    private final TreeMap<String, File> toBeDeleted = new TreeMap();
    private Map<String, DirCacheCheckout.CheckoutMetadata> checkoutMetadata;
    private Map<String, DirCacheCheckout.CheckoutMetadata> cleanupMetadata;
    private boolean indexChangesWritten = false;

    private WorkTreeUpdater(Repository repo, DirCache dirCache) {
        this.repo = repo;
        this.dirCache = dirCache;
        this.inCore = false;
        this.inserter = repo.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.workingTreeOptions = repo.getConfig().get(WorkingTreeOptions.KEY);
        this.checkoutMetadata = new HashMap<String, DirCacheCheckout.CheckoutMetadata>();
        this.cleanupMetadata = new HashMap<String, DirCacheCheckout.CheckoutMetadata>();
        this.inCoreFileSizeLimit = WorkTreeUpdater.setInCoreFileSizeLimit(repo.getConfig());
    }

    public static WorkTreeUpdater createWorkTreeUpdater(Repository repo, DirCache dirCache) {
        return new WorkTreeUpdater(repo, dirCache);
    }

    private WorkTreeUpdater(Repository repo, DirCache dirCache, ObjectInserter oi) {
        this.repo = repo;
        this.dirCache = dirCache;
        this.inserter = oi;
        this.inCore = true;
        this.reader = oi.newReader();
        if (repo != null) {
            this.inCoreFileSizeLimit = WorkTreeUpdater.setInCoreFileSizeLimit(repo.getConfig());
        }
    }

    public static WorkTreeUpdater createInCoreWorkTreeUpdater(Repository repo, DirCache dirCache, ObjectInserter oi) {
        return new WorkTreeUpdater(repo, dirCache, oi);
    }

    public static StreamLoader createStreamLoader(StreamSupplier supplier, long length) {
        return new StreamLoader(supplier, length);
    }

    private static int setInCoreFileSizeLimit(Config config) {
        return config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    public int getInCoreFileSizeLimit() {
        return this.inCoreFileSizeLimit;
    }

    public DirCache getLockedDirCache() throws IOException {
        if (this.dirCache == null) {
            this.implicitDirCache = true;
            this.dirCache = this.inCore ? DirCache.newInCore() : this.nonNullNonBareRepo().lockDirCache();
        }
        if (this.builder == null) {
            this.builder = this.dirCache.builder();
        }
        return this.dirCache;
    }

    public DirCacheBuildIterator createDirCacheBuildIterator() {
        return new DirCacheBuildIterator(this.builder);
    }

    public void writeWorkTreeChanges(boolean shouldCheckoutTheirs) throws IOException {
        this.handleDeletedFiles();
        if (this.inCore) {
            this.builder.finish();
            return;
        }
        if (shouldCheckoutTheirs) {
            this.checkout();
        }
        if (!this.builder.commit()) {
            this.revertModifiedFiles();
            throw new IndexWriteException();
        }
    }

    public Result writeIndexChanges() throws IOException {
        this.result.treeId = this.getLockedDirCache().writeTree(this.inserter);
        this.indexChangesWritten = true;
        return this.result;
    }

    public void addToCheckout(String path, DirCacheEntry entry, CoreConfig.EolStreamType cleanupStreamType, String cleanupSmudgeCommand, CoreConfig.EolStreamType checkoutStreamType, String checkoutSmudgeCommand) {
        if (entry != null) {
            this.toBeCheckedOut.put(path, entry);
        }
        this.addCheckoutMetadata(this.cleanupMetadata, path, cleanupStreamType, cleanupSmudgeCommand);
        this.addCheckoutMetadata(this.checkoutMetadata, path, checkoutStreamType, checkoutSmudgeCommand);
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public void deleteFile(String path, File file, CoreConfig.EolStreamType streamType, String smudgeCommand) throws IOException {
        this.toBeDeleted.put(path, file);
        if (file != null && file.isFile()) {
            this.addCheckoutMetadata(this.cleanupMetadata, path, streamType, smudgeCommand);
        }
    }

    private void addCheckoutMetadata(Map<String, DirCacheCheckout.CheckoutMetadata> map, String path, CoreConfig.EolStreamType streamType, String smudgeCommand) {
        if (this.inCore || map == null) {
            return;
        }
        map.put(path, new DirCacheCheckout.CheckoutMetadata(streamType, smudgeCommand));
    }

    public CoreConfig.EolStreamType detectCheckoutStreamType(Attributes attributes) {
        if (this.inCore) {
            return null;
        }
        return EolStreamTypeUtil.detectStreamType(TreeWalk.OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
    }

    private void handleDeletedFiles() {
        for (String path : this.toBeDeleted.descendingKeySet()) {
            File file;
            File file2 = file = this.inCore ? null : this.toBeDeleted.get(path);
            if (file == null || file.delete() || file.isDirectory()) continue;
            this.result.failedToDelete.add(path);
        }
    }

    public void markAsModified(String path) {
        this.result.modifiedFiles.add(path);
    }

    public List<String> getModifiedFiles() {
        return this.result.modifiedFiles;
    }

    private void checkout() throws NoWorkTreeException, IOException {
        for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
            DirCacheEntry dirCacheEntry = entry.getValue();
            if (dirCacheEntry.getFileMode() == FileMode.GITLINK) {
                new File(this.nonNullNonBareRepo().getWorkTree(), entry.getKey()).mkdirs();
                continue;
            }
            DirCacheCheckout.checkoutEntry(this.repo, dirCacheEntry, this.reader, false, this.checkoutMetadata.get(entry.getKey()), this.workingTreeOptions);
            this.result.modifiedFiles.add(entry.getKey());
        }
    }

    public void revertModifiedFiles() throws IOException {
        if (this.inCore) {
            this.result.modifiedFiles.clear();
            return;
        }
        if (this.indexChangesWritten) {
            return;
        }
        for (String path : this.result.modifiedFiles) {
            DirCacheEntry entry = this.dirCache.getEntry(path);
            if (entry == null) continue;
            DirCacheCheckout.checkoutEntry(this.repo, entry, this.reader, false, this.cleanupMetadata.get(path), this.workingTreeOptions);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.implicitDirCache) {
            this.dirCache.unlock();
        }
    }

    public void updateFileWithContent(StreamLoader resultStreamLoader, CoreConfig.EolStreamType streamType, String smudgeCommand, String path, File file, boolean safeWrite) throws IOException {
        if (this.inCore) {
            return;
        }
        DirCacheCheckout.CheckoutMetadata metadata = new DirCacheCheckout.CheckoutMetadata(streamType, smudgeCommand);
        if (safeWrite) {
            TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
            try {
                Throwable throwable = null;
                Object var10_16 = null;
                try (TemporaryBuffer.LocalFile buf = buffer;){
                    DirCacheCheckout.getContent(this.repo, path, metadata, resultStreamLoader, this.workingTreeOptions, buf);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var10_16 = null;
                try (InputStream bufIn = ((TemporaryBuffer)buffer).openInputStream();){
                    Files.copy(bufIn, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                ((TemporaryBuffer)buffer).destroy();
            }
            return;
        }
        Throwable throwable = null;
        Object var9_14 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            DirCacheCheckout.getContent(this.repo, path, metadata, resultStreamLoader, this.workingTreeOptions, outputStream);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public DirCacheEntry insertToIndex(InputStream inputStream, byte[] path, FileMode fileMode, int entryStage, Instant lastModified, int len, Attribute lfsAttribute) throws IOException {
        StreamLoader contentLoader = WorkTreeUpdater.createStreamLoader(() -> inputStream, len);
        return this.insertToIndex(contentLoader, path, fileMode, entryStage, lastModified, len, lfsAttribute);
    }

    public DirCacheEntry insertToIndex(StreamLoader resultStreamLoader, byte[] path, FileMode fileMode, int entryStage, Instant lastModified, int len, Attribute lfsAttribute) throws IOException {
        return this.addExistingToIndex(this.insertResult(resultStreamLoader, lfsAttribute), path, fileMode, entryStage, lastModified, len);
    }

    public DirCacheEntry addExistingToIndex(ObjectId objectId, byte[] path, FileMode fileMode, int entryStage, Instant lastModified, int len) {
        DirCacheEntry dce = new DirCacheEntry(path, entryStage);
        dce.setFileMode(fileMode);
        if (lastModified != null) {
            dce.setLastModified(lastModified);
        }
        dce.setLength(this.inCore ? 0 : len);
        dce.setObjectId(objectId);
        this.builder.add(dce);
        return dce;
    }

    private ObjectId insertResult(StreamLoader resultStreamLoader, Attribute lfsAttribute) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (LfsFactory.LfsInputStream is = LfsFactory.getInstance().applyCleanFilter(this.repo, resultStreamLoader.data.load(), resultStreamLoader.size, lfsAttribute);){
            return this.inserter.insert(3, is.getLength(), is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Repository nonNullRepo() throws NullPointerException {
        if (this.repo == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        return this.repo;
    }

    private Repository nonNullNonBareRepo() throws NullPointerException, NoWorkTreeException {
        if (this.nonNullRepo().isBare()) {
            throw new NoWorkTreeException();
        }
        return this.repo;
    }

    public static class Result {
        public List<String> modifiedFiles = new LinkedList<String>();
        public List<String> failedToDelete = new LinkedList<String>();
        public ObjectId treeId = null;
    }

    public static class StreamLoader
    extends ObjectLoader {
        private final StreamSupplier data;
        private final long size;

        private StreamLoader(StreamSupplier data, long length) {
            this.data = data;
            this.size = length;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public boolean isLarge() {
            return true;
        }

        @Override
        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException();
        }

        @Override
        public ObjectStream openStream() throws IOException {
            return new ObjectStream.Filter(this.getType(), this.getSize(), new BufferedInputStream(this.data.load()));
        }
    }

    public static interface StreamSupplier {
        public InputStream load() throws IOException;
    }
}

