/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphLoader;
import org.eclipse.jgit.internal.storage.dfs.BeforeDfsPackIndexLoadedEvent;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.LargePackedWholeObject;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndex;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndexLoader;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndexFactory;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.LongList;

public final class DfsPackFile
extends BlockBasedFile {
    private static final int REC_SIZE = 28;
    private static final long REF_POSITION = 0L;
    public static final PackBitmapIndexLoader DEFAULT_BITMAP_LOADER = new StreamPackBitmapIndexLoader();
    private volatile PackIndex index;
    private volatile PackReverseIndex reverseIndex;
    private volatile PackBitmapIndex bitmapIndex;
    private volatile CommitGraph commitGraph;
    private final PackBitmapIndexLoader bitmapLoader;
    private boolean objectSizeIndexLoadAttempted;
    private volatile PackObjectSizeIndex objectSizeIndex;
    private volatile LongList corruptObjects;
    private final Object corruptObjectsLock = new Object();
    private final IndexFactory indexFactory;

    DfsPackFile(DfsBlockCache cache, DfsPackDescription desc) {
        this(cache, desc, DEFAULT_BITMAP_LOADER, new CachedStreamIndexFactory(cache, desc));
    }

    public DfsPackFile(DfsBlockCache cache, DfsPackDescription desc, PackBitmapIndexLoader bitmapLoader, IndexFactory indexFactory) {
        super(cache, desc, PackExt.PACK);
        long sz;
        int bs = desc.getBlockSize(PackExt.PACK);
        if (bs > 0) {
            this.setBlockSize(bs);
        }
        this.length = (sz = desc.getFileSize(PackExt.PACK)) > 0L ? sz : -1L;
        this.bitmapLoader = bitmapLoader;
        this.indexFactory = indexFactory;
    }

    public DfsPackDescription getPackDescription() {
        return this.desc;
    }

    public boolean isIndexLoaded() {
        return this.index != null;
    }

    void setPackIndex(PackIndex idx) {
        long objCnt = idx.getObjectCount();
        int recSize = 28;
        long sz = objCnt * (long)recSize;
        this.cache.putRef(this.desc.getStreamKey(PackExt.INDEX), sz, idx);
        this.index = idx;
    }

    public PackIndex getPackIndex(DfsReader ctx) throws IOException {
        return this.idx(ctx);
    }

    private PackIndex idx(DfsReader ctx) throws IOException {
        if (this.index != null) {
            return this.index;
        }
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName(), (Throwable)this.invalidatingCause);
        }
        Repository.getGlobalListenerList().dispatch(new BeforeDfsPackIndexLoadedEvent(this));
        try {
            this.index = this.indexFactory.getPackIndexes().index(ctx);
            if (this.index == null) {
                throw new IOException("Couldn't get a reference to the primary index");
            }
            ctx.emitIndexLoad(this.desc, PackExt.INDEX, this.index);
            return this.index;
        }
        catch (IOException e) {
            this.invalid = true;
            this.invalidatingCause = e;
            throw e;
        }
    }

    final boolean isGarbage() {
        return this.desc.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE;
    }

    public PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        if (this.invalid || this.isGarbage() || !this.bitmapLoader.hasBitmaps(this.desc)) {
            return null;
        }
        if (this.bitmapIndex != null) {
            return this.bitmapIndex;
        }
        if (!this.bitmapLoader.keepInDfs(this.desc)) {
            PackBitmapIndexLoader.LoadResult result = this.bitmapLoader.loadPackBitmapIndex(ctx, this);
            if (this.bitmapIndex == null && result.bitmapIndex != null) {
                this.bitmapIndex = result.bitmapIndex;
            }
            return this.bitmapIndex;
        }
        DfsStreamKey bitmapKey = this.desc.getStreamKey(PackExt.BITMAP_INDEX);
        AtomicBoolean cacheHit = new AtomicBoolean(true);
        DfsBlockCache.Ref idxref = this.cache.getOrLoadRef(bitmapKey, 0L, () -> {
            cacheHit.set(false);
            return this.loadBitmapIndex(ctx, bitmapKey);
        });
        if (cacheHit.get()) {
            ++ctx.stats.bitmapCacheHit;
        }
        PackBitmapIndex bmidx = (PackBitmapIndex)idxref.get();
        if (this.bitmapIndex == null && bmidx != null) {
            this.bitmapIndex = bmidx;
        }
        ctx.emitIndexLoad(this.desc, PackExt.BITMAP_INDEX, this.bitmapIndex);
        return this.bitmapIndex;
    }

    public CommitGraph getCommitGraph(DfsReader ctx) throws IOException {
        if (this.invalid || this.isGarbage() || !this.desc.hasFileExt(PackExt.COMMIT_GRAPH)) {
            return null;
        }
        if (this.commitGraph != null) {
            return this.commitGraph;
        }
        DfsStreamKey commitGraphKey = this.desc.getStreamKey(PackExt.COMMIT_GRAPH);
        AtomicBoolean cacheHit = new AtomicBoolean(true);
        DfsBlockCache.Ref cgref = this.cache.getOrLoadRef(commitGraphKey, 0L, () -> {
            cacheHit.set(false);
            return this.loadCommitGraph(ctx, commitGraphKey);
        });
        if (cacheHit.get()) {
            ++ctx.stats.commitGraphCacheHit;
        }
        CommitGraph cg = (CommitGraph)cgref.get();
        if (this.commitGraph == null && cg != null) {
            this.commitGraph = cg;
        }
        ctx.emitIndexLoad(this.desc, PackExt.COMMIT_GRAPH, this.commitGraph);
        return this.commitGraph;
    }

    public PackReverseIndex getReverseIdx(DfsReader ctx) throws IOException {
        if (this.reverseIndex != null) {
            return this.reverseIndex;
        }
        this.reverseIndex = this.indexFactory.getPackIndexes().reverseIndex(ctx);
        if (this.reverseIndex == null) {
            throw new IOException("Couldn't get a reference to the reverse index");
        }
        ctx.emitIndexLoad(this.desc, PackExt.REVERSE_INDEX, this.reverseIndex);
        return this.reverseIndex;
    }

    private PackObjectSizeIndex getObjectSizeIndex(DfsReader ctx) throws IOException {
        if (this.objectSizeIndex != null) {
            return this.objectSizeIndex;
        }
        if (this.objectSizeIndexLoadAttempted || !ctx.getOptions().shouldUseObjectSizeIndex() || !this.desc.hasFileExt(PackExt.OBJECT_SIZE_INDEX)) {
            return null;
        }
        DfsStreamKey objSizeKey = this.desc.getStreamKey(PackExt.OBJECT_SIZE_INDEX);
        AtomicBoolean cacheHit = new AtomicBoolean(true);
        try {
            DfsBlockCache.Ref sizeIdxRef = this.cache.getOrLoadRef(objSizeKey, 0L, () -> {
                cacheHit.set(false);
                return this.loadObjectSizeIndex(ctx, objSizeKey);
            });
            if (cacheHit.get()) {
                ++ctx.stats.objectSizeIndexCacheHit;
            }
            PackObjectSizeIndex sizeIdx = (PackObjectSizeIndex)sizeIdxRef.get();
            if (this.objectSizeIndex == null && sizeIdx != null) {
                this.objectSizeIndex = sizeIdx;
            }
        }
        finally {
            this.objectSizeIndexLoadAttempted = true;
        }
        if (this.objectSizeIndex != null) {
            ctx.emitIndexLoad(this.desc, PackExt.OBJECT_SIZE_INDEX, this.objectSizeIndex);
        }
        return this.objectSizeIndex;
    }

    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset && !this.isCorrupt(offset);
    }

    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset && !this.isCorrupt(offset) ? this.load(ctx, offset) : null;
    }

    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        return this.idx(ctx).findOffset(id);
    }

    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.idx(ctx).resolve(matches, id, matchLimit);
    }

    long getObjectCount(DfsReader ctx) throws IOException {
        return this.idx(ctx).getObjectCount();
    }

    private byte[] decompress(long position, int sz, DfsReader ctx) throws IOException, DataFormatException {
        byte[] dstbuf;
        try {
            dstbuf = new byte[sz];
        }
        catch (OutOfMemoryError noMemory) {
            return null;
        }
        if (ctx.inflate(this, position, dstbuf, false) != sz) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, position));
        }
        return dstbuf;
    }

    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        if (this.length == -1L) {
            ctx.pin(this, 0L);
            ctx.unpin();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.PACK);){
            int sz = ctx.getOptions().getStreamPackBufferSize();
            if (sz > 0) {
                rc.setReadAheadBytes(sz);
            }
            if (this.cache.shouldCopyThroughCache(this.length)) {
                this.copyPackThroughCache(out, ctx, rc);
            } else {
                this.copyPackBypassCache(out, rc);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copyPackThroughCache(PackOutputStream out, DfsReader ctx, ReadableChannel rc) throws IOException {
        long position = 12L;
        long remaining = this.length - 32L;
        while (0L < remaining) {
            DfsBlock b = this.cache.getOrLoad(this, position, ctx, () -> rc);
            int ptr = (int)(position - b.start);
            if (b.size() <= ptr) {
                throw this.packfileIsTruncated();
            }
            int n = (int)Math.min((long)(b.size() - ptr), remaining);
            b.write(out, position, n);
            position += (long)n;
            remaining -= (long)n;
        }
    }

    private long copyPackBypassCache(PackOutputStream out, ReadableChannel rc) throws IOException {
        ByteBuffer buf = this.newCopyBuffer(out, rc);
        long position = 12L;
        long remaining = this.length - 32L;
        boolean packHeadSkipped = false;
        while (0L < remaining) {
            int ptr;
            DfsBlock b = (DfsBlock)this.cache.get(this.key, this.alignToBlock(position));
            if (b != null) {
                ptr = (int)(position - b.start);
                if (b.size() <= ptr) {
                    throw this.packfileIsTruncated();
                }
                int n = (int)Math.min((long)(b.size() - ptr), remaining);
                b.write(out, position, n);
                remaining -= (long)n;
                rc.position(position += (long)n);
                packHeadSkipped = true;
                continue;
            }
            ptr = packHeadSkipped ? 0 : 12;
            buf.position(0);
            int bufLen = DfsPackFile.read(rc, buf);
            if (bufLen <= ptr) {
                throw this.packfileIsTruncated();
            }
            int n = (int)Math.min((long)(bufLen - ptr), remaining);
            out.write(buf.array(), ptr, n);
            position += (long)n;
            remaining -= (long)n;
            packHeadSkipped = true;
        }
        return position;
    }

    private ByteBuffer newCopyBuffer(PackOutputStream out, ReadableChannel rc) {
        byte[] copyBuf;
        int bs = this.blockSize(rc);
        if (bs > (copyBuf = out.getCopyBuffer()).length) {
            copyBuf = new byte[bs];
        }
        return ByteBuffer.wrap(copyBuf, 0, bs);
    }

    void copyAsIs(PackOutputStream out, DfsObjectToPack src, boolean validate, DfsReader ctx) throws IOException, StoredObjectRepresentationNotAvailableException {
        int n;
        long cnt;
        long expectedCRC;
        DfsBlock quickCopy;
        CRC32 crc1 = validate ? new CRC32() : null;
        CRC32 crc2 = validate ? new CRC32() : null;
        byte[] buf = out.getCopyBuffer();
        try {
            this.readFully(src.offset, buf, 0, 20, ctx);
        }
        catch (IOException ioError) {
            throw new StoredObjectRepresentationNotAvailableException(ioError);
        }
        int c = buf[0] & 0xFF;
        int typeCode = c >> 4 & 7;
        long inflatedLength = c & 0xF;
        int shift = 4;
        int headerCnt = 1;
        while ((c & 0x80) != 0) {
            c = buf[headerCnt++] & 0xFF;
            inflatedLength += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        if (typeCode == 6) {
            while (((c = buf[headerCnt++] & 0xFF) & 0x80) != 0) {
            }
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
        } else if (typeCode == 7) {
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
            this.readFully(src.offset + (long)headerCnt, buf, 0, 20, ctx);
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, 20);
                crc2.update(buf, 0, 20);
            }
            headerCnt += 20;
        } else if (validate) {
            assert (crc1 != null && crc2 != null);
            crc1.update(buf, 0, headerCnt);
            crc2.update(buf, 0, headerCnt);
        }
        long dataOffset = src.offset + (long)headerCnt;
        long dataLength = src.length;
        try {
            quickCopy = ctx.quickCopy(this, dataOffset, dataLength);
            if (validate && this.idx(ctx).hasCRC32Support()) {
                assert (crc1 != null);
                expectedCRC = this.idx(ctx).findCRC32(src);
                if (quickCopy != null) {
                    quickCopy.crc32(crc1, dataOffset, (int)dataLength);
                } else {
                    long pos = dataOffset;
                    cnt = dataLength;
                    while (cnt > 0L) {
                        n = (int)Math.min(cnt, (long)buf.length);
                        this.readFully(pos, buf, 0, n, ctx);
                        crc1.update(buf, 0, n);
                        pos += (long)n;
                        cnt -= (long)n;
                    }
                }
                if (crc1.getValue() != expectedCRC) {
                    this.setCorrupt(src.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()));
                }
            } else if (validate) {
                assert (crc1 != null);
                Inflater inf = ctx.inflater();
                byte[] tmp = new byte[1024];
                if (quickCopy != null) {
                    quickCopy.check(inf, tmp, dataOffset, (int)dataLength);
                } else {
                    long pos = dataOffset;
                    long cnt2 = dataLength;
                    while (cnt2 > 0L) {
                        int n2 = (int)Math.min(cnt2, (long)buf.length);
                        this.readFully(pos, buf, 0, n2, ctx);
                        crc1.update(buf, 0, n2);
                        inf.setInput(buf, 0, n2);
                        while (inf.inflate(tmp, 0, tmp.length) > 0) {
                        }
                        pos += (long)n2;
                        cnt2 -= (long)n2;
                    }
                }
                if (!inf.finished() || inf.getBytesRead() != dataLength) {
                    this.setCorrupt(src.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, src.offset));
                }
                expectedCRC = crc1.getValue();
            } else {
                expectedCRC = -1L;
            }
        }
        catch (DataFormatException dataFormat) {
            this.setCorrupt(src.offset);
            CorruptObjectException corruptObject = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()), dataFormat);
            throw new StoredObjectRepresentationNotAvailableException(corruptObject);
        }
        catch (IOException ioError) {
            throw new StoredObjectRepresentationNotAvailableException(ioError);
        }
        if (quickCopy != null) {
            out.writeHeader(src, inflatedLength);
            quickCopy.write(out, dataOffset, (int)dataLength);
        } else if (dataLength <= (long)buf.length) {
            if (!validate) {
                long pos = dataOffset;
                cnt = dataLength;
                while (cnt > 0L) {
                    n = (int)Math.min(cnt, (long)buf.length);
                    this.readFully(pos, buf, 0, n, ctx);
                    pos += (long)n;
                    cnt -= (long)n;
                }
            }
            out.writeHeader(src, inflatedLength);
            out.write(buf, 0, (int)dataLength);
        } else {
            out.writeHeader(src, inflatedLength);
            long pos = dataOffset;
            cnt = dataLength;
            while (cnt > 0L) {
                n = (int)Math.min(cnt, (long)buf.length);
                this.readFully(pos, buf, 0, n, ctx);
                if (validate) {
                    assert (crc2 != null);
                    crc2.update(buf, 0, n);
                }
                out.write(buf, 0, n);
                pos += (long)n;
                cnt -= (long)n;
            }
            if (validate) {
                assert (crc2 != null);
                if (crc2.getValue() != expectedCRC) {
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()));
                }
            }
        }
    }

    private IOException packfileIsTruncated() {
        this.invalid = true;
        IOException exc = new IOException(MessageFormat.format(JGitText.get().packfileIsTruncated, this.getFileName()));
        this.invalidatingCause = exc;
        return exc;
    }

    private void readFully(long position, byte[] dstbuf, int dstoff, int cnt, DfsReader ctx) throws IOException {
        while (cnt > 0) {
            int copied = ctx.copy(this, position, dstbuf, dstoff, cnt);
            if (copied == 0) {
                throw new EOFException();
            }
            position += (long)copied;
            dstoff += copied;
            cnt -= copied;
        }
    }

    ObjectLoader load(DfsReader ctx, long pos) throws IOException {
        try {
            byte[] ib = ctx.tempId;
            Delta delta = null;
            byte[] data = null;
            int type = -1;
            boolean cached = false;
            block9: while (true) {
                this.readFully(pos, ib, 0, 20, ctx);
                int c = ib[0] & 0xFF;
                int typeCode = c >> 4 & 7;
                long sz = c & 0xF;
                int shift = 4;
                int p = 1;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                    sz += (long)(c & 0x7F) << shift;
                    shift += 7;
                }
                switch (typeCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (delta != null) {
                            data = this.decompress(pos + (long)p, (int)sz, ctx);
                            type = typeCode;
                            break block9;
                        }
                        if (sz < (long)ctx.getStreamFileThreshold() && (data = this.decompress(pos + (long)p, (int)sz, ctx)) != null) {
                            return new ObjectLoader.SmallObject(typeCode, data);
                        }
                        return new LargePackedWholeObject(typeCode, sz, pos, p, this, ctx.db);
                    }
                    case 6: {
                        c = ib[p++] & 0xFF;
                        long base = c & 0x7F;
                        while ((c & 0x80) != 0) {
                            ++base;
                            c = ib[p++] & 0xFF;
                            base <<= 7;
                            base += (long)(c & 0x7F);
                        }
                        base = pos - base;
                        delta = new Delta(delta, pos, (int)sz, p, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(pos + (long)p, ib, 0, 20, ctx);
                        long base = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                        delta = new Delta(delta, pos, (int)sz, p + 20, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
                    }
                }
                break;
            }
            if (data == null) {
                throw new LargeObjectException();
            }
            assert (delta != null);
            do {
                byte[] result;
                if (cached) {
                    cached = false;
                } else if (delta.next == null) {
                    ctx.getDeltaBaseCache().put(this.key, delta.basePos, type, data);
                }
                pos = delta.deltaPos;
                byte[] cmds = this.decompress(pos + (long)delta.hdrLen, delta.deltaSize, ctx);
                if (cmds == null) {
                    data = null;
                    throw new LargeObjectException();
                }
                long sz = BinaryDelta.getResultSize(cmds);
                if (Integer.MAX_VALUE <= sz) {
                    throw new LargeObjectException.ExceedsByteArrayLimit();
                }
                try {
                    result = new byte[(int)sz];
                }
                catch (OutOfMemoryError tooBig) {
                    data = null;
                    cmds = null;
                    throw new LargeObjectException.OutOfMemory(tooBig);
                }
                BinaryDelta.apply(data, cmds, result);
                data = result;
            } while ((delta = delta.next) != null);
            return new ObjectLoader.SmallObject(type, data);
        }
        catch (DataFormatException dfe) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getFileName()), dfe);
        }
    }

    private long findDeltaBase(DfsReader ctx, ObjectId baseId) throws IOException, MissingObjectException {
        long ofs = this.idx(ctx).findOffset(baseId);
        if (ofs < 0L) {
            throw new MissingObjectException(baseId, JGitText.get().missingDeltaBase);
        }
        return ofs;
    }

    byte[] getDeltaHeader(DfsReader wc, long pos) throws IOException, DataFormatException {
        byte[] hdr = new byte[32];
        wc.inflate(this, pos, hdr, true);
        return hdr;
    }

    int getObjectType(DfsReader ctx, long pos) throws IOException {
        int type;
        byte[] ib = ctx.tempId;
        block5: while (true) {
            this.readFully(pos, ib, 0, 20, ctx);
            int c = ib[0] & 0xFF;
            type = c >> 4 & 7;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return type;
                }
                case 6: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    c = ib[p++] & 0xFF;
                    long ofs = c & 0x7F;
                    while ((c & 0x80) != 0) {
                        ++ofs;
                        c = ib[p++] & 0xFF;
                        ofs <<= 7;
                        ofs += (long)(c & 0x7F);
                    }
                    pos -= ofs;
                    continue block5;
                }
                case 7: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    this.readFully(pos + (long)p, ib, 0, 20, ctx);
                    pos = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
    }

    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset ? this.getObjectSize(ctx, offset) : -1L;
    }

    long getObjectSize(DfsReader ctx, long pos) throws IOException {
        long deltaAt;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        int p = 1;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return sz;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                }
                deltaAt = pos + (long)p;
                break;
            }
            case 7: {
                deltaAt = pos + (long)p + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(ctx, deltaAt));
        }
        catch (DataFormatException dfe) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getFileName()), dfe);
        }
    }

    boolean hasObjectSizeIndex(DfsReader ctx) throws IOException {
        return this.getObjectSizeIndex(ctx) != null;
    }

    int getObjectSizeIndexThreshold(DfsReader ctx) throws IOException {
        PackObjectSizeIndex idx = this.getObjectSizeIndex(ctx);
        if (idx == null) {
            throw new IOException("Asking threshold of non-existing obj-size");
        }
        return idx.getThreshold();
    }

    long getIndexedObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        int idxPosition = this.idx(ctx).findPosition(id);
        if (idxPosition < 0) {
            throw new IllegalArgumentException("Cannot get size from index since object is not in pack");
        }
        PackObjectSizeIndex sizeIdx = this.getObjectSizeIndex(ctx);
        if (sizeIdx == null) {
            throw new IllegalStateException("Asking indexed size from a pack without object size index");
        }
        return sizeIdx.getSize(idxPosition);
    }

    void representation(DfsObjectRepresentation r, long pos, DfsReader ctx, PackReverseIndex rev) throws IOException {
        r.offset = pos;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int p = 1;
        int typeCode = c >> 4 & 7;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
        }
        long len = rev.findNextOffset(pos, this.length - 20L) - pos;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                r.format = 1;
                r.baseId = null;
                r.length = len - (long)p;
                return;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                r.format = 0;
                r.baseId = rev.findObject(pos - ofs);
                r.length = len - (long)p;
                return;
            }
            case 7: {
                this.readFully(pos + (long)p, ib, 0, 20, ctx);
                r.format = 0;
                r.baseId = ObjectId.fromRaw(ib);
                r.length = len - (long)p - 20L;
                return;
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCorrupt(long offset) {
        LongList list = this.corruptObjects;
        if (list == null) {
            return false;
        }
        LongList longList = list;
        synchronized (longList) {
            return list.contains(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long offset) {
        Object object;
        LongList list = this.corruptObjects;
        if (list == null) {
            object = this.corruptObjectsLock;
            synchronized (object) {
                list = this.corruptObjects;
                if (list == null) {
                    this.corruptObjects = list = new LongList();
                }
            }
        }
        object = list;
        synchronized (object) {
            list.add(offset);
        }
    }

    private DfsBlockCache.Ref<PackObjectSizeIndex> loadObjectSizeIndex(DfsReader ctx, DfsStreamKey objectSizeIndexKey) throws IOException {
        ++ctx.stats.readObjectSizeIndex;
        long start = System.nanoTime();
        long size = 0L;
        IOException parsingError = null;
        try {
            Throwable throwable = null;
            Object var9_9 = null;
            try (ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.OBJECT_SIZE_INDEX);){
                try {
                    this.objectSizeIndex = PackObjectSizeIndexLoader.load(Channels.newInputStream(rc));
                    size = rc.position();
                }
                catch (IOException e) {
                    parsingError = e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new DfsBlockCache.Ref<Object>(objectSizeIndexKey, 0L, 0L, null);
        }
        if (parsingError != null) {
            throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.desc.getFileName(PackExt.OBJECT_SIZE_INDEX)), parsingError);
        }
        ctx.stats.readObjectSizeIndexBytes += size;
        ctx.stats.readObjectSizeIndexMicros += DfsPackFile.elapsedMicros(start);
        return new DfsBlockCache.Ref<PackObjectSizeIndex>(objectSizeIndexKey, 0L, size, this.objectSizeIndex);
    }

    private DfsBlockCache.Ref<PackBitmapIndex> loadBitmapIndex(DfsReader ctx, DfsStreamKey bitmapKey) throws IOException {
        ++ctx.stats.readBitmap;
        PackBitmapIndexLoader.LoadResult result = this.bitmapLoader.loadPackBitmapIndex(ctx, this);
        this.bitmapIndex = result.bitmapIndex;
        return new DfsBlockCache.Ref<PackBitmapIndex>(bitmapKey, 0L, result.bytesRead, result.bitmapIndex);
    }

    private DfsBlockCache.Ref<CommitGraph> loadCommitGraph(DfsReader ctx, DfsStreamKey cgkey) throws IOException {
        ++ctx.stats.readCommitGraph;
        long start = System.nanoTime();
        StoredConfig repoConfig = ctx.db.getRepository().getConfig();
        boolean readChangedPathFilters = repoConfig.getBoolean("commitGraph", "readChangedPaths", false);
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.COMMIT_GRAPH);){
                long size;
                CommitGraph cg;
                try {
                    cg = CommitGraphLoader.read(DfsPackFile.alignTo8kBlocks(rc), readChangedPathFilters);
                }
                finally {
                    size = rc.position();
                    ctx.stats.readCommitGraphBytes += size;
                    ctx.stats.readCommitGraphMicros += DfsPackFile.elapsedMicros(start);
                }
                this.commitGraph = cg;
                return new DfsBlockCache.Ref<CommitGraph>(cgkey, 0L, size, cg);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format(DfsText.get().cannotReadCommitGraph, this.desc.getFileName(PackExt.COMMIT_GRAPH)), e);
        }
    }

    private static InputStream alignTo8kBlocks(ReadableChannel rc) {
        InputStream in = Channels.newInputStream(rc);
        int wantSize = 8192;
        int bs = rc.blockSize();
        if (bs > 0 && bs < wantSize) {
            bs = wantSize / bs * bs;
        } else if (bs <= 0) {
            bs = wantSize;
        }
        return new BufferedInputStream(in, bs);
    }

    public static final class CachedStreamIndexFactory
    implements IndexFactory {
        private final CachedStreamPackIndexes indexes;

        public CachedStreamIndexFactory(DfsBlockCache cache, DfsPackDescription desc) {
            this.indexes = new CachedStreamPackIndexes(cache, desc);
        }

        @Override
        public IndexFactory.PackIndexes getPackIndexes() {
            return this.indexes;
        }
    }

    public static final class CachedStreamPackIndexes
    implements IndexFactory.PackIndexes {
        private final DfsBlockCache cache;
        private final DfsPackDescription desc;

        public CachedStreamPackIndexes(DfsBlockCache cache, DfsPackDescription desc) {
            this.cache = cache;
            this.desc = desc;
        }

        @Override
        public PackIndex index(DfsReader ctx) throws IOException {
            DfsStreamKey idxKey = this.desc.getStreamKey(PackExt.INDEX);
            AtomicReference<Object> loadedRef = new AtomicReference<Object>(null);
            DfsBlockCache.Ref cachedRef = this.cache.getOrLoadRef(idxKey, 0L, () -> {
                RefWithSize<PackIndex> idx = CachedStreamPackIndexes.loadPackIndex(ctx, this.desc);
                loadedRef.set(((PackIndex)idx.ref));
                return new DfsBlockCache.Ref<PackIndex>(idxKey, 0L, idx.size, (PackIndex)idx.ref);
            });
            if (loadedRef.get() == null) {
                ++ctx.stats.idxCacheHit;
            }
            return cachedRef.get() != null ? (PackIndex)cachedRef.get() : (PackIndex)loadedRef.get();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static RefWithSize<PackIndex> loadPackIndex(DfsReader ctx, DfsPackDescription desc) throws IOException {
            try {
                ++ctx.stats.readIdx;
                long start = System.nanoTime();
                try {
                    RefWithSize<PackIndex> refWithSize;
                    block16: {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        ReadableChannel rc = ctx.db.openFile(desc, PackExt.INDEX);
                        try {
                            PackIndex idx = PackIndex.read(DfsPackFile.alignTo8kBlocks(rc));
                            ctx.stats.readIdxBytes += rc.position();
                            refWithSize = new RefWithSize<PackIndex>(idx, idx.getObjectCount() * 28L);
                            if (rc == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (rc != null) {
                                    rc.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        rc.close();
                    }
                    return refWithSize;
                }
                finally {
                    ctx.stats.readIdxMicros += DfsPackFile.elapsedMicros(start);
                }
            }
            catch (EOFException e) {
                throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, desc.getFileName(PackExt.INDEX)), e);
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, desc.getFileName(PackExt.INDEX)), e);
            }
        }

        @Override
        public PackReverseIndex reverseIndex(DfsReader ctx) throws IOException {
            PackIndex idx = this.index(ctx);
            DfsStreamKey revKey = this.desc.getStreamKey(PackExt.REVERSE_INDEX);
            AtomicReference<Object> loadedRef = new AtomicReference<Object>(null);
            DfsBlockCache.Ref cachedRef = this.cache.getOrLoadRef(revKey, 0L, () -> {
                RefWithSize<PackReverseIndex> ridx = CachedStreamPackIndexes.loadReverseIdx(ctx, idx);
                loadedRef.set(((PackReverseIndex)ridx.ref));
                return new DfsBlockCache.Ref<PackReverseIndex>(revKey, 0L, ridx.size, (PackReverseIndex)ridx.ref);
            });
            if (loadedRef.get() == null) {
                ++ctx.stats.ridxCacheHit;
            }
            return cachedRef.get() != null ? (PackReverseIndex)cachedRef.get() : (PackReverseIndex)loadedRef.get();
        }

        private static RefWithSize<PackReverseIndex> loadReverseIdx(DfsReader ctx, PackIndex idx) {
            ++ctx.stats.readReverseIdx;
            long start = System.nanoTime();
            PackReverseIndex revidx = PackReverseIndexFactory.computeFromIndex(idx);
            ctx.stats.readReverseIdxMicros += DfsPackFile.elapsedMicros(start);
            return new RefWithSize<PackReverseIndex>(revidx, idx.getObjectCount() * 8L);
        }
    }

    private static class Delta {
        final Delta next;
        final long deltaPos;
        final int deltaSize;
        final int hdrLen;
        final long basePos;

        Delta(Delta next, long ofs, int sz, int hdrLen, long baseOffset) {
            this.next = next;
            this.deltaPos = ofs;
            this.deltaSize = sz;
            this.hdrLen = hdrLen;
            this.basePos = baseOffset;
        }
    }

    public static interface IndexFactory {
        public PackIndexes getPackIndexes();

        public static interface PackIndexes {
            public PackIndex index(DfsReader var1) throws IOException;

            public PackReverseIndex reverseIndex(DfsReader var1) throws IOException;
        }
    }

    public static interface PackBitmapIndexLoader {
        public boolean hasBitmaps(DfsPackDescription var1);

        public boolean keepInDfs(DfsPackDescription var1);

        public LoadResult loadPackBitmapIndex(DfsReader var1, DfsPackFile var2) throws IOException;

        public static class LoadResult {
            public final PackBitmapIndex bitmapIndex;
            public final long bytesRead;

            public LoadResult(PackBitmapIndex packBitmapIndex, long bytesRead) {
                this.bitmapIndex = packBitmapIndex;
                this.bytesRead = bytesRead;
            }
        }
    }

    private static final class RefWithSize<V> {
        final V ref;
        final long size;

        RefWithSize(V ref, long size) {
            this.ref = ref;
            this.size = size;
        }
    }

    private static final class StreamPackBitmapIndexLoader
    implements PackBitmapIndexLoader {
        private StreamPackBitmapIndexLoader() {
        }

        @Override
        public boolean hasBitmaps(DfsPackDescription desc) {
            return desc.hasFileExt(PackExt.BITMAP_INDEX);
        }

        @Override
        public boolean keepInDfs(DfsPackDescription desc) {
            return true;
        }

        @Override
        public PackBitmapIndexLoader.LoadResult loadPackBitmapIndex(DfsReader ctx, DfsPackFile pack) throws IOException {
            DfsPackDescription desc = pack.getPackDescription();
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (ReadableChannel rc = ctx.db.openFile(desc, PackExt.BITMAP_INDEX);){
                    long size;
                    PackBitmapIndex bmidx;
                    try {
                        bmidx = PackBitmapIndex.read(DfsPackFile.alignTo8kBlocks(rc), () -> pack.idx(ctx), () -> pack.getReverseIdx(ctx), ctx.getOptions().shouldLoadRevIndexInParallel());
                    }
                    finally {
                        size = rc.position();
                    }
                    return new PackBitmapIndexLoader.LoadResult(bmidx, size);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EOFException e) {
                throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, desc.getFileName(PackExt.BITMAP_INDEX)), e);
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, desc.getFileName(PackExt.BITMAP_INDEX)), e);
            }
        }
    }
}

