/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.UnsupportedPackIndexVersionException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndexV2;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public interface PackIndex
extends Iterable<MutableEntry>,
ObjectIdSet {
    public static PackIndex open(File idxFile) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SilentFileInputStream fd = new SilentFileInputStream(idxFile);){
                return PackIndex.read(fd);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, idxFile.getAbsolutePath()), ioe);
        }
    }

    public static PackIndex read(InputStream fd) throws IOException, CorruptObjectException {
        byte[] hdr = new byte[8];
        IO.readFully(fd, hdr, 0, hdr.length);
        if (PackIndex.isTOC(hdr)) {
            int v = NB.decodeInt32(hdr, 4);
            switch (v) {
                case 2: {
                    return new PackIndexV2(fd);
                }
            }
            throw new UnsupportedPackIndexVersionException(v);
        }
        return new PackIndexV1(fd, hdr);
    }

    private static boolean isTOC(byte[] h) {
        byte[] toc = PackIndexWriter.TOC;
        int i = 0;
        while (i < toc.length) {
            if (h[i] != toc[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    default public boolean hasObject(AnyObjectId id) {
        return this.findOffset(id) != -1L;
    }

    @Override
    default public boolean contains(AnyObjectId id) {
        return this.findOffset(id) != -1L;
    }

    @Override
    public Iterator<MutableEntry> iterator();

    public long getObjectCount();

    public long getOffset64Count();

    public ObjectId getObjectId(long var1);

    default public ObjectId getObjectId(int nthPosition) {
        if (nthPosition >= 0) {
            return this.getObjectId((long)nthPosition);
        }
        int u31 = nthPosition >>> 1;
        int one = nthPosition & 1;
        return this.getObjectId((long)u31 << 1 | (long)one);
    }

    public long getOffset(long var1);

    public long findOffset(AnyObjectId var1);

    public int findPosition(AnyObjectId var1);

    public long findCRC32(AnyObjectId var1) throws MissingObjectException, UnsupportedOperationException;

    public boolean hasCRC32Support();

    public void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3) throws IOException;

    public byte[] getChecksum();

    public static abstract class EntriesIterator
    implements Iterator<MutableEntry> {
        private final long objectCount;
        private final MutableEntry entry = new MutableEntry();
        private long returnedNumber = 0L;

        protected EntriesIterator(long objectCount) {
            this.objectCount = objectCount;
        }

        @Override
        public boolean hasNext() {
            return this.returnedNumber < this.objectCount;
        }

        @Override
        public MutableEntry next() {
            this.readNext();
            ++this.returnedNumber;
            return this.entry;
        }

        protected abstract void readNext();

        protected void setIdBuffer(int[] raw, int idx) {
            this.entry.idBuffer.fromRaw(raw, idx);
        }

        protected void setIdBuffer(byte[] raw, int idx) {
            this.entry.idBuffer.fromRaw(raw, idx);
        }

        protected void setOffset(long offset) {
            this.entry.offset = offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MutableEntry {
        final MutableObjectId idBuffer = new MutableObjectId();
        long offset;

        public long getOffset() {
            return this.offset;
        }

        public String name() {
            return this.idBuffer.name();
        }

        public ObjectId toObjectId() {
            return this.idBuffer.toObjectId();
        }

        public MutableEntry cloneEntry() {
            MutableEntry r = new MutableEntry();
            r.idBuffer.fromObjectId(this.idBuffer);
            r.offset = this.offset;
            return r;
        }
    }
}

