/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.SystemReader;

public class GitTimeParser {
    private static final Map<ParseableSimpleDateFormat, DateTimeFormatter> formatCache = new HashMap<ParseableSimpleDateFormat, DateTimeFormatter>();

    public static LocalDateTime parse(String dateStr) throws ParseException {
        return GitTimeParser.parse(dateStr, SystemReader.getInstance().civilNow());
    }

    static LocalDateTime parse(String dateStr, LocalDateTime now) throws ParseException {
        if ("never".equalsIgnoreCase(dateStr = dateStr.trim())) {
            return LocalDateTime.MAX;
        }
        LocalDateTime ret = GitTimeParser.parse_relative(dateStr, now);
        if (ret != null) {
            return ret;
        }
        ParseableSimpleDateFormat[] parseableSimpleDateFormatArray = ParseableSimpleDateFormat.values();
        int n = parseableSimpleDateFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParseableSimpleDateFormat f = parseableSimpleDateFormatArray[n2];
            try {
                return GitTimeParser.parse_simple(dateStr, f);
            }
            catch (DateTimeParseException dateTimeParseException) {
                ++n2;
            }
        }
        ParseableSimpleDateFormat[] values = ParseableSimpleDateFormat.values();
        StringBuilder allFormats = new StringBuilder("\"").append(values[0].formatStr);
        int i = 1;
        while (i < values.length) {
            allFormats.append("\", \"").append(values[i].formatStr);
            ++i;
        }
        allFormats.append("\"");
        throw new ParseException(MessageFormat.format(JGitText.get().cannotParseDate, dateStr, allFormats.toString()), 0);
    }

    private static LocalDateTime parse_simple(String dateStr, ParseableSimpleDateFormat f) throws DateTimeParseException {
        DateTimeFormatter dateFormat = formatCache.computeIfAbsent(f, format -> DateTimeFormatter.ofPattern(parseableSimpleDateFormat.formatStr).withLocale(SystemReader.getInstance().getLocale()));
        TemporalAccessor parsed = dateFormat.parse(dateStr);
        return parsed.isSupported(ChronoField.HOUR_OF_DAY) ? LocalDateTime.from(parsed) : LocalDate.from(parsed).atStartOfDay();
    }

    private static LocalDateTime parse_relative(String dateStr, LocalDateTime now) {
        if ("now".equals(dateStr)) {
            return now;
        }
        if ("yesterday".equals(dateStr)) {
            return now.minusDays(1L);
        }
        String[] parts = dateStr.split("\\.| ");
        int partsLength = parts.length;
        if (partsLength < 3 || (partsLength & 1) == 0 || !"ago".equals(parts[parts.length - 1])) {
            return null;
        }
        int i = 0;
        while (i < parts.length - 2) {
            int number;
            try {
                number = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (parts[i + 1] == null) {
                return null;
            }
            switch (parts[i + 1]) {
                case "year": 
                case "years": {
                    now = now.minusYears(number);
                    break;
                }
                case "months": 
                case "month": {
                    now = now.minusMonths(number);
                    break;
                }
                case "week": 
                case "weeks": {
                    now = now.minusWeeks(number);
                    break;
                }
                case "day": 
                case "days": {
                    now = now.minusDays(number);
                    break;
                }
                case "hour": 
                case "hours": {
                    now = now.minusHours(number);
                    break;
                }
                case "minute": 
                case "minutes": {
                    now = now.minusMinutes(number);
                    break;
                }
                case "second": 
                case "seconds": {
                    now = now.minusSeconds(number);
                    break;
                }
                default: {
                    return null;
                }
            }
            i += 2;
        }
        return now;
    }

    static enum ParseableSimpleDateFormat {
        ISO("yyyy-MM-dd HH:mm:ss Z"),
        RFC("EEE, dd MMM yyyy HH:mm:ss Z"),
        SHORT("yyyy-MM-dd"),
        SHORT_WITH_DOTS_REVERSE("dd.MM.yyyy"),
        SHORT_WITH_DOTS("yyyy.MM.dd"),
        SHORT_WITH_SLASH("MM/dd/yyyy"),
        DEFAULT("EEE MMM dd HH:mm:ss yyyy Z"),
        LOCAL("EEE MMM dd HH:mm:ss yyyy");

        private final String formatStr;

        private ParseableSimpleDateFormat(String formatStr) {
            this.formatStr = formatStr;
        }
    }
}

