/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.completion;

import java.util.function.Consumer;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionBasedOnRelaxNGWithFileAssociationTest
extends BaseFileTempTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLCompletionBasedOnRelaxNGWithFileAssociationTest.createRelaxNGAssociations("src/test/resources/relaxng/"));
        };
        String xml = "<|";
        XMLCompletionBasedOnRelaxNGWithFileAssociationTest.testCompletionFor(xml, "file:///test/tei1.xml", configuration, XMLAssert.c("TEI", XMLAssert.te(0, 0, 0, 1, "<TEI></TEI>"), "<TEI"), XMLAssert.c("teiCorpus", XMLAssert.te(0, 0, 0, 1, "<teiCorpus></teiCorpus>"), "<teiCorpus"));
    }

    private static XMLFileAssociation[] createRelaxNGAssociations(String baseSystemId) {
        XMLFileAssociation tei = new XMLFileAssociation();
        tei.setPattern("tei*.xml");
        tei.setSystemId(baseSystemId + "tei_all.rng");
        return new XMLFileAssociation[]{tei};
    }

    private static void testCompletionFor(String xml, String fileURI, Consumer<XMLLanguageService> configuration, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, configuration, fileURI, null, true, expectedItems);
    }
}

