/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsl;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XSLValidationExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void xslValid() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n</xsl:stylesheet>";
        this.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void xslInvalid() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n<xsl:bad-element />\r\n</xsl:stylesheet>";
        this.testDiagnosticsFor(xml, XMLAssert.d(2, 1, 2, 16, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a));
    }

    private void testDiagnosticsFor(String xml, Diagnostic ... expected) throws BadLocationException {
        XMLAssert.testDiagnosticsFor(xml, expected);
    }
}

