/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.hover.HoverParticipantAdapter;
import org.eclipse.lemminx.services.extensions.hover.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.hover.IHoverRequest;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.junit.jupiter.api.Test;

public class HTMLHoverExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void testSingle() throws BadLocationException {
        HTMLHoverExtensionsTest.assertHover("|<html></html>");
        HTMLHoverExtensionsTest.assertHover("<|html></html>", "<html>", XMLAssert.r(0, 1, 0, 5));
        HTMLHoverExtensionsTest.assertHover("<h|tml></html>", "<html>", XMLAssert.r(0, 1, 0, 5));
        HTMLHoverExtensionsTest.assertHover("<htm|l></html>", "<html>", XMLAssert.r(0, 1, 0, 5));
        HTMLHoverExtensionsTest.assertHover("<html|></html>", "<html>", XMLAssert.r(0, 1, 0, 5));
        HTMLHoverExtensionsTest.assertHover("<html>|</html>");
        HTMLHoverExtensionsTest.assertHover("<html><|/html>");
        HTMLHoverExtensionsTest.assertHover("<html></|html>", "</html>", XMLAssert.r(0, 8, 0, 12));
        HTMLHoverExtensionsTest.assertHover("<html></h|tml>", "</html>", XMLAssert.r(0, 8, 0, 12));
        HTMLHoverExtensionsTest.assertHover("<html></ht|ml>", "</html>", XMLAssert.r(0, 8, 0, 12));
        HTMLHoverExtensionsTest.assertHover("<html></htm|l>", "</html>", XMLAssert.r(0, 8, 0, 12));
        HTMLHoverExtensionsTest.assertHover("<html></html|>", "</html>", XMLAssert.r(0, 8, 0, 12));
        HTMLHoverExtensionsTest.assertHover("<html></html>|");
        HTMLHoverExtensionsTest.assertHover("<html>hover|Text</html>", "hoverText", XMLAssert.r(0, 6, 0, 15));
        HTMLHoverExtensionsTest.assertHover("<html>h|overText</html>", "hoverText", XMLAssert.r(0, 6, 0, 15));
        HTMLHoverExtensionsTest.assertHover("<html> |</html>", " ", XMLAssert.r(0, 6, 0, 7));
    }

    private static void assertHover(String value) throws BadLocationException {
        HTMLHoverExtensionsTest.assertHover(value, null, null);
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverOffset) throws BadLocationException {
        XMLAssert.assertHover(new HTMLLanguageService(), value, null, null, expectedHoverLabel, expectedHoverOffset);
    }

    private static class HTMLLanguageService
    extends XMLLanguageService {
        public HTMLLanguageService() {
            super.registerHoverParticipant((IHoverParticipant)new HTMLHoverParticipant());
        }

        class HTMLHoverParticipant
        extends HoverParticipantAdapter {
            HTMLHoverParticipant() {
            }

            public Hover onTag(IHoverRequest request, CancelChecker cancelChecker) {
                String tag = request.getCurrentTag();
                String tagLabel = request.isOpen() ? "<" + tag + ">" : "</" + tag + ">";
                return this.createHover(tagLabel);
            }

            public Hover onText(IHoverRequest request, CancelChecker cancelChecker) throws Exception {
                return this.createHover(request.getNode().getTextContent());
            }

            private Hover createHover(String value) {
                if (value == null) {
                    return null;
                }
                return new Hover(new MarkupContent("plaintext", value));
            }
        }
    }
}

