/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerHelloHandler;

public class OpcServerWebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private String subprotocol;
    private final UaStackServer stackServer;

    public OpcServerWebSocketFrameHandler(UaStackServer stackServer) {
        this.stackServer = stackServer;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            WebSocketServerProtocolHandler.HandshakeComplete handshake = (WebSocketServerProtocolHandler.HandshakeComplete)event;
            this.subprotocol = handshake.selectedSubprotocol();
            if ("opcua+uacp".equalsIgnoreCase(this.subprotocol)) {
                UascServerHelloHandler helloHandler = new UascServerHelloHandler(this.stackServer, TransportProfile.WSS_UASC_UABINARY);
                ctx.channel().pipeline().addLast(new ChannelHandler[]{helloHandler});
            } else {
                throw new IllegalArgumentException("subprotocol: " + this.subprotocol);
            }
        }
        super.userEventTriggered(ctx, event);
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        if ("opcua+uacp".equalsIgnoreCase(this.subprotocol)) {
            ctx.fireChannelRead((Object)msg.content().retain());
        } else {
            if ("opcua+uajson".equalsIgnoreCase(this.subprotocol)) {
                String text = ((TextWebSocketFrame)msg).text();
                throw new IllegalArgumentException("subprotocol: " + this.subprotocol);
            }
            ctx.close();
        }
    }
}

