/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.ICompositeTableElementFactory;
import org.eclipse.swt.nebula.widgets.compositetable.IDeleteHandler;
import org.eclipse.swt.nebula.widgets.compositetable.IInsertHandler;
import org.eclipse.swt.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.swt.nebula.widgets.compositetable.IRowFocusListener;
import org.eclipse.swt.nebula.widgets.compositetable.InternalCompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.RowConstructionListener;
import org.eclipse.swt.nebula.widgets.compositetable.ScrollListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class CompositeTable
extends Canvas {
    private boolean runTime = false;
    private int numRowsInCollection = 0;
    private int maxRowsVisible = Integer.MAX_VALUE;
    private Constructor headerConstructor = null;
    private Control headerControl = null;
    private Constructor rowConstructor = null;
    private Control rowControl = null;
    private ICompositeTableElementFactory elementFactory = null;
    private InternalCompositeTable contentPane = null;
    private int numChildrenLastTime = 0;
    boolean linesVisible = true;
    String insertHint = "Press <Ctrl-INSERT> to insert new data.";
    private int topRow = 0;
    LinkedList contentProviders = new LinkedList();
    LinkedList rowFocusListeners = new LinkedList();
    LinkedList insertHandlers = new LinkedList();
    LinkedList deleteHandlers = new LinkedList();
    LinkedList rowConstructionListeners = new LinkedList();
    boolean deleteEnabled = true;
    LinkedList scrollListeners = new LinkedList();
    private boolean traverseOnTabsEnabled = true;
    private List keyEventListeners = new ArrayList();
    private List mouseListeners = new ArrayList();
    private List mouseMoveListeners = new ArrayList();

    public CompositeTable(Composite parent, int style) {
        super(parent, style);
        this.setBackground(Display.getCurrent().getSystemColor(25));
        this.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (CompositeTable.this.headerControl == null && CompositeTable.this.rowControl == null) {
                    return new Point(2, 20);
                }
                Point headerSize = new Point(0, 0);
                if (CompositeTable.this.headerControl != null) {
                    headerSize = CompositeTable.this.headerControl.computeSize(-1, -1);
                }
                Point rowSize = new Point(0, 0);
                if (CompositeTable.this.rowControl != null) {
                    rowSize = CompositeTable.this.rowControl.computeSize(-1, -1);
                }
                Point result = new Point(Math.max(headerSize.x, rowSize.x), headerSize.y + rowSize.y);
                return result;
            }

            protected void layout(Composite composite, boolean flushCache) {
                CompositeTable.this.resize();
            }
        });
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.contentPane != null) {
            this.contentPane.setBackground(color);
        }
    }

    protected final void resize() {
        if (this.isRunTime()) {
            Control[] children = this.getChildren();
            int childrenLength = 0;
            int i = 0;
            while (i < children.length) {
                if (!(children[i] instanceof InternalCompositeTable)) {
                    ++childrenLength;
                }
                ++i;
            }
            if (this.numChildrenLastTime != childrenLength) {
                this.resizeAndRecordPrototypeRows();
                this.showPrototypes(false);
                this.contentPane.dispose();
                this.contentPane = new InternalCompositeTable((Composite)this, 0);
            }
            this.updateVisibleRows();
        } else {
            this.resizeAndRecordPrototypeRows();
        }
    }

    protected void updateVisibleRows() {
        if (this.contentPane == null) {
            this.switchToRunMode();
        }
        Point size = this.getSize();
        this.contentPane.setBounds(0, 0, size.x, size.y);
    }

    private void switchToRunMode() {
        this.showPrototypes(false);
        this.contentPane = new InternalCompositeTable((Composite)this, 0);
    }

    private void switchToDesignMode() {
        this.contentPane.dispose();
        this.contentPane = null;
        this.showPrototypes(true);
        this.resizeAndRecordPrototypeRows();
    }

    private void showPrototypes(boolean newValue) {
        if (this.headerControl != null) {
            this.headerControl.setVisible(newValue);
        }
        if (this.rowControl != null) {
            this.rowControl.setVisible(newValue);
        }
    }

    protected void resizeAndRecordPrototypeRows() {
        Control[] children;
        Control[] finalChildren = children = this.getChildren();
        finalChildren = this.findPrototypeHeaderAndRowObjects(children);
        this.headerConstructor = null;
        this.headerControl = null;
        this.rowConstructor = null;
        this.rowControl = null;
        if (this.elementFactory != null) {
            if (finalChildren.length == 0) {
                this.headerControl = this.elementFactory.createHeader((Composite)this, 0);
                this.rowControl = this.elementFactory.createRow((Composite)this, 0);
                finalChildren = new Control[]{this.headerControl, this.rowControl};
            } else {
                this.headerControl = finalChildren[0];
                this.rowControl = finalChildren[1];
            }
        } else {
            if (finalChildren.length == 0) {
                return;
            }
            this.findPrototypeConstructors(finalChildren);
        }
        this.resizePrototypeObjects(finalChildren);
        this.numChildrenLastTime = finalChildren.length;
    }

    private Control[] findPrototypeHeaderAndRowObjects(Control[] children) {
        ArrayList<Control> realChildren = new ArrayList<Control>();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof InternalCompositeTable) && realChildren.size() < 2) {
                realChildren.add(children[i]);
            }
            ++i;
        }
        Control[] finalChildren = realChildren.toArray(new Control[realChildren.size()]);
        return finalChildren;
    }

    private void findPrototypeConstructors(Control[] finalChildren) {
        if (finalChildren.length == 1) {
            try {
                this.rowControl = (Composite)finalChildren[0];
                this.rowConstructor = finalChildren[0].getClass().getConstructor(Composite.class, Integer.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get constructor object for header or row", e);
            }
        }
        try {
            this.headerConstructor = finalChildren[0].getClass().getConstructor(Composite.class, Integer.TYPE);
            this.headerControl = finalChildren[0];
            this.rowConstructor = finalChildren[1].getClass().getConstructor(Composite.class, Integer.TYPE);
            this.rowControl = finalChildren[1];
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get constructor object for header or row", e);
        }
    }

    private void resizePrototypeObjects(Control[] finalChildren) {
        int top = 0;
        int width = this.getSize().x;
        int i = 0;
        while (i < finalChildren.length) {
            Control control = finalChildren[i];
            int height = control.computeSize((int)-1, (int)-1).y;
            control.setBounds(0, top, width, height);
            top += height;
            ++i;
        }
    }

    public boolean isRunTime() {
        return this.runTime;
    }

    public void setRunTime(boolean runTime) {
        if (this.runTime != runTime) {
            this.runTime = runTime;
            if (runTime) {
                if (this.rowControl == null) {
                    this.resizeAndRecordPrototypeRows();
                }
                this.switchToRunMode();
            } else {
                this.switchToDesignMode();
            }
        }
    }

    public boolean getLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.linesVisible = linesVisible;
    }

    public String getInsertHint() {
        return this.insertHint;
    }

    public void setInsertHint(String newHint) {
        this.insertHint = newHint;
        if (this.contentPane != null && this.numRowsInCollection < 1) {
            this.contentPane.emptyTablePlaceholder.setMessage(newHint);
        }
    }

    public int getMaxRowsVisible() {
        return this.maxRowsVisible;
    }

    public void setMaxRowsVisible(int maxRowsVisible) {
        this.maxRowsVisible = maxRowsVisible;
        if (this.contentPane != null) {
            this.contentPane.setMaxRowsVisible(maxRowsVisible);
        }
    }

    public int getNumRowsVisible() {
        if (this.contentPane != null) {
            return this.contentPane.getNumRowsVisible();
        }
        return -1;
    }

    public int getNumRowsInCollection() {
        return this.numRowsInCollection;
    }

    public void setNumRowsInCollection(int numRowsInCollection) {
        if (this.rowControl == null) {
            this.resizeAndRecordPrototypeRows();
            if (this.contentPane != null) {
                this.setRunTime(false);
                this.setRunTime(true);
            }
        }
        this.numRowsInCollection = numRowsInCollection;
        if (this.contentPane != null) {
            this.contentPane.setNumRowsInCollection(numRowsInCollection);
        }
    }

    public int getTopRow() {
        if (this.contentPane != null) {
            return this.contentPane.getTopRow();
        }
        return this.topRow;
    }

    public void setTopRow(int topRow, boolean updateSelection) {
        if (topRow < 0 || topRow > this.numRowsInCollection - 1) {
            throw new IllegalArgumentException("topRow outside legal range!");
        }
        if (topRow + this.getNumRowsVisible() - 1 > this.numRowsInCollection) {
            topRow = this.numRowsInCollection - this.getNumRowsVisible();
        }
        this.topRow = topRow;
        if (this.contentPane != null) {
            this.contentPane.setTopRow(topRow, updateSelection);
        }
    }

    public void setTopRow(int topRow) {
        if (topRow < 0 || topRow > this.numRowsInCollection - 1) {
            throw new IllegalArgumentException("topRow outside legal range!");
        }
        if (topRow + this.getNumRowsVisible() - 1 > this.numRowsInCollection) {
            topRow = this.numRowsInCollection - this.getNumRowsVisible();
        }
        this.topRow = topRow;
        if (this.contentPane != null) {
            this.contentPane.setTopRow(topRow);
        }
    }

    public boolean doMakeFocusedRowVisible() {
        if (this.contentPane != null) {
            return this.contentPane.doMakeFocusedRowVisible();
        }
        return false;
    }

    public void doFocusInitialRow() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doFocusInitialRow();
    }

    public void doFocusLastRow() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doFocusLastRow();
    }

    public void doPageUp() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doPageUp();
    }

    public void doPageDown() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doPageDown();
    }

    public void doRowUp() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doRowUp();
    }

    public void doRowDown() {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.doRowDown();
    }

    public boolean doInsertRow() {
        if (this.contentPane == null) {
            return false;
        }
        return this.contentPane.doInsertRow();
    }

    public boolean doDeleteRow() {
        if (this.contentPane == null) {
            return false;
        }
        return this.contentPane.doDeleteRow();
    }

    public void refreshAllRows() {
        if (this.contentPane != null) {
            this.contentPane.updateVisibleRows();
            this.contentPane.refreshAllRows();
        }
    }

    public void refreshRow(int row) {
        if (this.contentPane != null) {
            this.contentPane.refreshRow(row);
        }
    }

    public int getCurrentColumn() {
        if (this.contentPane == null) {
            return -1;
        }
        return this.getSelection().x;
    }

    public void setCurrentColumn(int column) {
        this.setSelection(column, this.getCurrentRow());
    }

    public int getCurrentRow() {
        if (this.contentPane == null) {
            return -1;
        }
        return this.getSelection().y;
    }

    public void setCurrentRow(int row) {
        this.setSelection(this.getCurrentColumn(), row);
    }

    public Control getCurrentRowControl() {
        return this.contentPane.getCurrentRowControl();
    }

    public Control[] getRowControls() {
        return this.contentPane.getRowControls();
    }

    public Control getHeader() {
        return this.contentPane != null ? this.contentPane.getHeader() : null;
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.contentPane != null) {
            this.contentPane.setMenu(menu);
        }
    }

    public int getControlRow(Control rowControl) {
        return this.contentPane.getControlRow(rowControl);
    }

    public Point getSelection() {
        if (this.contentPane == null) {
            return null;
        }
        return this.contentPane.getSelection();
    }

    public void setSelection(Point selection) {
        this.setSelection(selection.x, selection.y);
    }

    public void setSelection(int column, int row) {
        if (this.contentPane == null) {
            return;
        }
        this.contentPane.setSelection(column, row);
    }

    public void clearSelection() {
        if (this.contentPane != null) {
            this.contentPane.clearSelection();
        }
    }

    public Constructor getHeaderConstructor() {
        return this.headerConstructor;
    }

    public Constructor getRowConstructor() {
        return this.rowConstructor;
    }

    public Control getHeaderControl() {
        return this.headerControl;
    }

    public Control getRowControl() {
        return this.rowControl;
    }

    public void addRowContentProvider(IRowContentProvider contentProvider) {
        this.contentProviders.add(contentProvider);
    }

    public void removeRowContentProvider(IRowContentProvider contentProvider) {
        this.contentProviders.remove(contentProvider);
    }

    public void addRowFocusListener(IRowFocusListener rowListener) {
        this.rowFocusListeners.add(rowListener);
    }

    public void removeRowFocusListener(IRowFocusListener listener) {
        this.rowFocusListeners.remove(listener);
    }

    public void addInsertHandler(IInsertHandler insertHandler) {
        this.insertHandlers.add(insertHandler);
    }

    public void removeInsertHandler(IInsertHandler insertHandler) {
        this.insertHandlers.remove(insertHandler);
    }

    public void addDeleteHandler(IDeleteHandler deleteHandler) {
        this.deleteHandlers.add(deleteHandler);
    }

    public void removeDeleteHandler(IDeleteHandler deleteHandler) {
        this.deleteHandlers.remove(deleteHandler);
    }

    public void addRowConstructionListener(RowConstructionListener rowConstructionListener) {
        this.rowConstructionListeners.add(rowConstructionListener);
    }

    public void removeRowConstructionListener(RowConstructionListener rowConstructionListener) {
        this.rowConstructionListeners.remove(rowConstructionListener);
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public void setDeleteEnabled(boolean deleteEnabled) {
        this.deleteEnabled = deleteEnabled;
    }

    public void addScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.remove(scrollListener);
    }

    public boolean isTraverseOnTabsEnabled() {
        return this.traverseOnTabsEnabled;
    }

    public void setTraverseOnTabsEnabled(boolean enabled) {
        this.traverseOnTabsEnabled = enabled;
    }

    public void addKeyListener(KeyListener listener) {
        this.keyEventListeners.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.keyEventListeners.remove(listener);
    }

    void fireKeyPressed(KeyEvent e) {
        for (KeyListener l : this.keyEventListeners) {
            l.keyPressed(e);
        }
    }

    void fireKeyReleased(KeyEvent e) {
        for (KeyListener l : this.keyEventListeners) {
            l.keyReleased(e);
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    void fireMouseDown(MouseEvent e) {
        for (MouseListener l : this.mouseListeners) {
            l.mouseDown(e);
        }
    }

    void fireMouseUp(MouseEvent e) {
        for (MouseListener l : this.mouseListeners) {
            l.mouseUp(e);
        }
    }

    void fireMouseDouble(MouseEvent e) {
        for (MouseListener l : this.mouseListeners) {
            l.mouseDoubleClick(e);
        }
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.mouseMoveListeners.add(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.mouseMoveListeners.remove(listener);
    }

    void fireMouseMove(MouseEvent e) {
        for (MouseMoveListener l : this.mouseMoveListeners) {
            l.mouseMove(e);
        }
    }

    public ICompositeTableElementFactory getElementFactory() {
        return this.elementFactory;
    }

    public void setElementFactory(ICompositeTableElementFactory elementFactory) {
        this.elementFactory = elementFactory;
        if (this.contentPane != null) {
            this.contentPane.setElementFactory(elementFactory);
        }
    }
}

