/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.InternalCompositeTable;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultEmptyTablePlaceholder
extends Canvas {
    protected boolean focusControl = false;
    protected InternalCompositeTable parentTable = null;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DefaultEmptyTablePlaceholder.this.removeTraverseListener(DefaultEmptyTablePlaceholder.this.traverseListener);
            DefaultEmptyTablePlaceholder.this.removeFocusListener(DefaultEmptyTablePlaceholder.this.focusListener);
            DefaultEmptyTablePlaceholder.this.removeDisposeListener(DefaultEmptyTablePlaceholder.this.disposeListener);
            DefaultEmptyTablePlaceholder.this.getParent().removeControlListener(DefaultEmptyTablePlaceholder.this.controlListener);
        }
    };
    private ControlListener controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            DefaultEmptyTablePlaceholder.this.resize();
        }
    };
    private String message = "";
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            DefaultEmptyTablePlaceholder.this.focusControl = true;
            DefaultEmptyTablePlaceholder.this.redraw();
        }

        public void focusLost(FocusEvent e) {
            DefaultEmptyTablePlaceholder.this.focusControl = false;
            DefaultEmptyTablePlaceholder.this.redraw();
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
        }
    };

    public DefaultEmptyTablePlaceholder(Composite parent, int style) {
        super(parent, style);
        this.parentTable = (InternalCompositeTable)parent.getParent().getParent();
        parent.addControlListener(this.controlListener);
        this.addTraverseListener(this.traverseListener);
        this.addFocusListener(this.focusListener);
        this.addDisposeListener(this.disposeListener);
        this.setBackground(this.getParent().getBackground());
        this.resize();
    }

    protected void resize() {
        Point headerSize = new Point(0, 0);
        Control header = this.parentTable.getHeaderControl();
        if (header != null) {
            headerSize = header.getSize();
        }
        Point parentSize = this.getParent().getSize();
        this.setBounds(0, headerSize.y + 2, parentSize.x - 4, parentSize.y - headerSize.y - 6);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.redraw();
    }
}

