/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.DefaultEmptyTablePlaceholder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EmptyTablePlaceholder
extends DefaultEmptyTablePlaceholder {
    private final Color RED;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            EmptyTablePlaceholder.this.removeKeyListener(EmptyTablePlaceholder.this.keyListener);
            EmptyTablePlaceholder.this.removePaintListener(EmptyTablePlaceholder.this.paintListener);
        }
    };
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Color oldColor = e.gc.getForeground();
            int oldLineStyle = e.gc.getLineStyle();
            int oldLineWidth = e.gc.getLineWidth();
            try {
                if (EmptyTablePlaceholder.this.focusControl) {
                    e.gc.setLineStyle(2);
                    e.gc.setLineWidth(2);
                    Point parentSize = EmptyTablePlaceholder.this.getSize();
                    e.gc.drawRectangle(1, 2, parentSize.x - 2, parentSize.y - 3);
                }
                e.gc.setForeground(EmptyTablePlaceholder.this.RED);
                e.gc.drawText(EmptyTablePlaceholder.this.getMessage(), 3, 3);
            }
            finally {
                e.gc.setForeground(oldColor);
                e.gc.setLineStyle(oldLineStyle);
                e.gc.setLineWidth(oldLineWidth);
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000009) {
                EmptyTablePlaceholder.this.parentTable.keyPressed(null, e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    public EmptyTablePlaceholder(Composite parent, int style) {
        super(parent, style);
        this.addKeyListener(this.keyListener);
        this.addPaintListener(this.paintListener);
        this.RED = Display.getCurrent().getSystemColor(3);
        this.resize();
    }
}

