/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import java.util.Iterator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.nebula.widgets.compositetable.AbstractGridRowLayout;
import org.eclipse.swt.nebula.widgets.compositetable.ColumnControlListener;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTableLayout;
import org.eclipse.swt.nebula.widgets.compositetable.GridRowLayout;
import org.eclipse.swt.nebula.widgets.compositetable.HeaderLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerResizableGridRowLayout
extends GridRowLayout {
    private AbstractGridRowLayout delegate = null;
    private int[] columnOrder;
    private Composite control;

    @Override
    protected int getAvailableWidth(Composite headerOrRow) {
        return super.getAvailableWidth(headerOrRow.getParent());
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        this.control = composite;
        this.getLayoutDelegate(composite);
        return super.computeSize(composite, wHint, hHint, flushCache);
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        this.control = composite;
        this.getLayoutDelegate(composite);
        super.layout(composite, flushCache);
    }

    @Override
    public int[] getWeights() {
        if (this.delegate == null) {
            return super.getWeights();
        }
        return this.delegate.getWeights();
    }

    @Override
    public AbstractGridRowLayout setWeights(int[] weights) {
        if (this.delegate == null) {
            return super.setWeights(weights);
        }
        return this.delegate.setWeights(weights);
    }

    @Override
    public int getSumOfAllWeights() {
        if (this.delegate == null) {
            return super.getSumOfAllWeights();
        }
        return this.delegate.getSumOfAllWeights();
    }

    @Override
    public boolean isFittingHorizontally() {
        if (this.delegate == null) {
            return super.isFittingHorizontally();
        }
        return this.delegate.isFittingHorizontally();
    }

    @Override
    public AbstractGridRowLayout setFittingHorizontally(boolean fittingHorizontally) {
        if (this.delegate == null) {
            return super.setFittingHorizontally(fittingHorizontally);
        }
        return this.delegate.setFittingHorizontally(fittingHorizontally);
    }

    @Override
    public boolean isFlowingHorizontally() {
        if (this.delegate == null) {
            return super.isFlowingHorizontally();
        }
        return this.delegate.isFlowingHorizontally();
    }

    @Override
    public AbstractGridRowLayout setFlowingHorizontally(boolean flowingHorizontally) {
        if (this.delegate == null) {
            return super.setFlowingHorizontally(flowingHorizontally);
        }
        return this.delegate.setFlowingHorizontally(flowingHorizontally);
    }

    @Override
    protected Widget getColumnAt(Composite rowOrHeader, int offset) {
        if (this.columnOrder == null) {
            return super.getColumnAt(rowOrHeader, offset);
        }
        Control[] children = rowOrHeader.getChildren();
        return children[this.columnOrder[offset]];
    }

    protected Iterator<Widget> getColumnIterator(Composite rowOrHeader, int offset) {
        if (this.columnOrder == null) {
            return new Iterator<Widget>(rowOrHeader, offset){
                Control[] children;
                int iteratorOffset;
                {
                    this.children = composite.getChildren();
                    this.iteratorOffset = n;
                }

                @Override
                public boolean hasNext() {
                    return this.iteratorOffset + 1 < this.children.length;
                }

                @Override
                public Widget next() {
                    return this.children[++this.iteratorOffset];
                }

                @Override
                public void remove() {
                    throw new RuntimeException();
                }
            };
        }
        return new Iterator<Widget>(rowOrHeader, offset){
            Control[] children;
            int iteratorOffset;
            {
                this.children = composite.getChildren();
                this.iteratorOffset = InnerResizableGridRowLayout.this.columnOrder[n];
            }

            @Override
            public boolean hasNext() {
                return this.iteratorOffset + 1 < this.children.length;
            }

            @Override
            public Widget next() {
                return this.children[++this.iteratorOffset];
            }

            @Override
            public void remove() {
                throw new RuntimeException();
            }
        };
    }

    protected CompositeTableLayout getLayoutDelegate(Composite composite) {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.findHeader(composite);
        if (this.delegate != null) {
            return this.delegate;
        }
        this.createNullLayout(composite);
        return this.delegate;
    }

    private void createNullLayout(Composite composite) {
        int numChildren = composite.getChildren().length;
        this.delegate = new GridRowLayout(new int[numChildren], true);
    }

    private void findHeader(Composite row) {
        Control[] children = row.getParent().getParent().getChildren();
        int i = 0;
        while (i < children.length) {
            Composite child;
            Layout layout;
            if (children[i] instanceof Composite && (layout = (child = (Composite)children[i]).getLayout()) instanceof HeaderLayout) {
                this.delegate = (HeaderLayout)layout;
                this.addListenersToDelegate(row, (HeaderLayout)layout);
                return;
            }
            ++i;
        }
    }

    private void addListenersToDelegate(Composite row, HeaderLayout delegate) {
        delegate.addColumnControlListener(new GridColumnControlListener(row));
    }

    private class GridColumnControlListener
    extends ColumnControlListener {
        private final Composite row;
        private int savedResizedColNum;
        private int savedResizedColWidth;
        private int savedColToRightOfResizedColWidth;
        boolean runnableQueueIsClear = true;

        public GridColumnControlListener(Composite row) {
            this.row = row;
        }

        public void columnMoved(int[] newColumnOrder) {
            InnerResizableGridRowLayout.this.columnOrder = newColumnOrder;
            InnerResizableGridRowLayout.this.control.layout(true);
        }

        public void columnResized(int resizedColumnPosition, int resizedColumnWidth, int columnToTheRightOfResizedColumnWidth) {
            this.savedResizedColNum = resizedColumnPosition;
            this.savedResizedColWidth = resizedColumnWidth;
            this.savedColToRightOfResizedColWidth = columnToTheRightOfResizedColumnWidth;
            if (this.runnableQueueIsClear) {
                this.runnableQueueIsClear = false;
                this.row.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if (GridColumnControlListener.this.row.isDisposed()) {
                                return;
                            }
                            GridColumnControlListener.this.row.getChildren();
                            Control resizedColumn = (Control)InnerResizableGridRowLayout.this.getColumnAt(GridColumnControlListener.this.row, GridColumnControlListener.this.savedResizedColNum);
                            Point resizedColumnSize = resizedColumn.getSize();
                            int adjustedResizedColumnWidth = GridColumnControlListener.this.savedResizedColWidth;
                            int resizedColumnWidthChange = adjustedResizedColumnWidth - resizedColumnSize.x;
                            resizedColumn.setSize(adjustedResizedColumnWidth, resizedColumnSize.y);
                            if (!InnerResizableGridRowLayout.this.isFlowingHorizontally()) {
                                Control columnToTheRightOfResizedColumn = (Control)InnerResizableGridRowLayout.this.getColumnAt(GridColumnControlListener.this.row, GridColumnControlListener.this.savedResizedColNum + 1);
                                Rectangle rightBounds = columnToTheRightOfResizedColumn.getBounds();
                                columnToTheRightOfResizedColumn.setBounds(rightBounds.x + resizedColumnWidthChange, rightBounds.y, GridColumnControlListener.this.savedColToRightOfResizedColWidth, rightBounds.height);
                            } else {
                                Iterator<Widget> columnIterator = InnerResizableGridRowLayout.this.getColumnIterator(GridColumnControlListener.this.row, GridColumnControlListener.this.savedResizedColNum + 1);
                                while (columnIterator.hasNext()) {
                                    Control columnToTheRightOfResizedColumn = (Control)columnIterator.next();
                                    Rectangle rightBounds = columnToTheRightOfResizedColumn.getBounds();
                                    columnToTheRightOfResizedColumn.setBounds(rightBounds.x + resizedColumnWidthChange, rightBounds.y, rightBounds.width + resizedColumnWidthChange, rightBounds.height);
                                }
                            }
                        }
                        finally {
                            GridColumnControlListener.this.runnableQueueIsClear = true;
                        }
                    }
                });
            }
        }
    }
}

