/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable.viewer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.DefaultEmptyTablePlaceholder;
import org.eclipse.swt.nebula.widgets.compositetable.EmptyTablePlaceholder;
import org.eclipse.swt.nebula.widgets.compositetable.ICompositeTableElementFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTableViewer
extends StructuredViewer {
    private CompositeTable table;
    private boolean doFixSelection = false;
    private int fixedSelectionIndex = -1;
    private List<Object> listMap = new ArrayList<Object>();

    public CompositeTableViewer(CompositeTable table) {
        this.table = table;
        this.hookControl((Control)table);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        ICompositeTableElementFactory factory = new ICompositeTableElementFactory(){
            Constructor<Composite> rowConstructor;
            Constructor<Composite> headerConstructor;
            ICompositeTableElementFactory parentFactory;
            {
                this.rowConstructor = CompositeTableViewer.this.table.getRowConstructor();
                this.headerConstructor = CompositeTableViewer.this.table.getHeaderConstructor();
                this.parentFactory = CompositeTableViewer.this.table.getElementFactory();
            }

            private void addListeners(Control c, Listener eventHandler) {
                c.addListener(6, eventHandler);
                c.addListener(7, eventHandler);
                c.addListener(5, eventHandler);
                c.addListener(3, eventHandler);
                c.addListener(8, eventHandler);
                c.addListener(4, eventHandler);
                c.addListener(1, eventHandler);
                c.addListener(13, eventHandler);
                c.addListener(14, eventHandler);
                c.addListener(18, eventHandler);
                c.addListener(17, eventHandler);
                c.addListener(29, eventHandler);
            }

            private void recursivelyAddListeners(Control control, Listener listener) {
                this.addListeners(control, listener);
                if (control instanceof Composite) {
                    Control[] controlArray = ((Composite)control).getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        this.recursivelyAddListeners(child, listener);
                        ++n2;
                    }
                }
            }

            public Composite createRow(Composite parent, int style) {
                Composite row;
                if (this.parentFactory != null) {
                    row = this.parentFactory.createRow(parent, style);
                } else {
                    try {
                        row = this.rowConstructor.newInstance(parent, style);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Unable to construct control");
                    }
                }
                row.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        CompositeTableViewer.this.fixedSelectionIndex = -1;
                        CompositeTableViewer.this.doFixSelection = false;
                    }
                });
                this.recursivelyAddListeners((Control)row, new Listener(){

                    public void handleEvent(Event event) {
                        Event ev = new Event();
                        ev.widget = CompositeTableViewer.this.table;
                        ev.item = row;
                        ev.type = event.type;
                        ev.button = event.button;
                        ev.character = event.character;
                        ev.count = event.count;
                        ev.data = event.data;
                        ev.detail = event.detail;
                        ev.display = event.display;
                        ev.end = event.end;
                        ev.gc = event.gc;
                        ev.keyCode = event.keyCode;
                        ev.start = event.start;
                        ev.stateMask = event.stateMask;
                        ev.text = event.text;
                        ev.time = event.time;
                        ev.doit = true;
                        ev.width = event.width;
                        ev.height = event.height;
                        Point mappedCoordinates = event.display.map((Control)event.widget, (Control)CompositeTableViewer.this.table, event.x, event.y);
                        ev.x = mappedCoordinates.x;
                        ev.y = mappedCoordinates.y;
                        switch (event.type) {
                            case 6: {
                                boolean alreadyEntered = (Boolean)row.getData("alreadyEntered");
                                if (alreadyEntered) {
                                    ev.doit = false;
                                }
                                row.setData("alreadyEntered", (Object)true);
                                break;
                            }
                            case 7: {
                                if (row.getBounds().contains(mappedCoordinates)) {
                                    ev.doit = false;
                                    break;
                                }
                                row.setData("alreadyEntered", (Object)false);
                                break;
                            }
                            case 1: {
                                if (event.keyCode != 13) break;
                                ev.type = 14;
                            }
                        }
                        if (ev.doit) {
                            CompositeTableViewer.this.table.notifyListeners(ev.type, ev);
                        }
                    }
                });
                return row;
            }

            public Composite createHeader(Composite parent, int style) {
                Composite header;
                if (this.parentFactory != null) {
                    header = this.parentFactory.createRow(parent, style);
                } else {
                    try {
                        header = this.headerConstructor.newInstance(parent, style);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Unable to construct control");
                    }
                }
                return header;
            }

            public DefaultEmptyTablePlaceholder createEmptyPlaceholder(Composite parent, int style) {
                DefaultEmptyTablePlaceholder placeholder = null;
                if (this.parentFactory != null) {
                    placeholder = this.parentFactory.createEmptyPlaceholder(parent, style);
                }
                return placeholder == null ? new EmptyTablePlaceholder(parent, style) : placeholder;
            }
        };
        this.table.setElementFactory(factory);
    }

    protected Widget doFindInputItem(Object element) {
        if (this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.listMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        this.listRemoveAll();
        int i = 0;
        while (i < size) {
            Object el = children[i];
            this.listMap.add(el);
            this.mapElement(el, (Widget)this.getControl());
            ++i;
        }
        this.table.setData("listMap", this.listMap);
        this.table.setNumRowsInCollection(this.listMap.size());
    }

    protected Widget doFindItem(Object element) {
        if (element != null && this.listMapContains(element)) {
            return this.getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        int index = this.listMap.indexOf(element);
        if (index >= this.table.getTopRow() && index < this.table.getTopRow() + this.table.getNumRowsVisible()) {
            this.table.refreshRow(index - this.table.getTopRow());
        }
    }

    protected List<Object> getSelectionFromWidget() {
        ArrayList<Object> list = new ArrayList<Object>(1);
        if (!this.doFixSelection) {
            Object e;
            if (this.table.getSelection() != null && (e = this.getElementAt(this.table.getSelection().y + this.table.getTopRow())) != null) {
                list.add(e);
            }
        } else {
            Object e = this.getElementAt(this.fixedSelectionIndex);
            if (e != null) {
                list.add(e);
            }
        }
        return list;
    }

    public void reveal(Object element) {
        this.table.setTopRow(this.getElementIndex(element), false);
    }

    protected void listRemoveAll() {
        this.table.setNumRowsInCollection(0);
    }

    int getElementIndex(Object element) {
        IElementComparer comparer = this.getComparer();
        if (comparer == null) {
            return this.listMap.indexOf(element);
        }
        int size = this.listMap.size();
        int i = 0;
        while (i < size) {
            if (comparer.equals(element, this.listMap.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean listMapContains(Object element) {
        return this.getElementIndex(element) != -1;
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.listMap.size()) {
            return this.listMap.get(index);
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        Control list = this.getControl();
        if (element == null || this.equals(element, this.getRoot())) {
            List<Object> selection = this.getSelectionFromWidget();
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            int topIndex = -1;
            if (selection == null || selection.isEmpty()) {
                topIndex = this.listGetTopIndex();
            }
            Object[] children = null;
            list.setRedraw(false);
            try {
                this.listRemoveAll();
                children = this.getSortedChildren(this.getRoot());
                String[] items = new String[children.length];
                int i = 0;
                while (i < items.length) {
                    Object el = children[i];
                    this.listMap.add(el);
                    this.mapElement(el, (Widget)list);
                    ++i;
                }
                this.table.setData("listMap", this.listMap);
                this.table.setNumRowsInCollection(items.length);
            }
            finally {
                list.setRedraw(true);
            }
            if (topIndex == -1) {
                this.setSelectionToWidget(selection, false);
            } else {
                this.listSetTopIndex(Math.min(topIndex, children.length));
            }
        } else {
            this.doUpdateItem((Widget)list, element, true);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l.size() > 0) {
            this.table.setSelection(0, this.getElementIndex(l.get(0)) - this.table.getTopRow());
        }
    }

    public Control getControl() {
        return this.table;
    }

    protected int listGetTopIndex() {
        return this.table.getTopRow();
    }

    protected void listSetTopIndex(int index) {
        if (index > this.table.getNumRowsInCollection()) {
            this.table.setTopRow(index, false);
        }
    }

    public void fixSelectionIndex(Composite selectedRow) {
        this.fixedSelectionIndex = (Integer)selectedRow.getData("index");
        this.doFixSelection = true;
    }

    public void unfixSelectionIndex() {
        this.fixedSelectionIndex = -1;
        this.doFixSelection = false;
    }
}

