/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.deps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.packagedrone.utils.rpm.ReadableHeader;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.deps.Dependency;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.header.Header;

public final class Dependencies {
    private Dependencies() {
    }

    public static void putRequirements(Header<RpmTag> header, Collection<Dependency> requirements) {
        Dependencies.putDependencies(header, requirements, RpmTag.REQUIRE_NAME, RpmTag.REQUIRE_VERSION, RpmTag.REQUIRE_FLAGS);
    }

    public static void putProvides(Header<RpmTag> header, Collection<Dependency> provides) {
        Dependencies.putDependencies(header, provides, RpmTag.PROVIDE_NAME, RpmTag.PROVIDE_VERSION, RpmTag.PROVIDE_FLAGS);
    }

    public static void putConflicts(Header<RpmTag> header, Collection<Dependency> conflicts) {
        Dependencies.putDependencies(header, conflicts, RpmTag.CONFLICT_NAME, RpmTag.CONFLICT_VERSION, RpmTag.CONFLICT_FLAGS);
    }

    public static void putObsoletes(Header<RpmTag> header, Collection<Dependency> obsoletes) {
        Dependencies.putDependencies(header, obsoletes, RpmTag.OBSOLETE_NAME, RpmTag.OBSOLETE_VERSION, RpmTag.OBSOLETE_FLAGS);
    }

    public static void putSuggests(Header<RpmTag> header, Collection<Dependency> suggests) {
        Dependencies.putDependencies(header, suggests, RpmTag.SUGGEST_NAME, RpmTag.SUGGEST_VERSION, RpmTag.SUGGEST_FLAGS);
    }

    public static void putRecommends(Header<RpmTag> header, Collection<Dependency> recommends) {
        Dependencies.putDependencies(header, recommends, RpmTag.RECOMMEND_NAME, RpmTag.RECOMMEND_VERSION, RpmTag.RECOMMEND_FLAGS);
    }

    public static void putSupplements(Header<RpmTag> header, Collection<Dependency> supplements) {
        Dependencies.putDependencies(header, supplements, RpmTag.SUPPLEMENT_NAME, RpmTag.SUPPLEMENT_VERSION, RpmTag.SUPPLEMENT_FLAGS);
    }

    public static void putEnhances(Header<RpmTag> header, Collection<Dependency> enhances) {
        Dependencies.putDependencies(header, enhances, RpmTag.ENHANCE_NAME, RpmTag.ENHANCE_VERSION, RpmTag.ENHANCE_FLAGS);
    }

    private static void putDependencies(Header<RpmTag> header, Collection<Dependency> dependencies, RpmTag namesTag, RpmTag versionsTag, RpmTag flagsTag) {
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>(dependencies);
        Collections.sort(deps, Comparator.comparing(Dependency::getName).thenComparing(Comparator.comparing(Dependency::getVersion, Comparator.nullsFirst(Comparator.naturalOrder()))));
        Header.putFields(header, deps, namesTag, String[]::new, Dependency::getName, Header::putStringArray);
        Header.putFields(header, deps, versionsTag, String[]::new, Dependency::getVersion, Header::putStringArray);
        Header.putIntFields(header, deps, flagsTag, dep -> RpmDependencyFlags.encode(dep.getFlags()));
    }

    public static List<Dependency> getRequirements(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.REQUIRE_NAME, RpmTag.REQUIRE_VERSION, RpmTag.REQUIRE_FLAGS);
    }

    public static List<Dependency> getProvides(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.PROVIDE_NAME, RpmTag.PROVIDE_VERSION, RpmTag.PROVIDE_FLAGS);
    }

    public static List<Dependency> getConflicts(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.CONFLICT_NAME, RpmTag.CONFLICT_VERSION, RpmTag.CONFLICT_FLAGS);
    }

    public static List<Dependency> getObsoletes(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.OBSOLETE_NAME, RpmTag.OBSOLETE_VERSION, RpmTag.OBSOLETE_FLAGS);
    }

    public static List<Dependency> getSuggests(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.SUGGEST_NAME, RpmTag.SUGGEST_VERSION, RpmTag.SUGGEST_FLAGS);
    }

    public static List<Dependency> getRecommends(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.RECOMMEND_NAME, RpmTag.RECOMMEND_VERSION, RpmTag.RECOMMEND_FLAGS);
    }

    public static List<Dependency> getSupplements(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.SUPPLEMENT_NAME, RpmTag.SUPPLEMENT_VERSION, RpmTag.SUPPLEMENT_FLAGS);
    }

    public static List<Dependency> getEnhances(ReadableHeader<RpmTag> header) {
        return Dependencies.getDependencies(header, RpmTag.ENHANCE_NAME, RpmTag.ENHANCE_VERSION, RpmTag.ENHANCE_FLAGS);
    }

    private static List<Dependency> getDependencies(ReadableHeader<RpmTag> header, RpmTag namesTag, RpmTag versionsTag, RpmTag flagsTag) {
        Objects.requireNonNull(header);
        Object rawNames = header.getValue(namesTag).orElse(null);
        Object rawVersions = header.getValue(versionsTag).orElse(null);
        int[] rawFlags = header.getValue(flagsTag).orElse(null);
        if (rawFlags instanceof Integer[]) {
            Integer[] iflags = rawFlags;
            int[] flags = new int[iflags.length];
            for (int i = 0; i < iflags.length; ++i) {
                flags[i] = iflags[i];
            }
            rawFlags = flags;
        }
        if (rawNames instanceof String[] && rawVersions instanceof String[] && rawFlags instanceof int[]) {
            String[] names = rawNames;
            String[] versions = rawVersions;
            int[] flags = rawFlags;
            if (names.length == versions.length && names.length == flags.length) {
                ArrayList<Dependency> result = new ArrayList<Dependency>(names.length);
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    String version = versions[i];
                    EnumSet<RpmDependencyFlags> flagSet = RpmDependencyFlags.parse(flags[i]);
                    result.add(new Dependency(name, version, flagSet));
                }
                return result;
            }
        }
        return new LinkedList<Dependency>();
    }
}

