/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.parse;

import com.google.common.io.CountingInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmLead;
import org.eclipse.packagedrone.utils.rpm.RpmSignatureTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.Rpms;
import org.eclipse.packagedrone.utils.rpm.parse.HeaderValue;
import org.eclipse.packagedrone.utils.rpm.parse.InputHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.XZInputStream;

public class RpmInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(RpmInputStream.class);
    private static final byte[] DUMMY = new byte[128];
    private final DataInputStream in;
    private boolean closed;
    private RpmLead lead;
    private InputHeader<RpmSignatureTag> signatureHeader;
    private InputHeader<RpmTag> payloadHeader;
    private InputStream payloadStream;
    private CpioArchiveInputStream cpioStream;
    private final CountingInputStream count;

    public RpmInputStream(InputStream in) {
        this.count = new CountingInputStream(in);
        this.in = new DataInputStream((InputStream)this.count);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    protected void ensureInit() throws IOException {
        if (this.lead == null) {
            this.lead = this.readLead();
        }
        if (this.signatureHeader == null) {
            this.signatureHeader = this.readHeader(true);
        }
        if (this.payloadHeader == null) {
            this.payloadHeader = this.readHeader(false);
        }
        if (this.payloadStream == null) {
            this.payloadStream = this.setupPayloadStream();
            this.cpioStream = new CpioArchiveInputStream(this.payloadStream, "UTF-8");
        }
    }

    private InputStream setupPayloadStream() throws IOException {
        Object payloadFormatValue = this.payloadHeader.getTag(RpmTag.PAYLOAD_FORMAT);
        Object payloadCodingValue = this.payloadHeader.getTag(RpmTag.PAYLOAD_CODING);
        if (payloadFormatValue != null && !(payloadFormatValue instanceof String)) {
            throw new IOException("Payload format must be a single string");
        }
        if (payloadFormatValue != null && !(payloadCodingValue instanceof String)) {
            throw new IOException("Payload coding must be a single string");
        }
        String payloadFormat = (String)payloadFormatValue;
        String payloadCoding = (String)payloadCodingValue;
        if (payloadFormat == null || payloadFormat.isEmpty()) {
            payloadFormat = "cpio";
        }
        if (payloadCoding == null || payloadCoding.isEmpty()) {
            payloadCoding = "gzip";
        }
        if (!"cpio".equals(payloadFormat)) {
            throw new IOException(String.format("Unknown payload format: %s", payloadFormat));
        }
        switch (payloadCoding) {
            case "none": {
                return this.in;
            }
            case "gzip": {
                return new GzipCompressorInputStream((InputStream)this.in);
            }
            case "bzip2": {
                return new BZip2CompressorInputStream((InputStream)this.in);
            }
            case "lzma": {
                return new LZMAInputStream((InputStream)this.in);
            }
            case "xz": {
                return new XZInputStream((InputStream)this.in);
            }
        }
        throw new IOException(String.format("Unknown coding: %s", payloadCoding));
    }

    public CpioArchiveInputStream getCpioStream() {
        return this.cpioStream;
    }

    public RpmLead getLead() throws IOException {
        this.ensureInit();
        return this.lead;
    }

    public InputHeader<RpmSignatureTag> getSignatureHeader() throws IOException {
        this.ensureInit();
        return this.signatureHeader;
    }

    public InputHeader<RpmTag> getPayloadHeader() throws IOException {
        this.ensureInit();
        return this.payloadHeader;
    }

    protected RpmLead readLead() throws IOException {
        byte[] magic = this.readComplete(4);
        if (!Arrays.equals(magic, Rpms.LEAD_MAGIC)) {
            throw new IOException(String.format("File corrupt: Expected magic %s, read: %s", Arrays.toString(Rpms.LEAD_MAGIC), Arrays.toString(magic)));
        }
        byte[] version = this.readComplete(2);
        short type = this.in.readShort();
        short arch = this.in.readShort();
        byte[] nameData = this.readComplete(66);
        ByteBuffer nameBuffer = ByteBuffer.wrap(nameData);
        for (int i = 0; i < nameData.length; ++i) {
            if (nameData[i] != 0) continue;
            nameBuffer.limit(i);
            break;
        }
        String name = StandardCharsets.UTF_8.decode(nameBuffer).toString();
        short os = this.in.readShort();
        int sigType = this.in.readUnsignedShort();
        this.skipFully(16);
        return new RpmLead(version[0], version[1], name, sigType, type, arch, os);
    }

    protected <T extends RpmBaseTag> InputHeader<T> readHeader(boolean withPadding) throws IOException {
        int skip;
        long start = this.count.getCount();
        byte[] magic = this.readComplete(3);
        if (!Arrays.equals(magic, Rpms.HEADER_MAGIC)) {
            throw new IOException(String.format("File corrupt: Expected entry magic %s, read: %s", Arrays.toString(Rpms.HEADER_MAGIC), Arrays.toString(magic)));
        }
        byte version = this.in.readByte();
        if (version != 1) {
            throw new IOException(String.format("File corrupt: Invalid header entry version: %s (valid: 1)", version));
        }
        this.skipFully(4);
        int indexCount = this.in.readInt();
        int storeSize = this.in.readInt();
        HeaderValue[] entries = new HeaderValue[indexCount];
        for (int i = 0; i < indexCount; ++i) {
            entries[i] = this.readEntry();
        }
        ByteBuffer store = ByteBuffer.wrap(this.readComplete(storeSize));
        for (int i = 0; i < indexCount; ++i) {
            entries[i].fillFromStore(store);
        }
        if (withPadding && (skip = Rpms.padding(storeSize)) > 0) {
            logger.debug("Skipping {} pad bytes", (Object)skip);
            this.skipFully(skip);
        }
        long end = this.count.getCount();
        return new InputHeader(entries, start, end - start);
    }

    private HeaderValue readEntry() throws IOException {
        int tag = this.in.readInt();
        int type = this.in.readInt();
        int offset = this.in.readInt();
        int count = this.in.readInt();
        return new HeaderValue(tag, type, offset, count);
    }

    private byte[] readComplete(int size) throws IOException {
        byte[] result = new byte[size];
        this.in.readFully(result);
        return result;
    }

    private void skipFully(int count) throws IOException {
        if (count > 0) {
            this.in.readFully(DUMMY, 0, count);
        }
    }

    @Override
    public void reset() throws IOException {
        this.ensureInit();
        this.payloadStream.reset();
    }

    @Override
    public int read() throws IOException {
        this.ensureInit();
        return this.payloadStream.read();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureInit();
        return this.payloadStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.ensureInit();
        return this.payloadStream.available();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureInit();
        return this.payloadStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.payloadStream.read(b, off, len);
    }
}

