/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.jaxb.BeanValidationHelper;
import org.eclipse.persistence.jaxb.Concurrent;
import org.eclipse.persistence.jaxb.Crate;
import org.eclipse.persistence.jaxb.ReflectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ValidationXMLReader
implements Callable<Void> {
    public static final String DEFAULT_PACKAGE_QNAME = "default-package";
    public static final String BEAN_QNAME = "bean";
    public static final String CONSTRAINT_MAPPING_QNAME = "constraint-mapping";
    public static final String CLASS_QNAME = "class";
    public static final String PACKAGE_SEPARATOR = ".";
    static final CountDownLatch latch = new CountDownLatch(1);
    private static final String VALIDATION_XML = "META-INF/validation.xml";
    private static final Logger LOGGER = Logger.getLogger(ValidationXMLReader.class.getName());
    private static volatile boolean firstTime = true;
    private static boolean didSomething = false;
    private static boolean jdkExecutor = false;
    private static boolean possibleResourceVisibilityFail = false;
    private final List<String> constraintsFiles;
    private SAXParser saxParser;
    private final DefaultHandler validationHandler;

    @Override
    public Void call() throws Exception {
        try {
            didSomething = true;
            try {
                this.parseValidationXML();
            }
            catch (IOException | URISyntaxException | SAXException e) {
                String msg = "Parsing of validation.xml failed. Exception: " + e.getMessage();
                LOGGER.warning(msg);
            }
            if (!this.constraintsFiles.isEmpty()) {
                this.parseConstraintFiles();
            }
        }
        finally {
            latch.countDown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void runAsynchronously() {
        if (!firstTime) return;
        Class<ValidationXMLReader> clazz = ValidationXMLReader.class;
        synchronized (ValidationXMLReader.class) {
            if (!firstTime) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            firstTime = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            ValidationXMLReader.runAsyncInternal();
            return;
        }
    }

    private static void runAsyncInternal() {
        ValidationXMLReader callable = ValidationXMLReader.getInstance();
        Crate.Tuple<ExecutorService, Boolean> crate = Concurrent.getManagedSingleThreadedExecutorService();
        jdkExecutor = crate.getPayload2() == false;
        ExecutorService executor = (ExecutorService)crate.getPayload1();
        executor.submit(callable);
        executor.shutdown();
    }

    static boolean runSynchronouslyForced() {
        firstTime = false;
        try {
            ValidationXMLReader.getInstance().call();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static ValidationXMLReader getInstance() {
        return new ValidationXMLReader();
    }

    private ValidationXMLReader() {
        block2: {
            this.constraintsFiles = new ArrayList<String>(2);
            this.validationHandler = new DefaultHandler(){
                private boolean constraintsFileElement = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase(ValidationXMLReader.CONSTRAINT_MAPPING_QNAME)) {
                        this.constraintsFileElement = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.constraintsFileElement) {
                        ValidationXMLReader.this.constraintsFiles.add(new String(ch, start, length));
                        this.constraintsFileElement = false;
                    }
                }
            };
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                this.saxParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException | SAXException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block2;
                String msg = "ValidationXMLReader initialization failed. Exception: " + e.getMessage();
                LOGGER.info(msg);
            }
        }
    }

    static boolean asyncAttemptFailed() {
        return !didSomething || possibleResourceVisibilityFail && Thread.currentThread().getContextClassLoader().getResource(VALIDATION_XML) != null;
    }

    private void parseConstraintFiles() {
        DefaultHandler referencedFileHandler = new DefaultHandler(){
            private boolean defaultPackageElement = false;
            private String defaultPackage = "";

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase(ValidationXMLReader.DEFAULT_PACKAGE_QNAME)) {
                    this.defaultPackageElement = true;
                } else if (qName.equalsIgnoreCase(ValidationXMLReader.BEAN_QNAME)) {
                    String className = String.valueOf(this.defaultPackage) + ValidationXMLReader.PACKAGE_SEPARATOR + attributes.getValue(ValidationXMLReader.CLASS_QNAME);
                    if (LOGGER.isLoggable(Level.INFO)) {
                        String msg = "Detected external constraints on class " + className;
                        LOGGER.info(msg);
                    }
                    try {
                        Class<?> clazz = ReflectionUtils.forName(className);
                        BeanValidationHelper.BEAN_VALIDATION_HELPER.putConstrainedClass(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        String errMsg = "Loading found class failed. Exception: " + e.getMessage();
                        LOGGER.warning(errMsg);
                    }
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.defaultPackageElement) {
                    this.defaultPackage = new String(ch, start, length);
                    this.defaultPackageElement = false;
                }
            }
        };
        for (String file : this.constraintsFiles) {
            this.parseConstraintFile(file, referencedFileHandler);
        }
    }

    private void parseValidationXML() throws SAXException, IOException, URISyntaxException {
        URL validationXml = Thread.currentThread().getContextClassLoader().getResource(VALIDATION_XML);
        if (validationXml != null) {
            this.saxParser.parse(new File(validationXml.toURI()), this.validationHandler);
        } else if (jdkExecutor) {
            possibleResourceVisibilityFail = true;
        }
    }

    private void parseConstraintFile(String constraintsFile, DefaultHandler referencedFileHandler) {
        URL constraintsXml = Thread.currentThread().getContextClassLoader().getResource(constraintsFile);
        try {
            this.saxParser.parse(new File(constraintsXml.toURI()), referencedFileHandler);
        }
        catch (IOException | NullPointerException | URISyntaxException | SAXException e) {
            String msg = "Loading of custom constraints file: " + constraintsFile + "failed. Exception: " + e.getMessage();
            LOGGER.warning(msg);
        }
    }
}

