/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.IntegerCastFunction;

public class UnsignedLongCast
extends IntegerCastFunction {
    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.UNSIGNED_LONG;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidUnsignedShort((String)lexicalValue);
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, BigInteger integerValue) throws ArithmeticException {
        if (integerValue.compareTo(BigInteger.ZERO) >= 0) {
            return Optional.of(vf.createLiteral(String.valueOf(integerValue.longValueExact()), this.getXsdDatatype()));
        }
        return Optional.empty();
    }
}

