/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public class QueryJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;

    public QueryJoinOptimizer() {
        this(new EvaluationStatistics());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new JoinVisitor());
    }

    protected class JoinVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        Set<String> boundVars = new HashSet<String>();

        protected JoinVisitor() {
        }

        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit((QueryModelVisitor)this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void meet(Join node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs((TupleExpr)node, new ArrayList());
                ArrayList<TupleExpr> orderedJoinArgs = new ArrayList<TupleExpr>(joinArgs.size());
                ArrayList<Object> priorityArgs = new ArrayList<Object>(joinArgs.size());
                List<TupleExpr> orderedSubselects = this.reorderSubselects(this.getSubSelects(joinArgs));
                joinArgs.removeAll(orderedSubselects);
                priorityArgs.addAll(orderedSubselects);
                List<Extension> orderedExtensions = this.getExtensions(joinArgs);
                joinArgs.removeAll(orderedExtensions);
                priorityArgs.addAll(orderedExtensions);
                if (joinArgs.size() > 0) {
                    HashMap<TupleExpr, Double> cardinalityMap = new HashMap<TupleExpr, Double>();
                    HashMap<TupleExpr, List<Var>> varsMap = new HashMap<TupleExpr, List<Var>>();
                    for (TupleExpr tupleExpr : joinArgs) {
                        cardinalityMap.put(tupleExpr, QueryJoinOptimizer.this.statistics.getCardinality(tupleExpr));
                        if (tupleExpr instanceof ZeroLengthPath) {
                            varsMap.put(tupleExpr, ((ZeroLengthPath)tupleExpr).getVarList());
                            continue;
                        }
                        varsMap.put(tupleExpr, this.getStatementPatternVars(tupleExpr));
                    }
                    HashMap<Var, Integer> varFreqMap = new HashMap<Var, Integer>();
                    for (List varList : varsMap.values()) {
                        this.getVarFreqMap(varList, varFreqMap);
                    }
                    while (!joinArgs.isEmpty()) {
                        TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, cardinalityMap, varsMap, varFreqMap, this.boundVars);
                        joinArgs.remove(tupleExpr);
                        orderedJoinArgs.add(tupleExpr);
                        tupleExpr.visit((QueryModelVisitor)this);
                        this.boundVars.addAll(tupleExpr.getBindingNames());
                    }
                }
                TupleExpr priorityJoins = null;
                if (priorityArgs.size() > 0) {
                    priorityJoins = (TupleExpr)priorityArgs.get(0);
                    for (int i = 1; i < priorityArgs.size(); ++i) {
                        priorityJoins = new Join(priorityJoins, (TupleExpr)priorityArgs.get(i));
                    }
                }
                if (orderedJoinArgs.size() > 0) {
                    int i = orderedJoinArgs.size() - 1;
                    TupleExpr replacement = (TupleExpr)orderedJoinArgs.get(i);
                    --i;
                    while (i >= 0) {
                        replacement = new Join((TupleExpr)orderedJoinArgs.get(i), replacement);
                        --i;
                    }
                    if (priorityJoins != null) {
                        replacement = new Join(priorityJoins, replacement);
                    }
                    node.replaceWith((QueryModelNode)replacement);
                } else {
                    node.replaceWith((QueryModelNode)priorityJoins);
                }
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected List<Var> getStatementPatternVars(TupleExpr tupleExpr) {
            List stPatterns = StatementPatternCollector.process((QueryModelNode)tupleExpr);
            ArrayList<Var> varList = new ArrayList<Var>(stPatterns.size() * 4);
            for (StatementPattern sp : stPatterns) {
                sp.getVars(varList);
            }
            return varList;
        }

        protected <M extends Map<Var, Integer>> M getVarFreqMap(List<Var> varList, M varFreqMap) {
            for (Var var : varList) {
                Integer freq = varFreqMap.get(var);
                freq = freq == null ? 1 : freq + 1;
                varFreqMap.put((Var)var, (Integer)freq);
            }
            return varFreqMap;
        }

        protected List<Extension> getExtensions(List<TupleExpr> expressions) {
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (TupleExpr expr : expressions) {
                if (!(expr instanceof Extension)) continue;
                extensions.add((Extension)expr);
            }
            return extensions;
        }

        protected List<TupleExpr> getSubSelects(List<TupleExpr> expressions) {
            ArrayList<TupleExpr> subselects = new ArrayList<TupleExpr>();
            for (TupleExpr expr : expressions) {
                if (!TupleExprs.containsSubquery((TupleExpr)expr)) continue;
                subselects.add(expr);
            }
            return subselects;
        }

        protected List<TupleExpr> reorderSubselects(List<TupleExpr> subselects) {
            if (subselects.size() == 1) {
                return subselects;
            }
            ArrayList<TupleExpr> result = new ArrayList<TupleExpr>();
            if (subselects == null || subselects.size() == 0) {
                return result;
            }
            HashMap joinSizes = new HashMap();
            int maxJoinSize = 0;
            for (int i = 0; i < subselects.size(); ++i) {
                TupleExpr firstArg = subselects.get(i);
                for (int j = i + 1; j < subselects.size(); ++j) {
                    TupleExpr secondArg = subselects.get(j);
                    Set names = firstArg.getBindingNames();
                    names.retainAll(secondArg.getBindingNames());
                    int joinSize = names.size();
                    if (joinSize > maxJoinSize) {
                        maxJoinSize = joinSize;
                    }
                    List l = null;
                    l = joinSizes.containsKey(joinSize) ? (List)joinSizes.get(joinSize) : new ArrayList();
                    TupleExpr[] tupleTuple = new TupleExpr[]{firstArg, secondArg};
                    l.add(tupleTuple);
                    joinSizes.put(joinSize, l);
                }
            }
            TupleExpr[] maxUnionTupleTuple = null;
            int currentUnionSize = -1;
            List list = (List)joinSizes.get(maxJoinSize);
            for (TupleExpr[] tupleTuple : list) {
                Set names = tupleTuple[0].getBindingNames();
                names.addAll(tupleTuple[1].getBindingNames());
                int unionSize = names.size();
                if (unionSize <= currentUnionSize) continue;
                maxUnionTupleTuple = tupleTuple;
                currentUnionSize = unionSize;
            }
            result.add((TupleExpr)maxUnionTupleTuple[0]);
            result.add((TupleExpr)maxUnionTupleTuple[1]);
            while (result.size() < subselects.size()) {
                result.add(this.getNextSubselect(result, subselects));
            }
            return result;
        }

        private TupleExpr getNextSubselect(List<TupleExpr> currentList, List<TupleExpr> joinArgs) {
            HashSet currentListNames = new HashSet();
            for (TupleExpr expr : currentList) {
                currentListNames.addAll(expr.getBindingNames());
            }
            TupleExpr selected = null;
            int currentUnionSize = -1;
            int currentJoinSize = -1;
            for (TupleExpr candidate : joinArgs) {
                if (currentList.contains(candidate)) continue;
                Set names = candidate.getBindingNames();
                names.retainAll(currentListNames);
                int joinSize = names.size();
                names = candidate.getBindingNames();
                names.addAll(currentListNames);
                int unionSize = names.size();
                if (joinSize > currentJoinSize) {
                    selected = candidate;
                    currentJoinSize = joinSize;
                    currentUnionSize = unionSize;
                    continue;
                }
                if (joinSize != currentJoinSize || unionSize <= currentUnionSize) continue;
                selected = candidate;
                currentJoinSize = joinSize;
                currentUnionSize = unionSize;
            }
            return selected;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            TupleExpr result = null;
            if (expressions.size() > 1) {
                double lowestCardinality = Double.POSITIVE_INFINITY;
                for (TupleExpr tupleExpr : expressions) {
                    double cardinality = this.getTupleExprCardinality(tupleExpr, cardinalityMap, varsMap, varFreqMap, boundVars);
                    if (!(cardinality < lowestCardinality) && result != null) continue;
                    lowestCardinality = cardinality;
                    result = tupleExpr;
                }
            } else {
                result = expressions.get(0);
            }
            return result;
        }

        protected double getTupleExprCardinality(TupleExpr tupleExpr, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            double cardinality = cardinalityMap.get(tupleExpr);
            List<Var> vars = varsMap.get(tupleExpr);
            List<Var> unboundVars = this.getUnboundVars(vars);
            List<Var> constantVars = this.getConstantVars(vars);
            int nonConstantVarCount = vars.size() - constantVars.size();
            if (nonConstantVarCount > 0) {
                double exp = (double)unboundVars.size() / (double)nonConstantVarCount;
                cardinality = Math.pow(cardinality, exp);
            }
            if (unboundVars.isEmpty()) {
                if (nonConstantVarCount > 0) {
                    cardinality /= (double)nonConstantVarCount;
                }
            } else {
                int foreignVarFreq = this.getForeignVarFreq(unboundVars, varFreqMap);
                if (foreignVarFreq > 0) {
                    cardinality /= (double)(1 + foreignVarFreq);
                }
            }
            return cardinality;
        }

        protected List<Var> getConstantVars(Iterable<Var> vars) {
            ArrayList<Var> constantVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                constantVars.add(var);
            }
            return constantVars;
        }

        protected List<Var> getUnboundVars(Iterable<Var> vars) {
            ArrayList<Var> unboundVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (var.hasValue() || this.boundVars.contains(var.getName())) continue;
                unboundVars.add(var);
            }
            return unboundVars;
        }

        protected int getForeignVarFreq(List<Var> ownUnboundVars, Map<Var, Integer> varFreqMap) {
            int result = 0;
            HashMap ownFreqMap = this.getVarFreqMap(ownUnboundVars, new HashMap());
            for (Map.Entry entry : ownFreqMap.entrySet()) {
                Var var = (Var)entry.getKey();
                int ownFreq = (Integer)entry.getValue();
                result += varFreqMap.get(var) - ownFreq;
            }
            return result;
        }
    }
}

