/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SesameClient;
import org.eclipse.rdf4j.http.client.SesameClientDependent;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverImpl;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.federation.PrefixHashSet;
import org.eclipse.rdf4j.sail.federation.ReadOnlyConnection;
import org.eclipse.rdf4j.sail.federation.WritableConnection;
import org.eclipse.rdf4j.sail.federation.evaluation.FederationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Federation
implements Sail,
Executor,
FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SesameClientDependent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Federation.class);
    private final List<Repository> members = new ArrayList<Repository>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private PrefixHashSet localPropertySpace;
    private boolean distinct;
    private boolean readOnly;
    private File dataDir;
    private FederatedServiceResolver serviceResolver;
    private FederatedServiceResolverImpl dependentServiceResolver;

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public boolean isWritable() throws SailException {
        return !this.isReadOnly();
    }

    public void addMember(Repository member) {
        this.members.add(member);
    }

    public PrefixHashSet getLocalPropertySpace() {
        return this.localPropertySpace;
    }

    public void setLocalPropertySpace(Collection<String> localPropertySpace) {
        this.localPropertySpace = localPropertySpace.isEmpty() ? null : new PrefixHashSet(localPropertySpace);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new FederatedServiceResolverImpl();
            }
            this.serviceResolver = this.dependentServiceResolver;
            return this.serviceResolver;
        }
        return this.serviceResolver;
    }

    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        for (Repository member : this.members) {
            if (!(member instanceof FederatedServiceResolverClient)) continue;
            ((FederatedServiceResolverClient)member).setFederatedServiceResolver(resolver);
        }
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        for (Repository member : this.members) {
            if (!(member instanceof RepositoryResolverClient)) continue;
            ((RepositoryResolverClient)member).setRepositoryResolver(resolver);
        }
    }

    public SesameClient getSesameClient() {
        for (Repository member : this.members) {
            SesameClient client;
            if (!(member instanceof SesameClientDependent) || (client = ((SesameClientDependent)member).getSesameClient()) == null) continue;
            return client;
        }
        return null;
    }

    public void setSesameClient(SesameClient client) {
        for (Repository member : this.members) {
            if (!(member instanceof SesameClientDependent)) continue;
            ((SesameClientDependent)member).setSesameClient(client);
        }
    }

    public HttpClient getHttpClient() {
        for (Repository member : this.members) {
            HttpClient client;
            if (!(member instanceof HttpClientDependent) || (client = ((HttpClientDependent)member).getHttpClient()) == null) continue;
            return client;
        }
        return null;
    }

    public void setHttpClient(HttpClient client) {
        for (Repository member : this.members) {
            if (!(member instanceof HttpClientDependent)) continue;
            ((HttpClientDependent)member).setHttpClient(client);
        }
    }

    public void initialize() throws SailException {
        for (Repository member : this.members) {
            try {
                member.initialize();
            }
            catch (RepositoryException e) {
                throw new SailException((Throwable)e);
            }
        }
    }

    public void shutDown() throws SailException {
        for (Repository member : this.members) {
            try {
                member.shutDown();
            }
            catch (RepositoryException e) {
                throw new SailException((Throwable)e);
            }
        }
        this.executor.shutdown();
        if (this.dependentServiceResolver != null) {
            this.dependentServiceResolver.shutDown();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public SailConnection getConnection() throws SailException {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>(this.members.size());
        try {
            for (Repository member : this.members) {
                connections.add(member.getConnection());
            }
            return this.readOnly ? new ReadOnlyConnection(this, connections) : new WritableConnection(this, connections);
        }
        catch (RepositoryException e) {
            this.closeAll(connections);
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.closeAll(connections);
            throw e;
        }
    }

    protected EvaluationStrategy createEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver resolver) {
        return new FederationStrategy(this, tripleSource, dataset, this.getFederatedServiceResolver());
    }

    private void closeAll(Iterable<RepositoryConnection> connections) {
        for (RepositoryConnection con : connections) {
            try {
                con.close();
            }
            catch (RepositoryException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Arrays.asList(IsolationLevels.NONE);
    }

    public IsolationLevel getDefaultIsolationLevel() {
        return IsolationLevels.NONE;
    }
}

