/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.algebra;

import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.sail.federation.evaluation.InsertBindingSetCursor;

public class OwnedTupleExpr
extends UnaryTupleOperator {
    private final RepositoryConnection owner;
    private TupleQuery query;
    private Map<String, String> variables;

    public OwnedTupleExpr(RepositoryConnection owner, TupleExpr arg) {
        super(arg);
        this.owner = owner;
    }

    public RepositoryConnection getOwner() {
        return this.owner;
    }

    public void prepare(QueryLanguage queryLn, String qry, Map<String, String> bindings) throws RepositoryException, MalformedQueryException {
        assert (this.query == null);
        this.query = this.owner.prepareTupleQuery(queryLn, qry);
        this.variables = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Dataset dataset, BindingSet bindings) throws QueryEvaluationException {
        InsertBindingSetCursor rval = null;
        if (this.query != null) {
            try {
                TupleQuery tupleQuery = this.query;
                synchronized (tupleQuery) {
                    for (String name : this.variables.keySet()) {
                        if (bindings.hasBinding(name)) {
                            Value value = bindings.getValue(name);
                            this.query.setBinding(this.variables.get(name), value);
                            continue;
                        }
                        this.query.removeBinding(this.variables.get(name));
                    }
                    this.query.setDataset(dataset);
                    TupleQueryResult result = this.query.evaluate();
                    rval = new InsertBindingSetCursor((CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return rval;
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther((QueryModelNode)this);
    }

    public String getSignature() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.owner.toString();
    }
}

