/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.evaluation;

import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.sail.federation.evaluation.AlternativeCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.FilterCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.QueueCursor;

public class ParallelLeftJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private static final String LF_TAB = "\n\t";
    private final EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public ParallelLeftJoinCursor(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
    }

    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            ValueExpr condition = this.join.getCondition();
            while (!this.closed && this.leftIter.hasNext()) {
                BindingSet leftBindings = (BindingSet)this.leftIter.next();
                this.addToRightQueue(condition, leftBindings);
            }
        }
        catch (RuntimeException e) {
            this.rightQueue.toss(e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    private void addToRightQueue(ValueExpr condition, BindingSet leftBindings) throws QueryEvaluationException, InterruptedException {
        Object result = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
        if (condition != null) {
            result = new FilterCursor((CloseableIteration<BindingSet, QueryEvaluationException>)result, condition, this.scopeBindingNames, this.strategy);
        }
        SingletonIteration alt = new SingletonIteration((Object)leftBindings);
        this.rightQueue.put((CloseableIteration<BindingSet, QueryEvaluationException>)new AlternativeCursor(result, alt));
    }

    public synchronized BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                result = (BindingSet)this.rightIter.next();
                break;
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return result;
    }

    public synchronized void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.evaluationThread != null) {
            this.evaluationThread.interrupt();
        }
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        this.leftIter.close();
    }

    public String toString() {
        String left = this.leftIter.toString().replace("\n", LF_TAB);
        String right = null == this.rightIter ? this.join.getRightArg().toString() : this.rightIter.toString();
        ValueExpr condition = this.join.getCondition();
        String filter = null == condition ? "" : condition.toString().trim().replace("\n", LF_TAB);
        return "ParallelLeftJoin " + filter + LF_TAB + left + LF_TAB + right.replace("\n", LF_TAB);
    }
}

