/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class EmptyPatternOptimizer
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private final Collection<? extends RepositoryConnection> members;

    public EmptyPatternOptimizer(Collection<? extends RepositoryConnection> members) {
        this.members = members;
    }

    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        try {
            query.visit((QueryModelVisitor)this);
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void meet(StatementPattern node) throws RepositoryException {
        Resource subj = (Resource)node.getSubjectVar().getValue();
        IRI pred = (IRI)node.getPredicateVar().getValue();
        Value obj = node.getObjectVar().getValue();
        Resource[] ctx = this.getContexts(node.getContextVar());
        for (RepositoryConnection repositoryConnection : this.members) {
            if (!repositoryConnection.hasStatement(subj, pred, obj, true, ctx)) continue;
            return;
        }
        node.replaceWith((QueryModelNode)new EmptySet());
    }

    private Resource[] getContexts(Var var) {
        Resource[] resourceArray;
        if (var == null || !var.hasValue()) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = (Resource)var.getValue();
        }
        return resourceArray;
    }
}

