/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.algebra.OwnedTupleExpr;

public class PrepareOwnedTupleExpr
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private static final String END_BLOCK = "}\n";
    private OwnedTupleExpr owner;
    private String pattern;
    private TupleExpr patternNode;
    private Map<String, String> variables = new HashMap<String, String>();
    private boolean reduce;
    private boolean reduced;
    private boolean distinct;

    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        try {
            query.visit((QueryModelVisitor)this);
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void meetOther(QueryModelNode node) throws RepositoryException {
        if (node instanceof OwnedTupleExpr) {
            this.meetOwnedTupleExpr((OwnedTupleExpr)node);
        } else if (node instanceof NaryJoin) {
            this.meetMultiJoin((NaryJoin)node);
        } else {
            super.meetOther(node);
        }
    }

    private void meetOwnedTupleExpr(OwnedTupleExpr node) throws RepositoryException {
        OwnedTupleExpr before = this.owner;
        try {
            this.owner = node;
            this.meetNode((QueryModelNode)node);
            this.owner = null;
        }
        finally {
            this.owner = before;
        }
    }

    protected void meetNode(QueryModelNode node) throws RepositoryException {
        super.meetNode(node);
        if (this.owner != null && this.patternNode != null && !(this.patternNode instanceof StatementPattern)) {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT");
            if (this.distinct) {
                builder.append(" DISTINCT");
            } else if (this.reduced || this.reduce) {
                builder.append(" REDUCED");
            }
            boolean mapping = false;
            HashMap<String, String> bindings = new HashMap<String, String>();
            ProjectionElemList list = new ProjectionElemList();
            for (String name : this.patternNode.getBindingNames()) {
                mapping = this.addBindingNames(builder, mapping, bindings, list, name);
            }
            builder.append("\nWHERE {\n").append(this.pattern).append("}");
            this.meetNodeLocal(builder, mapping, bindings, list);
        }
        this.reduced = false;
        this.distinct = false;
        this.pattern = null;
        this.patternNode = null;
    }

    private void meetNodeLocal(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list) throws RepositoryException, AssertionError {
        try {
            QueryModelNode parent = this.patternNode.getParentNode();
            if (parent instanceof OwnedTupleExpr) {
                OwnedTupleExpr owned = (OwnedTupleExpr)parent;
                this.meetNodeLocalParentOwned(builder, mapping, bindings, list, owned);
            } else {
                this.meetNodeLocalParentNotOwned(builder, mapping, bindings, list);
            }
        }
        catch (MalformedQueryException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void meetNodeLocalParentOwned(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list, OwnedTupleExpr owned) throws RepositoryException, MalformedQueryException {
        owned.prepare(QueryLanguage.SPARQL, builder.toString(), bindings);
        if (mapping) {
            Projection proj = new Projection((TupleExpr)owned.clone(), list);
            owned.replaceWith((QueryModelNode)proj);
        }
    }

    private void meetNodeLocalParentNotOwned(StringBuilder builder, boolean mapping, Map<String, String> bindings, ProjectionElemList list) throws RepositoryException, MalformedQueryException {
        OwnedTupleExpr owned = new OwnedTupleExpr(this.owner.getOwner(), this.patternNode.clone());
        owned.prepare(QueryLanguage.SPARQL, builder.toString(), bindings);
        if (mapping) {
            Projection proj = new Projection((TupleExpr)owned, list);
            this.patternNode.replaceWith((QueryModelNode)proj);
        } else {
            this.patternNode.replaceWith((QueryModelNode)owned);
        }
    }

    private boolean addBindingNames(StringBuilder builder, boolean alreadyMapping, Map<String, String> bindings, ProjectionElemList list, String name) {
        boolean mapping = alreadyMapping;
        if (this.variables.containsKey(name)) {
            String var = this.variables.get(name);
            builder.append(" ?").append(var);
            bindings.put(name, var);
            list.addElement(new ProjectionElem(var, name));
            if (!name.equals(var)) {
                mapping = true;
            }
        }
        return mapping;
    }

    public void meet(Distinct node) throws RepositoryException {
        boolean before = this.reduce;
        try {
            this.reduce = true;
            node.getArg().visit((QueryModelVisitor)this);
        }
        finally {
            this.reduce = before;
        }
        if (this.patternNode == null) {
            return;
        }
        this.distinct = true;
        this.patternNode = node;
    }

    public void meet(Reduced node) throws RepositoryException {
        boolean before = this.reduce;
        try {
            this.reduce = true;
            node.getArg().visit((QueryModelVisitor)this);
        }
        finally {
            this.reduce = before;
        }
        if (this.patternNode == null) {
            return;
        }
        this.reduced = true;
        this.patternNode = node;
    }

    public void meet(Projection node) throws RepositoryException {
        TupleExpr arg = node.getArg();
        if (arg instanceof StatementPattern && arg.getBindingNames().equals(node.getBindingNames())) {
            this.meetNode((QueryModelNode)node);
        } else {
            arg.visit((QueryModelVisitor)this);
            if (this.patternNode == null) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (ProjectionElem e : node.getProjectionElemList().getElements()) {
                String source = this.variables.get(e.getSourceName());
                if (source == null) {
                    source = this.safe(e.getSourceName());
                }
                map.put(e.getTargetName(), source);
            }
            this.variables = map;
            this.patternNode = node;
        }
    }

    public void meet(LeftJoin node) throws RepositoryException {
        if (node.getCondition() == null) {
            HashMap<String, String> vars = new HashMap<String, String>();
            StringBuilder builder = new StringBuilder();
            node.getLeftArg().visit((QueryModelVisitor)this);
            if (this.patternNode != null) {
                builder.append(this.pattern);
                vars.putAll(this.variables);
                node.getRightArg().visit((QueryModelVisitor)this);
                if (this.patternNode != null) {
                    builder.append("OPTIONAL {").append(this.pattern).append(END_BLOCK);
                    vars.putAll(this.variables);
                    this.variables = vars;
                    this.pattern = builder.toString();
                    this.patternNode = node;
                }
            }
        } else {
            super.meet(node);
        }
    }

    public void meetMultiJoin(NaryJoin node) throws RepositoryException {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        for (TupleExpr arg : node.getArgs()) {
            arg.visit((QueryModelVisitor)this);
            if (this.patternNode == null && this.owner != null) {
                return;
            }
            if (this.patternNode == null) {
                builder = null;
                continue;
            }
            if (builder == null) continue;
            builder.append("{").append(this.pattern).append(END_BLOCK);
            vars.putAll(this.variables);
        }
        if (builder != null) {
            this.variables = vars;
            this.pattern = builder.toString();
            this.patternNode = node;
        }
    }

    public void meet(Join node) throws RepositoryException {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        node.getLeftArg().visit((QueryModelVisitor)this);
        if (this.patternNode != null) {
            builder.append("{").append(this.pattern).append(END_BLOCK);
            vars.putAll(this.variables);
            node.getRightArg().visit((QueryModelVisitor)this);
            if (this.patternNode != null) {
                builder.append("{").append(this.pattern).append(END_BLOCK);
                vars.putAll(this.variables);
                this.variables = vars;
                this.pattern = builder.toString();
                this.patternNode = node;
            }
        }
    }

    public void meet(StatementPattern node) throws RepositoryException {
        boolean ookay;
        StringBuilder builder = new StringBuilder();
        StatementPattern.Scope scope = node.getScope();
        Var subj = node.getSubjectVar();
        Var pred = node.getPredicateVar();
        Var obj = node.getObjectVar();
        Var ctx = node.getContextVar();
        boolean cokay = ctx == null && scope.equals((Object)StatementPattern.Scope.DEFAULT_CONTEXTS) || ctx != null && scope.equals((Object)StatementPattern.Scope.NAMED_CONTEXTS);
        boolean sokay = !subj.hasValue() || subj.isAnonymous() || subj.getValue() instanceof IRI;
        boolean bl = ookay = !obj.hasValue() || obj.isAnonymous() || obj.getValue() instanceof IRI || obj.getValue() instanceof Literal;
        if (cokay && sokay && ookay) {
            this.variables.clear();
            if (ctx != null) {
                builder.append("GRAPH ");
                this.appendVar(builder, ctx.getName());
                builder.append(" {\n");
            }
            this.appendVar(builder, subj);
            this.appendVar(builder, pred);
            this.appendVar(builder, obj);
            builder.append(" .");
            this.appendFilter(builder, subj);
            this.appendFilter(builder, pred);
            this.appendFilter(builder, obj);
            if (ctx != null) {
                if (ctx.hasValue()) {
                    builder.append("\nFILTER sameTerm(");
                    this.appendVar(builder, ctx.getName());
                    builder.append(", ");
                    this.writeValue(builder, ctx.getValue());
                    builder.append(")\n");
                }
                builder.append("}");
            }
            this.pattern = builder.toString();
            this.patternNode = node;
        } else {
            this.patternNode = null;
        }
    }

    private void appendVar(StringBuilder builder, Var var) {
        if (var.hasValue() && var.isAnonymous()) {
            Value value = var.getValue();
            this.writeValue(builder, value);
        } else {
            String varName = var.getName();
            this.appendVar(builder, varName);
        }
        builder.append(" ");
    }

    private void appendVar(StringBuilder builder, String varName) {
        builder.append("?");
        String name = this.safe(varName);
        builder.append(name);
        this.variables.put(varName, name);
    }

    private String safe(String name) {
        return name.replace('-', '_');
    }

    private void appendFilter(StringBuilder builder, Var var) {
        if (var.hasValue() && !var.isAnonymous()) {
            builder.append("\nFILTER sameTerm(");
            this.appendVar(builder, var.getName());
            builder.append(", ");
            this.writeValue(builder, var.getValue());
            builder.append(")");
        }
    }

    private void writeValue(StringBuilder builder, Value val) {
        if (val instanceof Resource) {
            this.writeResource(builder, (Resource)val);
        } else {
            this.writeLiteral(builder, (Literal)val);
        }
    }

    private void writeResource(StringBuilder builder, Resource res) {
        if (res instanceof IRI) {
            this.writeURI(builder, (IRI)res);
        } else {
            this.writeBNode(builder, (BNode)res);
        }
    }

    private void writeURI(StringBuilder builder, IRI uri) {
        builder.append("<");
        builder.append(TurtleUtil.encodeURIString((String)uri.stringValue()));
        builder.append(">");
    }

    private void writeBNode(StringBuilder builder, BNode bNode) {
        builder.append("_:");
        builder.append(bNode.stringValue());
    }

    private void writeLiteral(StringBuilder builder, Literal lit) {
        String label = lit.getLabel();
        if (label.indexOf(10) > 0 || label.indexOf(13) > 0 || label.indexOf(9) > 0) {
            builder.append("\"\"\"");
            builder.append(TurtleUtil.encodeLongString((String)label));
            builder.append("\"\"\"");
        } else {
            builder.append("\"");
            builder.append(TurtleUtil.encodeString((String)label));
            builder.append("\"");
        }
        IRI datatype = lit.getDatatype();
        if (Literals.isLanguageLiteral((Literal)lit)) {
            builder.append("@");
            builder.append((String)lit.getLanguage().get());
        } else {
            builder.append("^^");
            this.writeURI(builder, datatype);
        }
    }
}

