/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;

public class QueryModelPruner
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new TreeSanitizer());
    }

    protected class TreeSanitizer
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected TreeSanitizer() {
        }

        public void meetOther(QueryModelNode node) throws RuntimeException {
            if (node instanceof NaryJoin) {
                this.meetMultiJoin((NaryJoin)node);
            } else {
                super.meetOther(node);
            }
        }

        public void meetMultiJoin(NaryJoin join) {
            super.meetOther((QueryModelNode)join);
            for (TupleExpr arg : join.getArgs()) {
                if (arg instanceof SingletonSet) {
                    join.removeArg(arg);
                    continue;
                }
                if (!(arg instanceof EmptySet)) continue;
                join.replaceWith((QueryModelNode)new EmptySet());
                return;
            }
            if (join.getNumberOfArguments() == 1) {
                join.replaceWith((QueryModelNode)join.getArg(0));
            }
        }

        public void meet(Join join) {
            super.meet(join);
            TupleExpr leftArg = join.getLeftArg();
            TupleExpr rightArg = join.getRightArg();
            if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
                join.replaceWith((QueryModelNode)new EmptySet());
            } else if (leftArg instanceof SingletonSet) {
                join.replaceWith((QueryModelNode)rightArg);
            } else if (rightArg instanceof SingletonSet) {
                join.replaceWith((QueryModelNode)leftArg);
            }
        }

        public void meet(LeftJoin leftJoin) {
            super.meet(leftJoin);
            TupleExpr leftArg = leftJoin.getLeftArg();
            TupleExpr rightArg = leftJoin.getRightArg();
            ValueExpr condition = leftJoin.getCondition();
            if (leftArg instanceof EmptySet) {
                leftJoin.replaceWith((QueryModelNode)leftArg);
            } else if (rightArg instanceof EmptySet) {
                leftJoin.replaceWith((QueryModelNode)leftArg);
            } else if (rightArg instanceof SingletonSet) {
                leftJoin.replaceWith((QueryModelNode)leftArg);
            } else if (condition instanceof ValueConstant) {
                boolean conditionValue;
                try {
                    conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue((Value)((ValueConstant)condition).getValue());
                }
                catch (ValueExprEvaluationException e) {
                    conditionValue = false;
                }
                if (conditionValue) {
                    leftJoin.setCondition(null);
                } else {
                    leftJoin.replaceWith((QueryModelNode)leftArg);
                }
            }
        }

        public void meet(Union union) {
            super.meet(union);
            TupleExpr leftArg = union.getLeftArg();
            TupleExpr rightArg = union.getRightArg();
            if (leftArg instanceof EmptySet) {
                union.replaceWith((QueryModelNode)rightArg);
            } else if (rightArg instanceof EmptySet) {
                union.replaceWith((QueryModelNode)leftArg);
            } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
                union.replaceWith((QueryModelNode)leftArg);
            }
        }

        public void meet(Difference difference) {
            super.meet(difference);
            TupleExpr leftArg = difference.getLeftArg();
            TupleExpr rightArg = difference.getRightArg();
            if (leftArg instanceof EmptySet) {
                difference.replaceWith((QueryModelNode)leftArg);
            } else if (rightArg instanceof EmptySet) {
                difference.replaceWith((QueryModelNode)leftArg);
            } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
                difference.replaceWith((QueryModelNode)new EmptySet());
            }
        }

        public void meet(Intersection intersection) {
            super.meet(intersection);
            TupleExpr leftArg = intersection.getLeftArg();
            TupleExpr rightArg = intersection.getRightArg();
            if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
                intersection.replaceWith((QueryModelNode)leftArg);
            }
        }
    }
}

