/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.spin.QueryContext;

public class QueryContextIteration
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<? extends BindingSet, QueryEvaluationException> iter;
    private final QueryPreparer queryPreparer;

    public QueryContextIteration(CloseableIteration<? extends BindingSet, QueryEvaluationException> iter, QueryPreparer queryPreparer) {
        this.iter = iter;
        this.queryPreparer = queryPreparer;
    }

    public boolean hasNext() throws QueryEvaluationException {
        QueryContext qctx = QueryContext.begin((QueryPreparer)this.queryPreparer);
        try {
            boolean bl = this.iter.hasNext();
            return bl;
        }
        finally {
            qctx.end();
        }
    }

    public BindingSet next() throws QueryEvaluationException {
        QueryContext qctx = QueryContext.begin((QueryPreparer)this.queryPreparer);
        try {
            BindingSet bindingSet = (BindingSet)this.iter.next();
            return bindingSet;
        }
        finally {
            qctx.end();
        }
    }

    public void remove() throws QueryEvaluationException {
        QueryContext qctx = QueryContext.begin((QueryPreparer)this.queryPreparer);
        try {
            this.iter.remove();
        }
        finally {
            qctx.end();
        }
    }

    public void close() throws QueryEvaluationException {
        QueryContext qctx = QueryContext.begin((QueryPreparer)this.queryPreparer);
        try {
            this.iter.close();
        }
        finally {
            qctx.end();
        }
    }
}

