/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailConnectionQueryPreparer;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.SailTripleSource;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.AbstractForwardChainingInferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.util.RDFInferencerInserter;
import org.eclipse.rdf4j.sail.spin.ConstraintViolationException;
import org.eclipse.rdf4j.sail.spin.QueryContextIteration;
import org.eclipse.rdf4j.sail.spin.SpinFunctionInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinInferencing;
import org.eclipse.rdf4j.sail.spin.SpinMagicPropertyInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.eclipse.rdf4j.spin.ConstraintViolation;
import org.eclipse.rdf4j.spin.QueryContext;
import org.eclipse.rdf4j.spin.RuleProperty;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.TransientFunction;
import org.eclipse.rdf4j.spin.function.TransientTupleFunction;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class SpinSailConnection
extends AbstractForwardChainingInferencerConnection {
    private static final IRI EXECUTED = ValueFactoryImpl.getInstance().createIRI("http://www.openrdf.org/schema/spin#executed");
    private static final Marker constraintViolationMarker = MarkerFactory.getMarker((String)"ConstraintViolation");
    private static final String CONSTRAINT_VIOLATION_MESSAGE = "Constraint violation: {}: {} {} {}";
    private final SpinSail.EvaluationMode evaluationMode;
    private final boolean axiomClosureNeeded;
    private final FunctionRegistry functionRegistry;
    private final TupleFunctionRegistry tupleFunctionRegistry;
    private final AbstractFederatedServiceResolver serviceResolver;
    private final ValueFactory vf;
    private final TripleSource tripleSource;
    private final SpinParser parser;
    private List<IRI> orderedRuleProperties;
    private Map<IRI, RuleProperty> rulePropertyMap;
    private Map<Resource, Executions> ruleExecutions;
    private Map<IRI, Set<IRI>> classToSuperclassMap;
    private SailConnectionQueryPreparer queryPreparer;

    public SpinSailConnection(SpinSail sail, InferencerConnection con) {
        super((Sail)sail, con);
        this.evaluationMode = sail.getEvaluationMode();
        this.axiomClosureNeeded = sail.isAxiomClosureNeeded();
        this.functionRegistry = sail.getFunctionRegistry();
        this.tupleFunctionRegistry = sail.getTupleFunctionRegistry();
        this.vf = sail.getValueFactory();
        this.parser = sail.getSpinParser();
        this.tripleSource = new SailTripleSource((SailConnection)this.getWrappedConnection(), true, this.vf);
        this.queryPreparer = new SailConnectionQueryPreparer((SailConnection)this, true, this.tripleSource);
        if (this.evaluationMode == SpinSail.EvaluationMode.SERVICE) {
            FederatedServiceResolver resolver = sail.getFederatedServiceResolver();
            if (!(resolver instanceof AbstractFederatedServiceResolver)) {
                throw new IllegalArgumentException("SERVICE EvaluationMode requires a FederatedServiceResolver that is an instance of " + AbstractFederatedServiceResolver.class.getName());
            }
            this.serviceResolver = (AbstractFederatedServiceResolver)resolver;
        } else {
            this.serviceResolver = null;
        }
        con.addConnectionListener((SailConnectionListener)new SubclassListener());
        con.addConnectionListener((SailConnectionListener)new RulePropertyListener());
        con.addConnectionListener((SailConnectionListener)new InvalidationListener());
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.queryPreparer.setParserConfig(parserConfig);
    }

    public ParserConfig getParserConfig() {
        return this.queryPreparer.getParserConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter;
        QueryContext qctx = QueryContext.begin((QueryPreparer)this.queryPreparer);
        try {
            iter = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
        }
        finally {
            qctx.end();
        }
        return new QueryContextIteration(iter, this.queryPreparer);
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        new SpinFunctionInterpreter(this.parser, this.tripleSource, this.functionRegistry).optimize(tupleExpr, dataset, bindings);
        new SpinMagicPropertyInterpreter(this.parser, this.tripleSource, this.tupleFunctionRegistry, this.serviceResolver).optimize(tupleExpr, dataset, bindings);
        this.logger.trace("SPIN query model:\n{}", (Object)tupleExpr);
        if (this.evaluationMode == SpinSail.EvaluationMode.TRIPLE_SOURCE) {
            TupleFunctionEvaluationStrategy strategy = new TupleFunctionEvaluationStrategy((EvaluationStrategy)new EvaluationStrategyImpl((TripleSource)new SailTripleSource((SailConnection)this, includeInferred, this.vf), dataset, (FederatedServiceResolver)this.serviceResolver), this.vf, this.tupleFunctionRegistry);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer((EvaluationStrategy)strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(new EvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            try {
                return strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException((Throwable)e);
            }
        }
        return super.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    public void close() throws SailException {
        super.close();
    }

    private void initRuleProperties() throws RDF4JException {
        if (this.rulePropertyMap != null) {
            return;
        }
        this.rulePropertyMap = this.parser.parseRuleProperties(this.tripleSource);
        HashSet<IRI> remainingRules = new HashSet<IRI>(this.rulePropertyMap.keySet());
        ArrayList<IRI> reverseOrder = new ArrayList<IRI>(remainingRules.size());
        while (!remainingRules.isEmpty()) {
            Iterator ruleIter = remainingRules.iterator();
            while (ruleIter.hasNext()) {
                IRI rule = (IRI)ruleIter.next();
                boolean isTerminal = true;
                RuleProperty ruleProperty = this.rulePropertyMap.get(rule);
                if (ruleProperty != null) {
                    List nextRules = ruleProperty.getNextRules();
                    for (IRI nextRule : nextRules) {
                        if (nextRule.equals((Object)rule) || !remainingRules.contains(nextRule)) continue;
                        isTerminal = false;
                        break;
                    }
                }
                if (!isTerminal) continue;
                reverseOrder.add(rule);
                ruleIter.remove();
            }
        }
        this.orderedRuleProperties = Lists.reverse(reverseOrder);
    }

    private void resetRuleProperties() {
        this.orderedRuleProperties = null;
        this.rulePropertyMap = null;
    }

    private List<IRI> getRuleProperties() throws RDF4JException {
        this.initRuleProperties();
        return this.orderedRuleProperties;
    }

    private RuleProperty getRuleProperty(IRI ruleProp) throws RDF4JException {
        this.initRuleProperties();
        return this.rulePropertyMap.get(ruleProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClasses() throws RDF4JException {
        if (this.classToSuperclassMap != null) {
            return;
        }
        this.classToSuperclassMap = new HashMap<IRI, Set<IRI>>();
        try (CloseableIteration stmtIter = this.tripleSource.getStatements(null, RDFS.SUBCLASSOF, null, new Resource[0]);){
            while (stmtIter.hasNext()) {
                Statement stmt = (Statement)stmtIter.next();
                if (!(stmt.getSubject() instanceof IRI) || !(stmt.getObject() instanceof IRI)) continue;
                IRI cls = (IRI)stmt.getSubject();
                IRI superclass = (IRI)stmt.getObject();
                Set<IRI> superclasses = this.getSuperclasses((Resource)cls);
                if (superclasses == null) {
                    superclasses = new HashSet<IRI>(64);
                    this.classToSuperclassMap.put(cls, superclasses);
                }
                superclasses.add(superclass);
            }
        }
    }

    private void resetClasses() {
        this.classToSuperclassMap = null;
    }

    private Set<IRI> getSuperclasses(Resource cls) throws RDF4JException {
        this.initClasses();
        return this.classToSuperclassMap.get(cls);
    }

    protected Model createModel() {
        return new TreeModel();
    }

    protected void addAxiomStatements() throws SailException {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        if (this.axiomClosureNeeded) {
            this.loadAxiomStatements(parser, "/schema/spin-full.ttl");
        } else {
            this.loadAxiomStatements(parser, "/schema/sp.ttl");
            this.loadAxiomStatements(parser, "/schema/spin.ttl");
            this.loadAxiomStatements(parser, "/schema/spl.spin.ttl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAxiomStatements(RDFParser parser, String file) throws SailException {
        RDFInferencerInserter inserter = new RDFInferencerInserter((InferencerConnection)this, this.vf);
        parser.setRDFHandler((RDFHandler)inserter);
        URL url = ((Object)((Object)this)).getClass().getResource(file);
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            parser.parse((InputStream)in, url.toString());
        }
        catch (IOException ioe) {
            throw new SailException((Throwable)ioe);
        }
        catch (RDF4JException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void doInferencing() throws SailException {
        this.ruleExecutions = new HashMap<Resource, Executions>();
        super.doInferencing();
        this.ruleExecutions = null;
    }

    protected int applyRules(Model iteration) throws SailException {
        try {
            int nofInferred = 0;
            nofInferred += this.applyRulesInternal(iteration.subjects());
            return nofInferred += this.applyRulesInternal(Iterables.filter((Iterable)iteration.objects(), Resource.class));
        }
        catch (SailException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new SailException((Throwable)e);
        }
    }

    private int applyRulesInternal(Iterable<? extends Resource> resources) throws RDF4JException {
        int nofInferred = 0;
        for (Resource resource : resources) {
            Collection<IRI> remainingClasses = this.getClasses(resource);
            ArrayList<IRI> classHierarchy = new ArrayList<IRI>(remainingClasses.size());
            while (!remainingClasses.isEmpty()) {
                boolean hasCycle = true;
                Iterator<IRI> clsIter = remainingClasses.iterator();
                while (clsIter.hasNext()) {
                    IRI cls = clsIter.next();
                    Set<IRI> superclasses = this.getSuperclasses((Resource)cls);
                    boolean isTerminal = true;
                    if (superclasses != null) {
                        for (IRI superclass : remainingClasses) {
                            if (superclass.equals((Object)cls) || !superclasses.contains(superclass)) continue;
                            isTerminal = false;
                            break;
                        }
                    }
                    if (!isTerminal) continue;
                    classHierarchy.add(cls);
                    clsIter.remove();
                    hasCycle = false;
                }
                if (!hasCycle) continue;
                this.logger.warn("Cycle detected in class hierarchy: " + remainingClasses);
                classHierarchy.addAll(remainingClasses);
                break;
            }
            nofInferred += this.executeRules(resource, classHierarchy);
            this.flushUpdates();
            nofInferred += this.executeConstructors(resource, classHierarchy);
            this.flushUpdates();
            this.checkConstraints(resource, classHierarchy);
        }
        return nofInferred;
    }

    private Collection<IRI> getClasses(Resource subj) throws QueryEvaluationException {
        LinkedList<IRI> classes = new LinkedList<IRI>();
        CloseableIteration classIter = TripleSources.getObjectURIs((Resource)subj, (IRI)RDF.TYPE, (TripleSource)this.tripleSource);
        Iterations.addAll((Iteration)classIter, classes);
        return classes;
    }

    private int executeConstructors(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        int nofInferred = 0;
        HashSet<Resource> constructed = new HashSet<Resource>(classHierarchy.size());
        CloseableIteration classIter = TripleSources.getObjectResources((Resource)subj, (IRI)EXECUTED, (TripleSource)this.tripleSource);
        Iterations.addAll((Iteration)classIter, constructed);
        for (IRI cls : classHierarchy) {
            List<Resource> constructors = this.getConstructorsForClass(cls);
            for (Resource constructor : constructors) {
                if (!constructed.add(constructor)) continue;
                nofInferred += this.executeRule(subj, constructor);
                this.addInferredStatement(subj, EXECUTED, (Value)constructor, new Resource[0]);
            }
        }
        return nofInferred;
    }

    private List<Resource> getConstructorsForClass(IRI cls) throws RDF4JException {
        ArrayList<Resource> constructors = new ArrayList<Resource>(2);
        CloseableIteration constructorIter = TripleSources.getObjectResources((Resource)cls, (IRI)SPIN.CONSTRUCTOR_PROPERTY, (TripleSource)this.tripleSource);
        Iterations.addAll((Iteration)constructorIter, constructors);
        return constructors;
    }

    private int executeRules(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        int nofInferred = 0;
        List<IRI> ruleProps = this.getRuleProperties();
        for (IRI cls : classHierarchy) {
            Map<IRI, List<Resource>> classRulesByProperty = this.getRulesForClass(cls, ruleProps);
            if (classRulesByProperty.isEmpty()) continue;
            for (Map.Entry<IRI, List<Resource>> ruleEntry : classRulesByProperty.entrySet()) {
                RuleProperty ruleProperty = this.getRuleProperty(ruleEntry.getKey());
                int maxCount = ruleProperty.getMaxIterationCount();
                for (Resource rule : ruleEntry.getValue()) {
                    Executions executions = null;
                    if (maxCount != -1) {
                        executions = this.ruleExecutions.get(rule);
                        if (executions == null) {
                            executions = new Executions();
                            this.ruleExecutions.put(rule, executions);
                        }
                        if (executions.count >= maxCount) continue;
                    }
                    nofInferred += this.executeRule(subj, rule);
                    if (executions == null) continue;
                    ++executions.count;
                }
            }
        }
        return nofInferred;
    }

    private int executeRule(Resource subj, Resource rule) throws RDF4JException {
        return SpinInferencing.executeRule(subj, rule, this.queryPreparer, this.parser, (InferencerConnection)this);
    }

    private Map<IRI, List<Resource>> getRulesForClass(IRI cls, List<IRI> ruleProps) throws QueryEvaluationException {
        LinkedHashMap<IRI, List<Resource>> classRulesByProperty = new LinkedHashMap<IRI, List<Resource>>(ruleProps.size());
        for (IRI ruleProp : ruleProps) {
            ArrayList rules = new ArrayList(2);
            CloseableIteration ruleIter = TripleSources.getObjectResources((Resource)cls, (IRI)ruleProp, (TripleSource)this.tripleSource);
            Iterations.addAll((Iteration)ruleIter, rules);
            if (rules.isEmpty()) continue;
            if (rules.size() > 1) {
                final HashMap<Resource, String> comments = new HashMap<Resource, String>(rules.size());
                for (Resource rule : rules) {
                    String comment = this.getHighestComment(rule);
                    if (comment == null) continue;
                    comments.put(rule, comment);
                }
                Collections.sort(rules, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource rule1, Resource rule2) {
                        String comment1 = (String)comments.get(rule1);
                        String comment2 = (String)comments.get(rule2);
                        if (comment1 != null && comment2 != null) {
                            return comment1.compareTo(comment2);
                        }
                        if (comment1 != null && comment2 == null) {
                            return 1;
                        }
                        if (comment1 == null && comment2 != null) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
            classRulesByProperty.put(ruleProp, rules);
        }
        return classRulesByProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHighestComment(Resource subj) throws QueryEvaluationException {
        String comment = null;
        try (CloseableIteration iter = TripleSources.getObjectLiterals((Resource)subj, (IRI)RDFS.COMMENT, (TripleSource)this.tripleSource);){
            while (iter.hasNext()) {
                Literal l = (Literal)iter.next();
                String label = l.getLabel();
                if ((comment == null || label.compareTo(comment) <= 0) && comment != null) continue;
                comment = label;
            }
        }
        return comment;
    }

    private void checkConstraints(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        Map<IRI, List<Resource>> constraintsByClass = this.getConstraintsForSubject(subj, classHierarchy);
        for (Map.Entry<IRI, List<Resource>> clsEntry : constraintsByClass.entrySet()) {
            List<Resource> constraints = clsEntry.getValue();
            for (Resource constraint : constraints) {
                this.checkConstraint(subj, constraint);
            }
        }
    }

    private void checkConstraint(Resource subj, Resource constraint) throws RDF4JException {
        ConstraintViolation violation = SpinInferencing.checkConstraint(subj, constraint, this.queryPreparer, this.parser);
        if (violation != null) {
            this.handleConstraintViolation(violation);
        }
    }

    private void handleConstraintViolation(ConstraintViolation violation) throws ConstraintViolationException {
        switch (violation.getLevel()) {
            case INFO: {
                this.logger.info(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                break;
            }
            case WARNING: {
                this.logger.warn(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                break;
            }
            case ERROR: {
                this.logger.error(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                throw new ConstraintViolationException(violation);
            }
            case FATAL: {
                this.logger.error(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                throw new ConstraintViolationException(violation);
            }
        }
    }

    private Object[] getConstraintViolationLogMessageArgs(ConstraintViolation violation) {
        return new Object[]{violation.getMessage() != null ? violation.getMessage() : "No message", Strings.nullToEmpty((String)violation.getRoot()), Strings.nullToEmpty((String)violation.getPath()), Strings.nullToEmpty((String)violation.getValue())};
    }

    private Map<IRI, List<Resource>> getConstraintsForSubject(Resource subj, List<IRI> classHierarchy) throws QueryEvaluationException {
        LinkedHashMap<IRI, List<Resource>> constraintsByClass = new LinkedHashMap<IRI, List<Resource>>(classHierarchy.size());
        for (IRI cls : classHierarchy) {
            List<Resource> constraints = this.getConstraintsForClass((Resource)cls);
            if (constraints.isEmpty()) continue;
            constraintsByClass.put(cls, constraints);
        }
        return constraintsByClass;
    }

    private List<Resource> getConstraintsForClass(Resource cls) throws QueryEvaluationException {
        ArrayList<Resource> constraints = new ArrayList<Resource>(2);
        CloseableIteration constraintIter = TripleSources.getObjectResources((Resource)cls, (IRI)SPIN.CONSTRAINT_PROPERTY, (TripleSource)this.tripleSource);
        Iterations.addAll((Iteration)constraintIter, constraints);
        return constraints;
    }

    private static final class Executions {
        int count;

        private Executions() {
        }
    }

    private class InvalidationListener
    implements SailConnectionListener {
        private InvalidationListener() {
        }

        public void statementAdded(Statement st) {
            this.invalidate(st.getSubject());
        }

        public void statementRemoved(Statement st) {
            this.invalidate(st.getSubject());
        }

        private void invalidate(Resource subj) {
            if (subj instanceof IRI) {
                TupleFunction tupleFunc;
                SpinSailConnection.this.parser.reset(new IRI[]{(IRI)subj});
                String key = subj.stringValue();
                Function func = SpinSailConnection.this.functionRegistry.get((Object)key).orElse(null);
                if (func instanceof TransientFunction) {
                    SpinSailConnection.this.functionRegistry.remove((Object)func);
                }
                if ((tupleFunc = (TupleFunction)SpinSailConnection.this.tupleFunctionRegistry.get((Object)key).orElse(null)) instanceof TransientTupleFunction) {
                    SpinSailConnection.this.tupleFunctionRegistry.remove((Object)tupleFunc);
                }
            }
        }
    }

    private class RulePropertyListener
    implements SailConnectionListener {
        private RulePropertyListener() {
        }

        public void statementAdded(Statement st) {
            this.updateRuleProperties(st);
        }

        public void statementRemoved(Statement st) {
            this.updateRuleProperties(st);
        }

        private void updateRuleProperties(Statement st) {
            boolean changed = false;
            IRI pred = st.getPredicate();
            if (RDFS.SUBPROPERTYOF.equals((Object)pred) && SPIN.RULE_PROPERTY.equals((Object)st.getObject())) {
                changed = true;
            } else if (SPIN.NEXT_RULE_PROPERTY_PROPERTY.equals((Object)pred)) {
                changed = true;
            } else if (SPIN.RULE_PROPERTY_MAX_ITERATION_COUNT_PROPERTY.equals((Object)pred)) {
                changed = true;
            }
            if (changed) {
                SpinSailConnection.this.resetRuleProperties();
            }
        }
    }

    private class SubclassListener
    implements SailConnectionListener {
        private SubclassListener() {
        }

        public void statementAdded(Statement st) {
            if (RDFS.SUBCLASSOF.equals((Object)st.getPredicate()) && st.getObject() instanceof Resource) {
                SpinSailConnection.this.resetClasses();
            }
        }

        public void statementRemoved(Statement st) {
            if (RDFS.SUBCLASSOF.equals((Object)st.getPredicate())) {
                SpinSailConnection.this.resetClasses();
            }
        }
    }
}

