/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.client.ui.basic.chart;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.ChartChains;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.ChartEvent;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.ChartListener;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.IChart;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.IChartExtension;
import org.eclipse.scout.rt.chart.client.ui.basic.chart.IChartUIFacade;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.IChartConfig;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.IChartData;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.data.colorscheme.ColorScheme;
import org.eclipse.scout.rt.shared.data.colorscheme.IColorScheme;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

@ClassId(value="c31e0b6e-77bd-4752-ab1a-bda7560230b2")
public abstract class AbstractChart
extends AbstractWidget
implements IChart,
IExtensibleObject {
    private IChartUIFacade m_uiFacade;
    private final FastListenerList<ChartListener> m_listenerList = new FastListenerList();
    private final ObjectExtensions<AbstractChart, IChartExtension<? extends AbstractChart>> m_objectExtensions = new ObjectExtensions((Object)this, false);

    public AbstractChart() {
        this(true);
    }

    public AbstractChart(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = (IChartUIFacade)((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy((Object)new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.setConfig(this.getConfiguredConfig());
        this.setVisible(this.getConfiguredVisible());
    }

    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=10.0)
    protected IChartConfig getConfiguredConfig() {
        return ((IChartConfig)BEANS.get(IChartConfig.class)).withType("pie").withAutoColor(true).withColorScheme((IColorScheme)ColorScheme.DEFAULT).withTransparent(false).withMaxSegments(5).withClickable(false).withCheckable(false).withAnimated(true).withTooltipsEnabled(true).withLegendDisplay(true).withLegendClickable(false).withLegendPositionRight().withDatalabelsDisplay(false);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @Override
    public IChartUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IFastListenerList<ChartListener> chartListeners() {
        return this.m_listenerList;
    }

    protected final void interceptValueClick(BigDecimal xIndex, BigDecimal yIndex, Integer datasetIndex) {
        List<? extends IChartExtension<? extends AbstractChart>> extensions = this.getAllExtensions();
        ChartChains.ChartValueClickChain chain = new ChartChains.ChartValueClickChain(extensions);
        chain.execValueClick(xIndex, yIndex, datasetIndex);
    }

    public final List<? extends IChartExtension<? extends AbstractChart>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IChartExtension<? extends AbstractChart> createLocalExtension() {
        return new LocalChartExtension<AbstractChart>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> clazz) {
        return (T)this.m_objectExtensions.getExtension(clazz);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execValueClick(BigDecimal xIndex, BigDecimal yIndex, Integer datasetIndex) {
        ChartEvent event = new ChartEvent(this, 1);
        event.setXIndex(xIndex);
        event.setYIndex(yIndex);
        event.setDatasetIndex(datasetIndex);
        this.fireChartEventInternal(event);
    }

    protected void fireChartEventInternal(ChartEvent event) {
        this.chartListeners().list().forEach(listener -> listener.chartChanged(event));
    }

    @Override
    public void setData(IChartData data) {
        this.propertySupport.setProperty("data", (Object)data);
    }

    @Override
    public IChartData getData() {
        return (IChartData)this.propertySupport.getProperty("data");
    }

    @Override
    public void setConfig(IChartConfig config) {
        this.propertySupport.setProperty("config", (Object)(config != null ? config.copy() : null));
    }

    @Override
    public IChartConfig getConfig() {
        IChartConfig config = (IChartConfig)this.propertySupport.getProperty("config");
        return config != null ? config.copy() : null;
    }

    @Override
    public void resetConfig() {
        this.setConfig(this.getConfiguredConfig());
    }

    @Override
    public void extendConfig(IChartConfig config, boolean override) {
        IChartConfig conf = this.getConfig();
        if (conf != null) {
            conf.addProperties(config, override);
            this.setConfig(conf);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.propertySupport.setPropertyBool("visible", visible);
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    protected static class LocalChartExtension<CHART extends AbstractChart>
    extends AbstractExtension<CHART>
    implements IChartExtension<CHART> {
        public LocalChartExtension(CHART owner) {
            super(owner);
        }

        @Override
        public void execValueClick(ChartChains.ChartValueClickChain chain, BigDecimal xIndex, BigDecimal yIndex, Integer datasetIndex) {
            ((AbstractChart)this.getOwner()).execValueClick(xIndex, yIndex, datasetIndex);
        }
    }

    protected class P_UIFacade
    implements IChartUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireValueClickFromUI(BigDecimal xIndex, BigDecimal yIndex, Integer datasetIndex) {
            try {
                if (AbstractChart.this.isEnabled() && AbstractChart.this.isVisible()) {
                    AbstractChart.this.interceptValueClick(xIndex, yIndex, datasetIndex);
                }
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
    }
}

