/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.client.ui.basic.table.controls;

import org.eclipse.scout.rt.chart.client.ui.basic.table.controls.IChartColumnParam;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class ChartColumnParam
implements IChartColumnParam {
    private final IColumn<?> m_column;
    private final int m_columnModifier;

    public ChartColumnParam(int columnModifier) {
        this.m_column = null;
        this.m_columnModifier = columnModifier;
    }

    public ChartColumnParam(IColumn<?> column, int columnModifier) {
        this.m_column = column;
        this.m_columnModifier = columnModifier;
    }

    @Override
    public int getColumnIndex() {
        if (this.getColumn() != null) {
            return this.getColumn().getColumnIndex();
        }
        return -1;
    }

    @Override
    public int getColumnModifier() {
        return this.m_columnModifier;
    }

    @Override
    public IColumn getColumn() {
        return this.m_column;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_column == null ? 0 : this.m_column.hashCode());
        result = 31 * result + this.m_columnModifier;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartColumnParam other = (ChartColumnParam)obj;
        if (this.m_column == null ? other.m_column != null : !this.m_column.equals(other.m_column)) {
            return false;
        }
        return this.m_columnModifier == other.m_columnModifier;
    }
}

