/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.shared.data.basic.chart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.IChartConfig;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.shared.data.colorscheme.IColorScheme;

public class ChartConfig
implements IChartConfig {
    private static final long serialVersionUID = 1L;
    protected static final String DELIMITER = ".";
    protected static final String ESCAPED_DELIMITER = StringUtility.escapeRegexMetachars((CharSequence)".");
    protected static final String ARRAY_INDEX = ChartConfig.arrayIndex("\\d+", true);
    protected static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile(ARRAY_INDEX);
    protected static final Pattern LIST_EXPRESSION_PATTERN = Pattern.compile("\\w+" + ARRAY_INDEX);
    protected static final Pattern PROPERTY_PATTERN = Pattern.compile("\\w+(" + ARRAY_INDEX + ")?(" + ESCAPED_DELIMITER + "\\w+(" + ARRAY_INDEX + ")?)*");
    protected static final String TYPE = "type";
    protected static final String OPTIONS = "options";
    protected static final String AUTO_COLOR = ChartConfig.combine("options", "autoColor");
    protected static final String COLOR_SCHEME = ChartConfig.combine("options", "colorScheme");
    protected static final String TRANSPARENT = ChartConfig.combine("options", "transparent");
    protected static final String MAX_SEGMENTS = ChartConfig.combine("options", "maxSegments");
    protected static final String CLICKABLE = ChartConfig.combine("options", "clickable");
    protected static final String CHECKABLE = ChartConfig.combine("options", "checkable");
    protected static final String ANIMATION = ChartConfig.combine("options", "animation");
    protected static final String ANIMATION_DURATION = ChartConfig.combine(ANIMATION, "duration");
    protected static final String TOOLTIPS = ChartConfig.combine("options", "tooltips");
    protected static final String TOOLTIPS_ENABLED = ChartConfig.combine(TOOLTIPS, "enabled");
    protected static final String LEGEND = ChartConfig.combine("options", "legend");
    protected static final String LEGEND_DISPLAY = ChartConfig.combine(LEGEND, "display");
    protected static final String LEGEND_CLICKABLE = ChartConfig.combine(LEGEND, "clickable");
    protected static final String LEGEND_POSITION = ChartConfig.combine(LEGEND, "position");
    protected static final String ELEMENTS = ChartConfig.combine("options", "elements");
    protected static final String LINE = ChartConfig.combine(ELEMENTS, "line");
    protected static final String LINE_TENSION = ChartConfig.combine(LINE, "tension");
    protected static final String LINE_FILL = ChartConfig.combine(LINE, "fill");
    protected static final String SCALES = ChartConfig.combine("options", "scales");
    protected static final String SCALE_LABEL_BY_TYPE_MAP = ChartConfig.combine(SCALES, "scaleLabelByTypeMap");
    protected static final String X_LABEL_MAP = ChartConfig.combine(SCALES, "xLabelMap");
    protected static final String Y_LABEL_MAP = ChartConfig.combine(SCALES, "yLabelMap");
    protected static final String X_AXES = ChartConfig.combine(SCALES, "xAxes");
    protected static final String Y_AXES = ChartConfig.combine(SCALES, "yAxes");
    protected static final String STACKED = "stacked";
    protected static final String SCALE_LABEL = "scaleLabel";
    protected static final String SCALE_LABEL_DISPLAY = ChartConfig.combine("scaleLabel", "display");
    protected static final String SCALE_LABEL_LABEL = ChartConfig.combine("scaleLabel", "labelString");
    protected static final String PLUGINS = ChartConfig.combine("options", "plugins");
    protected static final String DATALABELS = ChartConfig.combine(PLUGINS, "datalabels");
    protected static final String DATALABELS_DISPLAY = ChartConfig.combine(DATALABELS, "display");
    private final Map<String, Object> m_properties = new HashMap<String, Object>();

    protected static String combine(String ... elements) {
        return StringUtility.join((String)DELIMITER, (String[])elements);
    }

    protected static String arrayIndex(int index) {
        return ChartConfig.arrayIndex(String.valueOf(index));
    }

    protected static String arrayIndex(String index) {
        return ChartConfig.arrayIndex(index, false);
    }

    protected static String arrayIndex(String index, boolean regex) {
        return StringUtility.box((String)(regex ? StringUtility.escapeRegexMetachars((CharSequence)"[") : "["), (String)index, (String)(regex ? StringUtility.escapeRegexMetachars((CharSequence)"]") : "]"));
    }

    @Override
    public ChartConfig copy() {
        ChartConfig chartConfig = (ChartConfig)BEANS.get(ChartConfig.class);
        chartConfig.m_properties.putAll(this.m_properties);
        return chartConfig;
    }

    @Override
    public IChartConfig withProperty(String name, Object value) {
        this.modifyProperties(ModifyMode.PUT, name, value);
        return this;
    }

    @Override
    public IChartConfig removeProperty(String name) {
        this.modifyProperties(ModifyMode.REMOVE, name, null);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this.modifyProperties(ModifyMode.GET, name, null);
    }

    protected IChartConfig withArrayProperty(String array, int index, String name, Object value) {
        return this.withProperty(ChartConfig.combine(String.valueOf(array) + ChartConfig.arrayIndex(index), name), value);
    }

    protected IChartConfig removeArrayProperty(String array, int index, String name) {
        return this.removeProperty(ChartConfig.combine(String.valueOf(array) + ChartConfig.arrayIndex(index), name));
    }

    protected Object getArrayProperty(String array, int index, String name) {
        return this.getProperty(ChartConfig.combine(String.valueOf(array) + ChartConfig.arrayIndex(index), name));
    }

    protected Object modifyProperties(ModifyMode modifyMode, String name, Object value) {
        if (modifyMode == null || !modifyMode.validate(name, value)) {
            throw new IllegalArgumentException("The given ModifyMode is null or validating it failed.");
        }
        ArrayList namesRec = CollectionUtility.arrayList((Object[])name.split(ESCAPED_DELIMITER));
        String propertyName = (String)CollectionUtility.lastElement((List)namesRec);
        Map<String, Object> map = this.m_properties;
        if (namesRec.size() > 1) {
            AtomicReference<Map<String, Object>> atomicMap = new AtomicReference<Map<String, Object>>(map);
            CollectionUtility.slice((List)namesRec, (int)0, (int)-2).stream().filter(nameRec -> {
                Object obj;
                Pair<String, Integer> nameIndexPair = ChartConfig.splitListExpression(nameRec);
                if (nameIndexPair != null) {
                    nameRec = (String)nameIndexPair.getLeft();
                }
                if ((obj = ((Map)atomicMap.get()).get(nameRec)) == null && modifyMode.isCreateMissing()) {
                    Map m;
                    if (nameIndexPair != null) {
                        List l = Stream.generate(HashMap::new).limit((Integer)nameIndexPair.getRight() + 1).collect(Collectors.toList());
                        ((Map)atomicMap.get()).put(nameRec, l);
                        m = (Map)l.get((Integer)nameIndexPair.getRight());
                    } else {
                        m = new HashMap();
                        ((Map)atomicMap.get()).put(nameRec, m);
                    }
                    atomicMap.set(m);
                } else if (nameIndexPair == null && obj instanceof Map) {
                    Map m = (Map)obj;
                    atomicMap.set(m);
                } else if (nameIndexPair != null && obj instanceof List) {
                    List l = (List)obj;
                    if (l.size() < (Integer)nameIndexPair.getRight() + 1) {
                        l.addAll(Stream.generate(HashMap::new).limit((Integer)nameIndexPair.getRight() + 1 - l.size()).collect(Collectors.toList()));
                    }
                    atomicMap.set((Map)l.get((Integer)nameIndexPair.getRight()));
                } else {
                    atomicMap.set(null);
                    return true;
                }
                return false;
            }).findFirst();
            map = atomicMap.get();
        }
        return modifyMode.modify(map, propertyName, value);
    }

    protected static Pair<String, Integer> splitListExpression(String listExpression) {
        Matcher arrayIndexMatcher = ARRAY_INDEX_PATTERN.matcher(listExpression);
        if (LIST_EXPRESSION_PATTERN.matcher(listExpression).matches() && arrayIndexMatcher.find()) {
            int start = arrayIndexMatcher.start();
            String indexString = listExpression.substring(start).replaceAll("\\D", "");
            return new ImmutablePair((Object)listExpression.substring(0, start), (Object)((Integer)TypeCastUtility.castValue((Object)indexString, Integer.class)));
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public Map<String, Object> getPropertiesFlat() {
        return this.getPropertiesFlatRec(this.m_properties);
    }

    protected Map<String, Object> getPropertiesFlatRec(Map<String, Object> properties) {
        return this.getPropertiesFlatRec(properties, null);
    }

    protected Map<String, Object> getPropertiesFlatRec(Map<String, Object> properties, String parentProperty) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (properties == null) {
            return result;
        }
        properties.forEach((key, value) -> {
            String property = StringUtility.join((String)DELIMITER, (Object[])new Object[]{parentProperty, key});
            if (value instanceof Map) {
                Map map2 = (Map)value;
                result.putAll(this.getPropertiesFlatRec(map2, property));
            } else if (value instanceof List) {
                List list = (List)value;
                int i = 0;
                while (i < list.size()) {
                    result.putAll(this.getPropertiesFlatRec((Map)list.get(i), String.valueOf(property) + "[" + i + "]"));
                    ++i;
                }
            } else if (value != null) {
                result.put(property, value);
            }
        });
        return result;
    }

    @Override
    public IChartConfig addProperties(IChartConfig config, boolean override) {
        if (config != null && !CollectionUtility.isEmpty(config.getProperties())) {
            Map<String, Object> source = override ? config.getProperties() : this.m_properties;
            Map<String, Object> target = override ? this.m_properties : config.getProperties();
            Map<String, Object> propertiesNew = this.putAllRec(source, target);
            this.m_properties.clear();
            this.m_properties.putAll(propertiesNew);
        }
        return this;
    }

    protected Map<String, Object> putAllRec(Map<String, Object> source, Map<String, Object> target) {
        if (CollectionUtility.isEmpty(source) && CollectionUtility.isEmpty(target)) {
            return new HashMap<String, Object>();
        }
        if (CollectionUtility.isEmpty(source)) {
            return new HashMap<String, Object>(target);
        }
        if (CollectionUtility.isEmpty(target)) {
            return new HashMap<String, Object>(source);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> properties = new HashSet<String>();
        properties.addAll(source.keySet());
        properties.addAll(target.keySet());
        properties.forEach(property -> {
            Object sourceObj = source.get(property);
            Object targetObj = target.get(property);
            if (sourceObj == null) {
                result.put((String)property, targetObj);
            } else if (sourceObj instanceof Map && targetObj instanceof Map) {
                Map sourceMap = (Map)sourceObj;
                Map targetMap = (Map)targetObj;
                result.put((String)property, this.putAllRec(sourceMap, targetMap));
            } else if (sourceObj instanceof List && targetObj instanceof List) {
                ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
                List sourceList = (List)sourceObj;
                List targetList = (List)targetObj;
                int i = 0;
                while (i < Math.max(sourceList.size(), targetList.size())) {
                    resultList.add(this.putAllRec(i < sourceList.size() ? (Map)sourceList.get(i) : null, i < targetList.size() ? (Map)targetList.get(i) : null));
                    ++i;
                }
                result.put((String)property, resultList);
            } else {
                result.put((String)property, sourceObj);
            }
        });
        return result;
    }

    @Override
    public IChartConfig withType(String type) {
        return this.withProperty(TYPE, type);
    }

    @Override
    public IChartConfig removeType() {
        return this.removeProperty(TYPE);
    }

    @Override
    public String getType() {
        return (String)this.getProperty(TYPE);
    }

    @Override
    public IChartConfig withAutoColor(boolean autoColor) {
        return this.withProperty(AUTO_COLOR, autoColor);
    }

    @Override
    public IChartConfig removeAutoColor() {
        return this.removeProperty(AUTO_COLOR);
    }

    @Override
    public boolean isAutoColor() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(AUTO_COLOR)));
    }

    @Override
    public IChartConfig withColorScheme(IColorScheme colorScheme) {
        return this.withProperty(COLOR_SCHEME, colorScheme != null ? colorScheme.getIdentifier() : null);
    }

    @Override
    public IChartConfig removeColorScheme() {
        return this.removeProperty(COLOR_SCHEME);
    }

    @Override
    public IColorScheme getColorScheme() {
        return IColorScheme.parse((String)((String)this.getProperty(COLOR_SCHEME)));
    }

    @Override
    public IChartConfig withTransparent(boolean transparent) {
        return this.withProperty(TRANSPARENT, transparent);
    }

    @Override
    public IChartConfig removeTransparent() {
        return this.removeProperty(TRANSPARENT);
    }

    @Override
    public boolean isTransparent() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(TRANSPARENT)));
    }

    @Override
    public IChartConfig withMaxSegments(int maxSegments) {
        return this.withProperty(MAX_SEGMENTS, maxSegments);
    }

    @Override
    public IChartConfig removeMaxSegments() {
        return this.removeProperty(MAX_SEGMENTS);
    }

    @Override
    public int getMaxSegments() {
        return (Integer)this.getProperty(MAX_SEGMENTS);
    }

    @Override
    public IChartConfig withClickable(boolean clickable) {
        return this.withProperty(CLICKABLE, clickable);
    }

    @Override
    public IChartConfig removeClickable() {
        return this.removeProperty(CLICKABLE);
    }

    @Override
    public boolean isClickable() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(CLICKABLE)));
    }

    @Override
    public IChartConfig withCheckable(boolean checkable) {
        return this.withProperty(CHECKABLE, checkable);
    }

    @Override
    public IChartConfig removeCheckable() {
        return this.removeProperty(CHECKABLE);
    }

    @Override
    public boolean isCheckable() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(CHECKABLE)));
    }

    @Override
    public IChartConfig withAnimationDuration(int duration) {
        return this.withProperty(ANIMATION_DURATION, duration);
    }

    @Override
    public IChartConfig removeAnimationDuration() {
        return this.removeProperty(ANIMATION_DURATION);
    }

    @Override
    public int getAnimationDuration() {
        return (Integer)this.getProperty(ANIMATION_DURATION);
    }

    protected int getDefaultAnimationDuration() {
        return 600;
    }

    @Override
    public IChartConfig withAnimated(boolean animated) {
        return this.withAnimationDuration(animated ? this.getDefaultAnimationDuration() : 0);
    }

    @Override
    public IChartConfig removeAnimated() {
        return this.removeAnimationDuration();
    }

    @Override
    public boolean isAnimated() {
        return this.getAnimationDuration() > 0;
    }

    @Override
    public IChartConfig withTooltipsEnabled(boolean tooltipsEnabled) {
        return this.withProperty(TOOLTIPS_ENABLED, tooltipsEnabled);
    }

    @Override
    public IChartConfig removeTooltipsEnabled() {
        return this.removeProperty(TOOLTIPS_ENABLED);
    }

    @Override
    public boolean isTooltipsEnabled() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(TOOLTIPS_ENABLED)));
    }

    @Override
    public IChartConfig withLegendDisplay(boolean legendDisplay) {
        return this.withProperty(LEGEND_DISPLAY, legendDisplay);
    }

    @Override
    public IChartConfig removeLegendDisplay() {
        return this.removeProperty(LEGEND_DISPLAY);
    }

    @Override
    public boolean isLegendDisplay() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(LEGEND_DISPLAY)));
    }

    @Override
    public IChartConfig withLegendClickable(boolean legendClickable) {
        return this.withProperty(LEGEND_CLICKABLE, legendClickable);
    }

    @Override
    public IChartConfig removeLegendClickable() {
        return this.removeProperty(LEGEND_CLICKABLE);
    }

    @Override
    public boolean isLegendClickable() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(LEGEND_CLICKABLE)));
    }

    @Override
    public IChartConfig withLegendPosition(String legendPosition) {
        return this.withProperty(LEGEND_POSITION, legendPosition);
    }

    @Override
    public IChartConfig removeLegendPosition() {
        return this.removeProperty(LEGEND_POSITION);
    }

    @Override
    public String getLegendPosition() {
        return (String)this.getProperty(LEGEND_POSITION);
    }

    @Override
    public IChartConfig withLegendPositionTop() {
        return this.withLegendPosition("top");
    }

    @Override
    public IChartConfig withLegendPositionBottom() {
        return this.withLegendPosition("bottom");
    }

    @Override
    public IChartConfig withLegendPositionLeft() {
        return this.withLegendPosition("left");
    }

    @Override
    public IChartConfig withLegendPositionRight() {
        return this.withLegendPosition("right");
    }

    @Override
    public IChartConfig withLineTension(BigDecimal tension) {
        return this.withProperty(LINE_TENSION, tension);
    }

    @Override
    public IChartConfig removeLineTension() {
        return this.removeProperty(LINE_TENSION);
    }

    @Override
    public BigDecimal getLineTension() {
        return (BigDecimal)this.getProperty(LINE_TENSION);
    }

    @Override
    public IChartConfig withLineFill(boolean fill) {
        return this.withProperty(LINE_FILL, fill);
    }

    @Override
    public IChartConfig removeLineFill() {
        return this.removeProperty(LINE_FILL);
    }

    @Override
    public boolean isLineFill() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(LINE_FILL)));
    }

    @Override
    public IChartConfig removeScales() {
        return this.removeProperty(SCALES);
    }

    @Override
    public IChartConfig withScaleLabelByTypeMap(Map<String, String> scaleLabelByTypeMap) {
        return this.withProperty(SCALE_LABEL_BY_TYPE_MAP, scaleLabelByTypeMap);
    }

    @Override
    public IChartConfig removeScaleLabelByTypeMap() {
        return this.removeProperty(SCALE_LABEL_BY_TYPE_MAP);
    }

    @Override
    public Map<String, String> getScaleLabelByTypeMap() {
        return (Map)this.getProperty(SCALE_LABEL_BY_TYPE_MAP);
    }

    @Override
    public IChartConfig withXLabelMap(Map<String, String> xLabelMap) {
        return this.withProperty(X_LABEL_MAP, xLabelMap);
    }

    @Override
    public IChartConfig removeXLabelMap() {
        return this.removeProperty(X_LABEL_MAP);
    }

    @Override
    public Map<String, String> getXLabelMap() {
        return (Map)this.getProperty(X_LABEL_MAP);
    }

    protected IChartConfig withXAxisStacked(boolean stacked, int index) {
        return this.withArrayProperty(X_AXES, index, STACKED, stacked);
    }

    protected IChartConfig removeXAxisStacked(int index) {
        return this.removeArrayProperty(X_AXES, index, STACKED);
    }

    protected boolean isXAxisStacked(int index) {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getArrayProperty(X_AXES, index, STACKED)));
    }

    @Override
    public IChartConfig withXAxisStacked(boolean stacked) {
        return this.withXAxisStacked(stacked, 0);
    }

    @Override
    public IChartConfig removeXAxisStacked() {
        return this.removeXAxisStacked(0);
    }

    @Override
    public boolean isXAxisStacked() {
        return this.isXAxisStacked(0);
    }

    protected IChartConfig withXAxisLabelDisplay(boolean display, int index) {
        return this.withArrayProperty(X_AXES, index, SCALE_LABEL_DISPLAY, display);
    }

    protected IChartConfig removeXAxisLabelDisplay(int index) {
        return this.removeArrayProperty(X_AXES, index, SCALE_LABEL_DISPLAY);
    }

    protected boolean isXAxisLabelDisplay(int index) {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getArrayProperty(X_AXES, index, SCALE_LABEL_DISPLAY)));
    }

    @Override
    public IChartConfig withXAxisLabelDisplay(boolean display) {
        return this.withXAxisLabelDisplay(display, 0);
    }

    @Override
    public IChartConfig removeXAxisLabelDisplay() {
        return this.removeXAxisLabelDisplay(0);
    }

    @Override
    public boolean isXAxisLabelDisplay() {
        return this.isXAxisLabelDisplay(0);
    }

    protected IChartConfig withXAxisLabel(String label, int index) {
        return this.withArrayProperty(X_AXES, index, SCALE_LABEL_LABEL, label);
    }

    protected IChartConfig removeXAxisLabel(int index) {
        return this.removeArrayProperty(X_AXES, index, SCALE_LABEL_LABEL);
    }

    protected String getXAxisLabel(int index) {
        return (String)this.getArrayProperty(X_AXES, index, SCALE_LABEL_LABEL);
    }

    @Override
    public IChartConfig withXAxisLabel(String label) {
        return this.withXAxisLabel(label, 0);
    }

    @Override
    public IChartConfig removeXAxisLabel() {
        return this.removeXAxisLabel(0);
    }

    @Override
    public String getXAxisLabel() {
        return this.getXAxisLabel(0);
    }

    @Override
    public IChartConfig withYLabelMap(Map<String, String> yLabelMap) {
        return this.withProperty(Y_LABEL_MAP, yLabelMap);
    }

    @Override
    public IChartConfig removeYLabelMap() {
        return this.removeProperty(Y_LABEL_MAP);
    }

    @Override
    public Map<String, String> getYLabelMap() {
        return (Map)this.getProperty(Y_LABEL_MAP);
    }

    protected IChartConfig withYAxisStacked(boolean stacked, int index) {
        return this.withArrayProperty(Y_AXES, index, STACKED, stacked);
    }

    protected IChartConfig removeYAxisStacked(int index) {
        return this.removeArrayProperty(Y_AXES, index, STACKED);
    }

    protected boolean isYAxisStacked(int index) {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getArrayProperty(Y_AXES, index, STACKED)));
    }

    @Override
    public IChartConfig withYAxisStacked(boolean stacked) {
        return this.withYAxisStacked(stacked, 0);
    }

    @Override
    public IChartConfig removeYAxisStacked() {
        return this.removeYAxisStacked(0);
    }

    @Override
    public boolean isYAxisStacked() {
        return this.isYAxisStacked(0);
    }

    protected IChartConfig withYAxisLabelDisplay(boolean display, int index) {
        return this.withArrayProperty(Y_AXES, index, SCALE_LABEL_DISPLAY, display);
    }

    protected IChartConfig removeYAxisLabelDisplay(int index) {
        return this.removeArrayProperty(Y_AXES, index, SCALE_LABEL_DISPLAY);
    }

    protected boolean isYAxisLabelDisplay(int index) {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getArrayProperty(Y_AXES, index, SCALE_LABEL_DISPLAY)));
    }

    @Override
    public IChartConfig withYAxisLabelDisplay(boolean display) {
        return this.withYAxisLabelDisplay(display, 0);
    }

    @Override
    public IChartConfig removeYAxisLabelDisplay() {
        return this.removeYAxisLabelDisplay(0);
    }

    @Override
    public boolean isYAxisLabelDisplay() {
        return this.isYAxisLabelDisplay(0);
    }

    protected IChartConfig withYAxisLabel(String label, int index) {
        return this.withArrayProperty(Y_AXES, index, SCALE_LABEL_LABEL, label);
    }

    protected IChartConfig removeYAxisLabel(int index) {
        return this.removeArrayProperty(Y_AXES, index, SCALE_LABEL_LABEL);
    }

    protected String getYAxisLabel(int index) {
        return (String)this.getArrayProperty(Y_AXES, index, SCALE_LABEL_LABEL);
    }

    @Override
    public IChartConfig withYAxisLabel(String label) {
        return this.withYAxisLabel(label, 0);
    }

    @Override
    public IChartConfig removeYAxisLabel() {
        return this.removeYAxisLabel(0);
    }

    @Override
    public String getYAxisLabel() {
        return this.getYAxisLabel(0);
    }

    @Override
    public IChartConfig withDatalabelsDisplay(boolean display) {
        return this.withProperty(DATALABELS_DISPLAY, display);
    }

    @Override
    public IChartConfig removeDatalabelsDisplay() {
        return this.removeProperty(DATALABELS_DISPLAY);
    }

    @Override
    public boolean isDatalabelsDisplay() {
        return BooleanUtility.nvl((Boolean)((Boolean)this.getProperty(DATALABELS_DISPLAY)));
    }

    protected static enum ModifyMode {
        PUT{

            @Override
            protected boolean validate(String name, Object value) {
                return super.validate(name, value) && value != null;
            }

            @Override
            protected boolean isCreateMissing() {
                return true;
            }

            @Override
            protected Object modify(Map<String, Object> map, String name, Object value) {
                if (map == null) {
                    throw new IllegalArgumentException("The given Map is null.");
                }
                return map.put(name, value);
            }
        }
        ,
        REMOVE{

            @Override
            protected Object modify(Map<String, Object> map, String name, Object value) {
                if (CollectionUtility.isEmpty(map)) {
                    return null;
                }
                Pair<String, Integer> nameIndexPair = ChartConfig.splitListExpression(name);
                if (nameIndexPair != null) {
                    Object obj = map.get(nameIndexPair.getLeft());
                    if (obj instanceof List) {
                        List l = (List)obj;
                        if ((Integer)nameIndexPair.getRight() >= 0 && (Integer)nameIndexPair.getRight() < l.size()) {
                            Map element = (Map)CollectionUtility.getElement((List)l, (int)((Integer)nameIndexPair.getRight()));
                            l.add((Integer)nameIndexPair.getRight(), new HashMap());
                            return element;
                        }
                    }
                } else {
                    return map.remove(name);
                }
                return null;
            }
        }
        ,
        GET{

            @Override
            protected Object modify(Map<String, Object> map, String name, Object value) {
                if (CollectionUtility.isEmpty(map)) {
                    return null;
                }
                Pair<String, Integer> nameIndexPair = ChartConfig.splitListExpression(name);
                if (nameIndexPair != null) {
                    Object obj = map.get(nameIndexPair.getLeft());
                    if (obj instanceof List) {
                        List l = (List)obj;
                        return CollectionUtility.getElement((List)l, (int)((Integer)nameIndexPair.getRight()));
                    }
                } else {
                    return map.get(name);
                }
                return null;
            }
        };


        protected boolean validate(String name, Object value) {
            return PROPERTY_PATTERN.matcher(name).matches();
        }

        protected boolean isCreateMissing() {
            return false;
        }

        protected abstract Object modify(Map<String, Object> var1, String var2, Object var3);
    }
}

