/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.chart.shared.data.basic.chart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.AbstractChartValueGroupBean;
import org.eclipse.scout.rt.chart.shared.data.basic.chart.INTupleChartValueGroupBean;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class NTupleChartValueGroupBean
extends AbstractChartValueGroupBean
implements INTupleChartValueGroupBean {
    private static final long serialVersionUID = 1L;
    private final List<Map<String, BigDecimal>> m_values = new ArrayList<Map<String, BigDecimal>>();
    private final int m_n;
    private final List<String> m_identifiers;

    public NTupleChartValueGroupBean(int n, String ... identifiers) {
        if (n != identifiers.length) {
            throw new IllegalArgumentException("The number of identifiers is unequal to the dimension.");
        }
        ArrayList identifiersList = CollectionUtility.arrayList((Object[])identifiers);
        if (identifiersList.contains(null)) {
            throw new IllegalArgumentException("At least one identifier is null.");
        }
        if (new HashSet(identifiersList).size() < identifiersList.size()) {
            throw new IllegalArgumentException("At least one identifier is not unique.");
        }
        this.m_n = n;
        this.m_identifiers = identifiersList;
    }

    @Override
    public int getN() {
        return this.m_n;
    }

    @Override
    public List<String> getIdentifiers() {
        return Collections.unmodifiableList(this.m_identifiers);
    }

    @Override
    public List<Map<String, BigDecimal>> getValues() {
        return Collections.unmodifiableList(this.m_values);
    }

    @Override
    public void add(BigDecimal ... tupleValues) {
        if (this.m_n != tupleValues.length) {
            throw new IllegalArgumentException("The number of tuple values is unequal to the dimension.");
        }
        HashMap<String, BigDecimal> tuple = new HashMap<String, BigDecimal>();
        int i = 0;
        while (i < tupleValues.length) {
            tuple.put(this.m_identifiers.get(i), tupleValues[i]);
            ++i;
        }
        this.m_values.add(tuple);
    }
}

