/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.client.AbstractMemoryPolicy;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.TableUserFilterManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public class LargeMemoryPolicy
extends AbstractMemoryPolicy {
    private final Map<String, AbstractMemoryPolicy.SearchFormState> m_searchFormCache = new HashMap<String, AbstractMemoryPolicy.SearchFormState>();
    private final Map<String, byte[]> m_tableUserFilterState = new HashMap<String, byte[]>();
    private long m_maxMemThreshold = 90L;

    @Override
    protected void loadSearchFormState(IForm f, String pageFormIdentifier) {
        AbstractMemoryPolicy.SearchFormState state = this.m_searchFormCache.get(pageFormIdentifier);
        if (state != null) {
            if (state.m_formContentXml != null) {
                f.loadFromXmlString(state.m_formContentXml);
            }
            if (state.m_searchFilter != null) {
                f.setSearchFilter(state.m_searchFilter);
            }
        }
    }

    @Override
    protected void storeSearchFormState(IForm f, String pageFormIdentifier) {
        if (f.isEmpty()) {
            this.m_searchFormCache.remove(pageFormIdentifier);
        } else {
            String xml = f.storeToXmlString();
            SearchFilter filter = f.getSearchFilter();
            this.m_searchFormCache.put(pageFormIdentifier, new AbstractMemoryPolicy.SearchFormState(xml, filter));
        }
    }

    @Override
    protected void storeUserFilterState(ITable table, String pageTableIdentifier) {
        TableUserFilterManager filterManager = table.getUserFilterManager();
        if (filterManager == null || filterManager.isEmpty()) {
            this.m_tableUserFilterState.remove(pageTableIdentifier);
            return;
        }
        this.m_tableUserFilterState.put(pageTableIdentifier, filterManager.getSerializedData());
    }

    @Override
    protected void loadUserFilterState(ITable table, String pageTableIdentifier) {
        TableUserFilterManager filterManager = table.getUserFilterManager();
        if (filterManager == null) {
            return;
        }
        byte[] state = this.m_tableUserFilterState.get(pageTableIdentifier);
        if (state != null) {
            filterManager.setSerializedData(state);
        }
    }

    @Override
    public void afterOutlineSelectionChanged(IDesktop desktop) {
        long memMax;
        long memTotal = Runtime.getRuntime().totalMemory();
        long memUsed = memTotal - Runtime.getRuntime().freeMemory();
        if (memUsed > (memMax = Runtime.getRuntime().maxMemory()) * this.getMaxMemThreshold() / 100L) {
            ModelJobs.schedule(desktop::releaseUnusedPages, ModelJobs.newInput(ClientRunContexts.copyCurrent()).withName("Checking memory", new Object[0]));
        }
    }

    @Override
    public String toString() {
        return "Large";
    }

    public long getMaxMemThreshold() {
        return this.m_maxMemThreshold;
    }

    public void setMaxMemThreshold(long maxMemThreshold) {
        this.m_maxMemThreshold = maxMemThreshold;
    }
}

