/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.context;

import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.logger.DiagnosticContextValueProcessor;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.ThreadLocalProcessor;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.logging.UserIdContextValueProvider;
import org.eclipse.scout.rt.shared.session.ScoutSessionIdContextValueProvider;
import org.eclipse.scout.rt.shared.ui.UserAgent;

public class ClientRunContext
extends RunContext {
    protected IClientSession m_session;
    protected UserAgent m_userAgent;
    protected IForm m_form;
    protected IOutline m_outline;
    protected IDesktop m_desktop;

    protected <RESULT> void interceptCallableChain(CallableChain<RESULT> callableChain) {
        callableChain.add((ICallableDecorator)new ThreadLocalProcessor(ISession.CURRENT, (Object)this.m_session)).add((ICallableDecorator)new DiagnosticContextValueProcessor((DiagnosticContextValueProcessor.IDiagnosticContextValueProvider)BEANS.get(UserIdContextValueProvider.class))).add((ICallableDecorator)new DiagnosticContextValueProcessor((DiagnosticContextValueProcessor.IDiagnosticContextValueProvider)BEANS.get(ScoutSessionIdContextValueProvider.class))).add((ICallableDecorator)new ThreadLocalProcessor(UserAgent.CURRENT, (Object)this.m_userAgent)).add((ICallableDecorator)new ThreadLocalProcessor(IDesktop.CURRENT, (Object)this.m_desktop)).add((ICallableDecorator)new ThreadLocalProcessor(IOutline.CURRENT, (Object)this.m_outline)).add((ICallableDecorator)new ThreadLocalProcessor(IForm.CURRENT, (Object)this.m_form));
    }

    public ClientRunContext withRunMonitor(RunMonitor runMonitor) {
        super.withRunMonitor(runMonitor);
        return this;
    }

    public ClientRunContext withSubject(Subject subject) {
        super.withSubject(subject);
        return this;
    }

    public ClientRunContext withLocale(Locale locale) {
        super.withLocale(locale);
        return this;
    }

    public ClientRunContext withCorrelationId(String correlationId) {
        super.withCorrelationId(correlationId);
        return this;
    }

    public ClientRunContext withTransactionScope(TransactionScope transactionScope) {
        super.withTransactionScope(transactionScope);
        return this;
    }

    public ClientRunContext withTransaction(ITransaction transaction) {
        super.withTransaction(transaction);
        return this;
    }

    public ClientRunContext withTransactionMember(ITransactionMember transactionMember) {
        super.withTransactionMember(transactionMember);
        return this;
    }

    public ClientRunContext withoutTransactionMembers() {
        super.withoutTransactionMembers();
        return this;
    }

    public <THREAD_LOCAL> ClientRunContext withThreadLocal(ThreadLocal<THREAD_LOCAL> threadLocal, THREAD_LOCAL value) {
        super.withThreadLocal(threadLocal, value);
        return this;
    }

    public ClientRunContext withProperty(Object key, Object value) {
        super.withProperty(key, value);
        return this;
    }

    public ClientRunContext withProperties(Map<?, ?> properties) {
        super.withProperties(properties);
        return this;
    }

    public IClientSession getSession() {
        return this.m_session;
    }

    public ClientRunContext withSession(IClientSession session, boolean applySessionProperties) {
        this.m_session = session;
        if (applySessionProperties) {
            this.m_locale = session != null ? session.getLocale() : null;
            this.m_userAgent = session != null ? session.getUserAgent() : null;
            this.m_subject = session != null ? session.getSubject() : null;
            this.m_desktop = session != null ? session.getDesktopElseVirtualDesktop() : null;
        }
        return this;
    }

    public UserAgent getUserAgent() {
        return this.m_userAgent;
    }

    public ClientRunContext withUserAgent(UserAgent userAgent) {
        this.m_userAgent = userAgent;
        return this;
    }

    public IForm getForm() {
        return this.m_form;
    }

    public ClientRunContext withForm(IForm form) {
        this.m_form = form;
        return this;
    }

    public IOutline getOutline() {
        return this.m_outline;
    }

    public ClientRunContext withOutline(IOutline outline, boolean unsetForm) {
        if (unsetForm) {
            this.m_form = null;
        }
        this.m_outline = outline;
        return this;
    }

    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    public ClientRunContext withDesktop(IDesktop desktop) {
        this.m_desktop = desktop;
        return this;
    }

    protected void interceptToStringBuilder(ToStringBuilder builder) {
        super.interceptToStringBuilder(builder.ref("session", (Object)this.getSession()).attr("userAgent", (Object)this.getUserAgent()).ref("form", (Object)this.getForm()).ref("outline", (Object)this.getOutline()).ref("desktop", (Object)this.getDesktop()));
    }

    protected void copyValues(RunContext runContext) {
        super.copyValues(runContext);
        ClientRunContext origin = (ClientRunContext)runContext;
        this.m_userAgent = origin.m_userAgent;
        this.m_session = origin.m_session;
        this.m_desktop = origin.m_desktop;
        this.m_outline = origin.m_outline;
        this.m_form = origin.m_form;
    }

    protected void fillCurrentValues() {
        super.fillCurrentValues();
        this.m_userAgent = (UserAgent)UserAgent.CURRENT.get();
        this.m_session = ClientSessionProvider.currentSession();
        this.m_desktop = IDesktop.CURRENT.get();
        this.m_outline = IOutline.CURRENT.get();
        this.m_form = IForm.CURRENT.get();
    }

    public ClientRunContext copy() {
        ClientRunContext copy = (ClientRunContext)((Object)BEANS.get(ClientRunContext.class));
        copy.copyValues(this);
        return copy;
    }

    public <T> T getAdapter(Class<T> type) {
        if (ISession.class.isAssignableFrom(type)) {
            return (T)this.m_session;
        }
        return null;
    }
}

