/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.deeplink;

import java.net.URI;
import java.net.URL;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.UriBuilder;
import org.eclipse.scout.rt.shared.deeplink.DeepLinkUtility;

public final class DeepLinkUriBuilder {
    private final UriBuilder m_builder;
    private String m_info;
    private String m_path;
    private boolean m_pathVisible = true;

    private DeepLinkUriBuilder(UriBuilder builder) {
        this.m_builder = builder;
    }

    public static DeepLinkUriBuilder createAbsolute() {
        IClientSession clientSession = ClientSessionProvider.currentSession();
        return new DeepLinkUriBuilder(new UriBuilder(clientSession.getBrowserURI()));
    }

    public static DeepLinkUriBuilder createRelative() {
        return new DeepLinkUriBuilder(new UriBuilder("./"));
    }

    public DeepLinkUriBuilder parameterPath(String path) {
        this.m_path = path;
        this.m_builder.parameter("dl", path);
        return this;
    }

    public DeepLinkUriBuilder info(String info) {
        this.m_info = info;
        return this;
    }

    public DeepLinkUriBuilder parameterInfo(String info) {
        if (StringUtility.hasText((CharSequence)info)) {
            this.m_info = info;
            this.m_builder.parameter("i", DeepLinkUtility.toSlug((String)info));
        }
        return this;
    }

    public DeepLinkUriBuilder parameter(String name, String value) {
        this.m_builder.parameter(name, value);
        return this;
    }

    public DeepLinkUriBuilder pathVisible(boolean pathVisible) {
        this.m_pathVisible = pathVisible;
        return this;
    }

    public BrowserHistoryEntry createBrowserHistoryEntry() {
        if (this.m_path == null) {
            throw new IllegalStateException("Cannot create BrowserHistoryEntry without deep-link path");
        }
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        StringBuilder title = new StringBuilder(desktop.getTitle());
        if (StringUtility.hasText((CharSequence)this.m_info)) {
            title.append(" - ").append(this.m_info);
        }
        return new BrowserHistoryEntry(this.m_builder.createURI(), title.toString(), this.m_path, this.m_pathVisible);
    }

    public URL createURL() {
        return this.m_builder.createURL();
    }

    public URI createURI() {
        return this.m_builder.createURI();
    }
}

