/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.perf.internal;

import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.services.common.perf.internal.PerformanceSampleSet;
import org.eclipse.scout.rt.platform.reflect.BasicPropertySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceAnalyzerService
implements IPerformanceAnalyzerService {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceAnalyzerService.class);
    private final PerformanceSampleSet m_networkLatency;
    private final PerformanceSampleSet m_serverExecutionTime;
    private final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    public PerformanceAnalyzerService() {
        this.m_networkLatency = new PerformanceSampleSet(10, 70L);
        this.m_serverExecutionTime = new PerformanceSampleSet(10, 100L);
    }

    @Override
    public void addNetworkLatencySample(long millis) {
        long oldValue = this.m_networkLatency.getValue();
        this.m_networkLatency.addSample(millis);
        long newValue = this.m_networkLatency.getValue();
        try {
            this.m_propertySupport.firePropertyChange("networkLatency", (Object)oldValue, (Object)newValue);
        }
        catch (Exception t) {
            LOG.warn("Unexpected exception", (Throwable)t);
        }
    }

    @Override
    public long getNetworkLatency() {
        return this.m_networkLatency.getValue();
    }

    @Override
    public void addServerExecutionTimeSample(long millis) {
        long oldValue = this.m_serverExecutionTime.getValue();
        this.m_serverExecutionTime.addSample(millis);
        long newValue = this.m_serverExecutionTime.getValue();
        try {
            this.m_propertySupport.firePropertyChange("serverExecutionTime", (Object)oldValue, (Object)newValue);
        }
        catch (Exception t) {
            LOG.warn("Unexpected Exception", (Throwable)t);
        }
    }

    @Override
    public long getServerExecutionTime() {
        return this.m_serverExecutionTime.getValue();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(propertyName, listener);
    }
}

