/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import org.eclipse.scout.rt.client.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public abstract class AbstractDeviceTransformer
implements IDeviceTransformer {
    private IDesktop m_desktop;
    private final DeviceTransformationConfig m_deviceTransformationConfig = this.createDeviceTransformationConfig();

    public AbstractDeviceTransformer() {
        this.initTransformationConfig();
    }

    protected DeviceTransformationConfig createDeviceTransformationConfig() {
        return new DeviceTransformationConfig();
    }

    @Override
    public DeviceTransformationConfig getDeviceTransformationConfig() {
        return this.m_deviceTransformationConfig;
    }

    protected void initTransformationConfig() {
    }

    @Override
    public void setDesktop(IDesktop desktop) {
        this.m_desktop = desktop;
    }

    @Override
    public abstract boolean isActive();

    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void transformDesktop() {
    }

    @Override
    public void transformForm(IForm form) {
    }

    @Override
    public void excludeForm(IForm form) {
        this.getDeviceTransformationConfig().excludeForm(form);
    }

    @Override
    public void excludeFormTransformation(IForm form, IDeviceTransformation transformation) {
        this.getDeviceTransformationConfig().excludeFormTransformation(form, transformation);
    }

    @Override
    public boolean isFormExcluded(IForm form) {
        return this.getDeviceTransformationConfig().isFormExcluded(form);
    }

    @Override
    public void excludeField(IFormField formField) {
        this.getDeviceTransformationConfig().excludeField(formField);
    }

    @Override
    public void excludeFieldTransformation(IFormField formField, IDeviceTransformation transformation) {
        this.getDeviceTransformationConfig().excludeFieldTransformation(formField, transformation);
    }

    @Override
    public boolean isFormFieldExcluded(IFormField formField) {
        return this.getDeviceTransformationConfig().isFieldExcluded(formField);
    }

    @Override
    public void transformFormField(IFormField field) {
    }

    @Override
    public void transformOutline(IOutline outline) {
    }

    @Override
    public void transformPage(IPage<?> page) {
    }

    @Override
    public void transformPageTable(ITable table, IPage<?> page) {
    }

    @Override
    public void notifyPageDetailFormChanged(IForm form) {
    }

    @Override
    public void notifyPageDetailTableChanged(ITable table) {
    }

    @Override
    public void notifyFormDisposed(IForm form) {
        this.getDeviceTransformationConfig().removeFormExclusion(form);
    }

    @Override
    public void notifyFieldDisposed(IFormField formField) {
        this.getDeviceTransformationConfig().removeFieldExclusion(formField);
    }

    @Override
    public void notifyDesktopClosing() {
    }

    @Override
    public void notifyPageSearchFormInit(IPageWithTable<ITable> page) {
    }

    protected void rebuildParentGrid(IFormField field) {
        ICompositeField parentField = field.getParentField();
        if (parentField != null) {
            parentField.rebuildFieldGrid();
        }
    }
}

