/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTransformationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceTransformationConfig.class);
    private final Set<IDeviceTransformation> m_enabledTransformations = new HashSet<IDeviceTransformation>();
    private final Map<IForm, ExclusionInfo> m_excludedForms = new WeakHashMap<IForm, ExclusionInfo>();
    private final Map<IFormField, ExclusionInfo> m_excludedFields = new WeakHashMap<IFormField, ExclusionInfo>();

    public void enableTransformation(IDeviceTransformation transformation) {
        this.m_enabledTransformations.add(transformation);
    }

    public void disableTransformation(IDeviceTransformation transformation) {
        this.m_enabledTransformations.remove(transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation) {
        return this.m_enabledTransformations.contains(transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation, IForm form) {
        if (!this.isTransformationEnabled(transformation)) {
            return false;
        }
        return !this.isFormTransformationExcluded(form, transformation);
    }

    public boolean isTransformationEnabled(IDeviceTransformation transformation, IFormField field) {
        if (!this.isTransformationEnabled(transformation)) {
            return false;
        }
        if (this.isFormTransformationExcluded(field.getForm(), transformation)) {
            return false;
        }
        return !this.isFieldTransformationExcluded(field, transformation);
    }

    public void excludeForm(IForm form) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.computeIfAbsent(form, k -> new ExclusionInfo());
        exclusionInfo.setExcludeAllTransformations(true);
        LOG.debug("Excluding form {}", (Object)form);
    }

    public void excludeFormTransformation(IForm form, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.computeIfAbsent(form, k -> new ExclusionInfo());
        exclusionInfo.getExcludedTransformations().add(transformation);
        LOG.debug("Excluding form transformation {} for form {}", (Object)transformation, (Object)form);
    }

    public boolean isFormExcluded(IForm form) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations();
    }

    public boolean isFormTransformationExcluded(IForm form, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedForms.get(form);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations() || exclusionInfo.getExcludedTransformations().contains(transformation);
    }

    public void removeFormExclusion(IForm form) {
        this.m_excludedForms.remove(form);
    }

    public void excludeField(IFormField formField) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.computeIfAbsent(formField, k -> new ExclusionInfo());
        exclusionInfo.setExcludeAllTransformations(true);
        LOG.debug("Excluding field {}", (Object)formField);
    }

    public void excludeFieldTransformation(IFormField formField, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.computeIfAbsent(formField, k -> new ExclusionInfo());
        exclusionInfo.getExcludedTransformations().add(transformation);
        LOG.debug("Excluding field transformation {} for field {}", (Object)transformation, (Object)formField);
    }

    public boolean isFieldExcluded(IFormField formField) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations();
    }

    public boolean isFieldTransformationExcluded(IFormField formField, IDeviceTransformation transformation) {
        ExclusionInfo exclusionInfo = this.m_excludedFields.get(formField);
        if (exclusionInfo == null) {
            return false;
        }
        return exclusionInfo.isExcludeAllTransformations() || exclusionInfo.getExcludedTransformations().contains(transformation);
    }

    public void removeFieldExclusion(IFormField formField) {
        this.m_excludedFields.remove(formField);
    }

    private class ExclusionInfo {
        private boolean m_excludeAllTransformations = false;
        private final Set<IDeviceTransformation> m_excludedTransformations = new HashSet<IDeviceTransformation>();

        public Set<IDeviceTransformation> getExcludedTransformations() {
            return this.m_excludedTransformations;
        }

        public boolean isExcludeAllTransformations() {
            return this.m_excludeAllTransformations;
        }

        public void setExcludeAllTransformations(boolean excludeAllTransformations) {
            this.m_excludeAllTransformations = excludeAllTransformations;
        }
    }
}

