/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.transformation;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.scout.rt.client.transformation.AbstractDeviceTransformer;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.controls.ITableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.SearchFormTableControl;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.placeholder.IPlaceholderField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@Order(value=5200.0)
public class MobileDeviceTransformer
extends AbstractDeviceTransformer {
    @Override
    public boolean isActive() {
        return UserAgentUtility.isMobileDevice();
    }

    @Override
    protected void initTransformationConfig() {
        LinkedList<MobileDeviceTransformation> transformations = new LinkedList<MobileDeviceTransformation>();
        transformations.add(MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP);
        transformations.add(MobileDeviceTransformation.MOVE_FIELD_STATUS_TO_TOP);
        transformations.add(MobileDeviceTransformation.MAKE_FIELD_SCALEABLE);
        transformations.add(MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
        transformations.add(MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE);
        transformations.add(MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD);
        transformations.add(MobileDeviceTransformation.HIDE_FIELD_STATUS);
        transformations.add(MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION);
        transformations.add(MobileDeviceTransformation.AUTO_CLOSE_SEARCH_FORM);
        transformations.add(MobileDeviceTransformation.SET_SEQUENCEBOX_UI_HEIGHT);
        for (IDeviceTransformation iDeviceTransformation : transformations) {
            this.getDeviceTransformationConfig().enableTransformation(iDeviceTransformation);
        }
    }

    @Override
    public void transformDesktop() {
        this.getDesktop().setDisplayStyle("compact");
    }

    @Override
    public void transformForm(IForm form) {
        if (this.getDeviceTransformationConfig().isFormExcluded(form)) {
            return;
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION)) {
            form.setAskIfNeedSave(false);
        }
        if (form.getDisplayHint() == 20) {
            this.transformView(form);
        }
    }

    protected void transformView(IForm form) {
        form.setDisplayViewId("C");
    }

    @Override
    public void transformOutline(IOutline outline) {
        outline.setNavigateButtonsVisible(false);
        outline.setLazyExpandingEnabled(false);
        outline.setToggleBreadcrumbStyleEnabled(false);
        outline.setDisplayStyle("breadcrumb");
    }

    public void transformPage(IPage page) {
        if (page instanceof IPageWithTable) {
            this.transformPageWithTable((IPageWithTable)page);
        }
    }

    public void transformPageWithTable(IPageWithTable page) {
        page.setLeaf(false);
        page.setAlwaysCreateChildPage(true);
    }

    @Override
    public void transformPageTable(ITable table, IPage<?> page) {
        for (ITableControl control : table.getTableControls()) {
            if (control instanceof SearchFormTableControl) continue;
            control.setVisibleGranted(false);
        }
    }

    @Override
    public void notifyPageDetailFormChanged(IForm form) {
        IGroupBox mainBox = form.getRootGroupBox();
        if (mainBox.isScrollable().isTrue()) {
            mainBox.setScrollable(false);
            FormUtility.initRootBoxGridData(mainBox);
        }
    }

    @Override
    public void notifyPageDetailTableChanged(ITable table) {
        IPage<?> activePage = this.getDesktop().getOutline().getActivePage();
        IPage<?> parentPage = activePage.getParentPage();
        if (parentPage == null) {
            return;
        }
        Object parentTable = parentPage.getTable(false);
        if (parentTable == null) {
            return;
        }
        ArrayList<IMenu> newMenus = new ArrayList<IMenu>();
        for (IMenu menu : table.getMenus()) {
            if (menu instanceof OutlineMenuWrapper) {
                OutlineMenuWrapper menuWrapper = (OutlineMenuWrapper)menu;
                IMenu originalMenu = MobileDeviceTransformer.unwrapOutlineWrapperMenu(menuWrapper);
                if (menuWrapper.getMenuTypes().contains(TableMenuType.EmptySpace) && originalMenu.getMenuTypes().contains(TableMenuType.SingleSelection) && parentTable.getMenus().contains(originalMenu)) continue;
            }
            newMenus.add(menu);
        }
        if (!CollectionUtility.equalsCollection(newMenus, table.getContextMenu().getChildActions())) {
            table.getContextMenu().setChildActions(newMenus);
        }
    }

    protected static IMenu unwrapOutlineWrapperMenu(IMenu menu) {
        return MenuWrapper.unwrapMenu(menu);
    }

    @Override
    public void notifyPageSearchFormInit(IPageWithTable<ITable> page) {
        if (!this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.AUTO_CLOSE_SEARCH_FORM)) {
            return;
        }
        ISearchForm searchForm = page.getSearchFormInternal();
        searchForm.addFormListener(e -> {
            if (2020 == e.getType()) {
                this.onSearchFormStored(page);
            }
        });
    }

    protected void onSearchFormStored(IPageWithTable<ITable> page) {
        SearchFormTableControl tableControl = page.getTable().getTableControl(SearchFormTableControl.class);
        if (tableControl != null) {
            tableControl.setSelected(false);
        }
    }

    @Override
    public void transformFormField(IFormField field) {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP, field)) {
            this.moveLabelToTop(field);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_FIELD_SCALEABLE, field)) {
            this.makeFieldScalable(field);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.HIDE_FIELD_STATUS, field)) {
            this.hideStatus(field);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MOVE_FIELD_STATUS_TO_TOP, field)) {
            this.moveStatusToTop(field);
        }
        if (field instanceof IGroupBox) {
            this.transformGroupBox((IGroupBox)field);
        } else if (field instanceof IPlaceholderField) {
            this.transformPlaceholderField((IPlaceholderField)field);
        } else if (field instanceof ISequenceBox) {
            this.transformSequenceBox((ISequenceBox)field);
        }
    }

    protected void makeFieldScalable(IFormField field) {
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        GridData gridDataHints = field.getGridDataHints();
        if (gridDataHints.weightX == 0.0) {
            gridDataHints.weightX = 1.0;
            field.setGridDataHints(gridDataHints);
            this.rebuildParentGrid(field);
        }
    }

    protected void moveLabelToTop(IFormField field) {
        if (field instanceof IGroupBox) {
            return;
        }
        if (2 == field.getLabelPosition()) {
            return;
        }
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        field.setLabelPosition((byte)4);
        if (field instanceof IBooleanField) {
            field.setLabelVisible(false);
        }
    }

    protected void moveStatusToTop(IFormField field) {
        field.setStatusPosition("top");
    }

    protected void hideStatus(IFormField field) {
        if (field instanceof ICompositeField) {
            ((ICompositeField)field).setStatusVisible(false, false);
        } else {
            field.setStatusVisible(false);
        }
    }

    protected void transformMainBox(IGroupBox groupBox) {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE, groupBox)) {
            this.makeGroupBoxScrollable(groupBox);
        }
    }

    protected void makeGroupBoxScrollable(IGroupBox groupBox) {
        if (!groupBox.isScrollable().isTrue()) {
            groupBox.setScrollable(true);
            if (groupBox.isMainBox()) {
                FormUtility.initRootBoxGridData(groupBox);
            } else {
                this.rebuildParentGrid(groupBox);
            }
        }
    }

    protected void transformGroupBox(IGroupBox groupBox) {
        if (groupBox.isMainBox()) {
            this.transformMainBox(groupBox);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE, groupBox)) {
            groupBox.setGridColumnCount(1);
        }
        groupBox.setResponsive(false);
    }

    protected void transformPlaceholderField(IPlaceholderField field) {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD, field)) {
            field.setVisible(false);
        }
    }

    protected void transformSequenceBox(ISequenceBox box) {
        if (!this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.SET_SEQUENCEBOX_UI_HEIGHT, box)) {
            return;
        }
        GridData gridDataHints = box.getGridDataHints();
        if (!gridDataHints.useUiHeight) {
            gridDataHints.useUiHeight = true;
            box.setGridDataHints(gridDataHints);
            this.rebuildParentGrid(box);
        }
    }
}

