/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public abstract class AbstractEventBuffer<T extends IModelEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventBuffer.class);
    private List<T> m_buffer = new LinkedList<T>();
    private T m_lastAddedEvent = null;

    public List<T> getBufferInternal() {
        return this.m_buffer;
    }

    protected T getLastAddedEventInternal() {
        return this.m_lastAddedEvent;
    }

    protected void setLastAddedEventInternal(T lastAddedEvent) {
        this.m_lastAddedEvent = lastAddedEvent;
    }

    public boolean isEmpty() {
        return this.m_buffer.isEmpty();
    }

    public int size() {
        return this.m_buffer.size();
    }

    public void add(T event) {
        LOG.debug("Adding '{}'", event);
        if (this.isIdenticalEvent(this.m_lastAddedEvent, event)) {
            return;
        }
        this.m_buffer.add(event);
        this.m_lastAddedEvent = event;
    }

    public List<T> consumeAndCoalesceEvents() {
        List<T> result = this.coalesce(this.consume());
        LOG.debug("Consumed events from buffer '{}'", result);
        return result;
    }

    protected List<T> consume() {
        List<T> list = this.m_buffer;
        this.m_buffer = new LinkedList<T>();
        this.m_lastAddedEvent = null;
        return list;
    }

    protected abstract List<T> coalesce(List<T> var1);

    protected void remove(int type, List<T> events) {
        this.remove(Collections.singleton(type), events);
    }

    protected void remove(Set<Integer> types, List<T> events) {
        events.removeIf(event -> types.contains(event.getType()));
    }

    protected boolean isIdenticalEvent(T event1, T event2) {
        return ObjectUtility.equals(event1, event2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EventBuffer");
        if (this.isEmpty()) {
            sb.append(" is empty");
        } else {
            sb.append(" contains ").append(this.size()).append(" events:");
            sb.append("\n- ");
            sb.append(CollectionUtility.format(this.m_buffer, (String)"\n- "));
        }
        return sb.toString();
    }
}

