/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.extension.ui.action.menu.IMenuExtension;
import org.eclipse.scout.rt.client.extension.ui.action.menu.MenuChains;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.menu.CalendarMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ImageFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.PlannerMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TabBoxMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.AbstractActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="e8dbfee4-503c-401e-8579-d0aa8618f59d")
public abstract class AbstractMenu
extends AbstractActionNode<IMenu>
implements IMenu {
    private Object m_ownerValue;

    public AbstractMenu() {
        this(true);
    }

    public AbstractMenu(boolean callInitializer) {
        super(callInitializer);
    }

    @Order(value=55.0)
    @ConfigProperty(value="MENU_TYPE")
    protected Set<? extends IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TreeMenuType.SingleSelection, ValueFieldMenuType.NotNull, CalendarMenuType.CalendarComponent, PlannerMenuType.Activity, TabBoxMenuType.Header, ImageFieldMenuType.Image, ImageFieldMenuType.ImageId, ImageFieldMenuType.ImageUrl});
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=56.0)
    protected boolean getConfiguredPreventDoubleClick() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=57.0)
    protected boolean getConfiguredStackable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=58.0)
    protected boolean getConfiguredShrinkable() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=59.0)
    protected String getConfiguredSubMenuVisibility() {
        return "default";
    }

    @Override
    public Object getOwnerValue() {
        return this.m_ownerValue;
    }

    @Override
    public final void handleOwnerValueChanged(Object newValue) {
        this.m_ownerValue = newValue;
        this.interceptOwnerValueChanged(newValue);
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execOwnerValueChanged(Object newOwnerValue) {
    }

    protected Collection<ITableRow> convertToTableRows(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITableRow)) continue;
            rows.add((ITableRow)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    protected Collection<ITreeNode> convertToTreeNodes(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITreeNode> rows = new ArrayList<ITreeNode>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITreeNode)) continue;
            rows.add((ITreeNode)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMenuTypes(this.getConfiguredMenuTypes());
        this.setPreventDoubleClick(this.getConfiguredPreventDoubleClick());
        this.setStackable(this.getConfiguredStackable());
        this.setShrinkable(this.getConfiguredShrinkable());
        this.setSubMenuVisibility(this.getConfiguredSubMenuVisibility());
    }

    @Override
    public void addChildActions(Collection<? extends IMenu> actionList) {
        super.addChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusAdd(actionList);
        }
    }

    @Override
    public void removeChildActions(Collection<? extends IMenu> actionList) {
        super.removeChildActions(actionList);
        if (CollectionUtility.hasElements(actionList)) {
            this.afterChildMenusRemove(actionList);
        }
    }

    protected void afterChildMenusAdd(Collection<? extends IMenu> newChildMenus) {
        if (CollectionUtility.hasElements(newChildMenus)) {
            Object ownerValue = this.m_ownerValue;
            Consumer<IMenu> visitor = menu -> {
                if (ObjectUtility.notEquals((Object)menu.getOwnerValue(), (Object)ownerValue)) {
                    menu.handleOwnerValueChanged(ownerValue);
                }
            };
            for (IMenu iMenu : newChildMenus) {
                iMenu.visit(visitor, IMenu.class);
            }
        }
    }

    protected void afterChildMenusRemove(Collection<? extends IMenu> childMenusToRemove) {
    }

    @Override
    public Set<IMenuType> getMenuTypes() {
        return CollectionUtility.hashSet((Collection)((Collection)this.propertySupport.getProperty("menuTypes")));
    }

    public void setMenuTypes(Set<? extends IMenuType> menuTypes) {
        this.propertySupport.setProperty("menuTypes", (Object)CollectionUtility.hashSet(menuTypes));
    }

    @Override
    public boolean isPreventDoubleClick() {
        return this.propertySupport.getPropertyBool("preventDoubleClick");
    }

    @Override
    public void setPreventDoubleClick(boolean preventDoubleClick) {
        this.propertySupport.setPropertyBool("preventDoubleClick", preventDoubleClick);
    }

    @Override
    public boolean isStackable() {
        return this.propertySupport.getPropertyBool("stackable");
    }

    @Override
    public void setStackable(boolean stackable) {
        this.propertySupport.setPropertyBool("stackable", stackable);
    }

    @Override
    public boolean isShrinkable() {
        return this.propertySupport.getPropertyBool("shrinkable");
    }

    @Override
    public void setShrinkable(boolean shrinkable) {
        this.propertySupport.setPropertyBool("shrinkable", shrinkable);
    }

    @Override
    public String getSubMenuVisibility() {
        return this.propertySupport.getPropertyString("subMenuVisibility");
    }

    @Override
    public void setSubMenuVisibility(String subMenuVisibility) {
        this.propertySupport.setProperty("subMenuVisibility", (Object)subMenuVisibility);
    }

    protected final void interceptOwnerValueChanged(Object newOwnerValue) {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        MenuChains.MenuOwnerValueChangedChain chain = new MenuChains.MenuOwnerValueChangedChain(extensions);
        chain.execOwnerValueChanged(newOwnerValue);
    }

    @Override
    protected IMenuExtension<? extends AbstractMenu> createLocalExtension() {
        return new LocalMenuExtension<AbstractMenu>(this);
    }

    protected static class LocalMenuExtension<OWNER extends AbstractMenu>
    extends AbstractActionNode.LocalActionNodeExtension<IMenu, OWNER>
    implements IMenuExtension<OWNER> {
        public LocalMenuExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execOwnerValueChanged(MenuChains.MenuOwnerValueChangedChain chain, Object newOwnerValue) {
            ((AbstractMenu)this.getOwner()).execOwnerValueChanged(newOwnerValue);
        }
    }
}

