/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.breadcrumbbar;

import java.util.List;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.BreadcrumbItemEvent;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.BreadcrumbItemListener;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.IBreadcrumbBar;
import org.eclipse.scout.rt.client.ui.basic.breadcrumbbar.IBreadcrumbItem;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="9a3ef53f-94a0-4750-b182-5e912ebebc94")
public class AbstractBreadcrumbBar
extends AbstractWidget
implements IBreadcrumbBar {
    protected final BreadcrumbItemListener m_breadcrumbListener = this::onBreadcrumbItemAction;

    @ConfigOperation
    protected void execBreadcrumbItemAction(IBreadcrumbItem item) {
    }

    @Override
    public void setBreadcrumbItems(List<IBreadcrumbItem> breadcrumbItems) {
        this.setBreadcrumbItemsInternal(breadcrumbItems);
    }

    protected void setBreadcrumbItemsInternal(List<IBreadcrumbItem> breadcrumbItems) {
        for (IBreadcrumbItem oldItem : this.getBreadcrumbItems()) {
            oldItem.removeBreadcrumbItemListener(this.m_breadcrumbListener);
        }
        this.propertySupport.setPropertyAlwaysFire("breadcrumbItems", breadcrumbItems);
        for (IBreadcrumbItem newItem : breadcrumbItems) {
            newItem.addBreadcrumbItemListener(this.m_breadcrumbListener);
        }
    }

    protected void onBreadcrumbItemAction(BreadcrumbItemEvent event) {
        this.execBreadcrumbItemAction((IBreadcrumbItem)event.getSource());
    }

    public List<IBreadcrumbItem> getBreadcrumbItemsInternal() {
        return this.propertySupport.getPropertyList("breadcrumbItems");
    }

    @Override
    public List<IBreadcrumbItem> getBreadcrumbItems() {
        return CollectionUtility.arrayList(this.getBreadcrumbItemsInternal());
    }

    @Override
    public IBreadcrumbItem getBreadcrumbItemFor(String ref) {
        for (IBreadcrumbItem b : this.getBreadcrumbItems()) {
            String refValue = b.getRef();
            if (!ObjectUtility.equals((Object)refValue, (Object)ref)) continue;
            return b;
        }
        return null;
    }
}

