/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.CalendarChains;
import org.eclipse.scout.rt.client.extension.ui.basic.calendar.ICalendarExtension;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.CalendarMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.CalendarContextMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarEvent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarItemConflict;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarListener;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendarUIFacade;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="51532170-6aba-414e-a18f-413d4400e70e")
public abstract class AbstractCalendar
extends AbstractWidget
implements ICalendar,
IContributionOwner,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCalendar.class);
    private List<ICalendarItemProvider> m_providers;
    private final Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> m_componentsByProvider;
    private ICalendarUIFacade m_uiFacade;
    private int m_calendarChanging;
    private final DateTimeFormatFactory m_dateTimeFormatFactory;
    private List<CalendarEvent> m_calendarEventBuffer = new ArrayList<CalendarEvent>();
    private final FastListenerList<CalendarListener> m_listenerList = new FastListenerList();
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractCalendar, ICalendarExtension<? extends AbstractCalendar>> m_objectExtensions;
    private List<IMenu> m_inheritedMenusOfSelectedProvider;

    public AbstractCalendar() {
        this(true);
    }

    public AbstractCalendar(boolean callInitializer) {
        super(false);
        this.m_dateTimeFormatFactory = new DateTimeFormatFactory();
        this.m_componentsByProvider = new HashMap<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>>();
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus()});
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=500.0)
    protected int getConfiguredStartHour() {
        return 6;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=520.0)
    protected boolean getConfiguredUseOverflowCells() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=530.0)
    protected boolean getConfiguredShowDisplayModeSelection() {
        return true;
    }

    private List<Class<? extends ICalendarItemProvider>> getConfiguredProducers() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, ICalendarItemProvider.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, ICalendarItemProvider.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitCalendar() {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeCalendar() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execFilterCalendarItems(Set<Class<? extends ICalendarItemProvider>> changedProviderTypes, Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setTitle(this.getConfiguredTitle());
        this.setSelectedDate(new Date());
        this.setStartHour(this.getConfiguredStartHour());
        this.setUseOverflowCells(this.getConfiguredUseOverflowCells());
        this.setShowDisplayModeSelection(this.getConfiguredShowDisplayModeSelection());
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menus.addOrdered((IOrdered)menu);
        }
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        List<Class<? extends ICalendarItemProvider>> configuredProducers = this.getConfiguredProducers();
        List contributedProducers = this.m_contributionHolder.getContributionsByClass(ICalendarItemProvider.class);
        ArrayList<ICalendarItemProvider> producerList = new ArrayList<ICalendarItemProvider>(configuredProducers.size() + contributedProducers.size());
        for (Class<? extends ICalendarItemProvider> itemProviderClazz : configuredProducers) {
            try {
                ICalendarItemProvider provider = (ICalendarItemProvider)ConfigurationUtility.newInnerInstance((Object)this, itemProviderClazz);
                producerList.add(provider);
                menus.addAllOrdered(ActionUtility.getActions(provider.getMenus(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)CalendarMenuType.EmptySpace), false)));
            }
            catch (Exception e2) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + itemProviderClazz.getName() + "'.", new Object[]{e2}));
            }
        }
        producerList.addAll(contributedProducers);
        this.m_providers = producerList;
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e3) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e3);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        CalendarContextMenu contextMenu = new CalendarContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
        this.setContextMenu(contextMenu);
        for (ICalendarItemProvider p : this.m_providers) {
            p.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("items")) {
                    ArrayList<ICalendarItemProvider> modified = new ArrayList<ICalendarItemProvider>(1);
                    modified.add(p);
                    this.updateComponentsInternal(modified);
                } else if (e.getPropertyName().equals("loadInProgress")) {
                    this.updateLoadInProgressInternal();
                }
            });
        }
    }

    public final List<? extends ICalendarExtension<? extends AbstractCalendar>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ICalendarExtension<? extends AbstractCalendar> createLocalExtension() {
        return new LocalCalendarExtension<AbstractCalendar>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.interceptInitCalendar();
        this.addPropertyChangeListener("viewRange", e -> this.updateComponentsInternal(this.m_providers));
        this.updateComponentsInternal(this.m_providers);
    }

    protected void disposeCalendarInternal() {
        for (ICalendarItemProvider p : this.m_providers) {
            try {
                p.disposeProvider();
            }
            catch (Exception e) {
                LOG.warn("Exception while disposing calendar item provider [{}]", (Object)p.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    protected final void disposeInternal() {
        this.disposeCalendarInternal();
        try {
            this.interceptDisposeCalendar();
        }
        catch (Exception e) {
            LOG.warn("Exception while disposing calendar", (Throwable)e);
        }
        super.disposeInternal();
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public int getStartHour() {
        return (Integer)this.propertySupport.getProperty("startHour");
    }

    @Override
    public void setStartHour(int hour) {
        this.propertySupport.setProperty("startHour", (Object)hour);
    }

    @Override
    public boolean getUseOverflowCells() {
        return (Boolean)this.propertySupport.getProperty("useOverflowCells");
    }

    @Override
    public void setUseOverflowCells(boolean useOverflowCells) {
        this.propertySupport.setProperty("useOverflowCells", (Object)useOverflowCells);
    }

    @Override
    public boolean getShowDisplayModeSelection() {
        return (Boolean)this.propertySupport.getProperty("showDisplayModeSelection");
    }

    @Override
    public void setShowDisplayModeSelection(boolean showDisplayModeSelection) {
        this.propertySupport.setProperty("showDisplayModeSelection", (Object)showDisplayModeSelection);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean b) {
        this.propertySupport.setPropertyBool("loadInProgress", b);
    }

    @Override
    public boolean isCalendarChanging() {
        return this.m_calendarChanging > 0;
    }

    @Override
    public void setCalendarChanging(boolean b) {
        if (b) {
            ++this.m_calendarChanging;
            if (this.m_calendarChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_calendarChanging > 0) {
            --this.m_calendarChanging;
            if (this.m_calendarChanging == 0) {
                try {
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    private void processChangeBuffer() {
        this.m_calendarEventBuffer = new ArrayList<CalendarEvent>();
        HashSet<Integer> types = new HashSet<Integer>();
        LinkedList<CalendarEvent> coalescedEvents = new LinkedList<CalendarEvent>();
        CalendarEvent[] a = this.m_calendarEventBuffer.toArray(new CalendarEvent[0]);
        int i = a.length - 1;
        while (i >= 0) {
            switch (a[i].getType()) {
                case 20: {
                    if (types.contains(a[i].getType())) break;
                    coalescedEvents.add(0, a[i]);
                    types.add(a[i].getType());
                    break;
                }
                default: {
                    coalescedEvents.add(0, a[i]);
                }
            }
            --i;
        }
        this.fireCalendarEventBatchInternal(coalescedEvents);
    }

    protected void setContextMenu(ICalendarContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public ICalendarContextMenu getContextMenu() {
        return (ICalendarContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public IGroupBox getMenuInjectionTarget() {
        return (IGroupBox)this.propertySupport.getProperty("menuInjectionTarget");
    }

    @Override
    public void setMenuInjectionTarget(IGroupBox target) {
        this.propertySupport.setProperty("menuInjectionTarget", (Object)target);
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public List<ICalendarItemProvider> getCalendarItemProviders() {
        return CollectionUtility.arrayList(this.m_providers);
    }

    @Override
    public int getDisplayMode() {
        return this.propertySupport.getPropertyInt("displayMode");
    }

    @Override
    public void setDisplayMode(int mode) {
        this.propertySupport.setPropertyInt("displayMode", mode);
    }

    @Override
    public boolean isDisplayCondensed() {
        return this.propertySupport.getPropertyBool("displayCondensed");
    }

    @Override
    public void setDisplayCondensed(boolean condensed) {
        this.propertySupport.setPropertyBool("displayCondensed", condensed);
    }

    @Override
    public Range<Date> getViewRange() {
        Range propValue = (Range)this.propertySupport.getProperty("viewRange");
        return new Range(propValue);
    }

    @Override
    public void setViewRange(Date minDate, Date maxDate) {
        this.setViewRangeInternal((Range<Date>)new Range((Object)minDate, (Object)maxDate));
    }

    @Override
    public void setViewRange(Range<Date> viewRange) {
        this.setViewRangeInternal((Range<Date>)new Range(viewRange));
    }

    private void setViewRangeInternal(Range<Date> viewRange) {
        this.propertySupport.setProperty("viewRange", viewRange);
    }

    @Override
    public Date getSelectedDate() {
        return (Date)this.propertySupport.getProperty("selectedDate");
    }

    @Override
    public void setSelectedDate(Date d) {
        this.propertySupport.setProperty("selectedDate", (Object)d);
    }

    @Override
    public CalendarComponent getSelectedComponent() {
        return (CalendarComponent)this.propertySupport.getProperty("selectedComponent");
    }

    @Override
    public <T extends ICalendarItem> T getSelectedItem(Class<T> c) {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null && comp.getItem() != null && c.isAssignableFrom(comp.getItem().getClass())) {
            return (T)((ICalendarItem)c.cast(comp.getItem()));
        }
        return null;
    }

    @Override
    public void setSelectedComponent(CalendarComponent comp) {
        comp = this.resolveComponent(comp);
        ICalendarItemProvider provider = null;
        if (comp != null) {
            provider = comp.getProvider();
        }
        this.updateContentProviderMenus(provider);
        this.propertySupport.setProperty("selectedComponent", (Object)comp);
    }

    protected void updateContentProviderMenus(ICalendarItemProvider provider) {
        if (this.m_inheritedMenusOfSelectedProvider != null) {
            this.getContextMenu().removeChildActions(this.m_inheritedMenusOfSelectedProvider);
            this.m_inheritedMenusOfSelectedProvider = null;
        }
        if (provider != null) {
            this.m_inheritedMenusOfSelectedProvider = ActionUtility.getActions(provider.getMenus(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)CalendarMenuType.CalendarComponent), false));
            this.getContextMenu().addChildActions(this.m_inheritedMenusOfSelectedProvider);
        }
    }

    protected CalendarComponent resolveComponent(CalendarComponent comp) {
        if (comp == null || !this.getComponents().contains(comp)) {
            return null;
        }
        return comp;
    }

    @Override
    public DateTimeFormatFactory getDateTimeFormatFactory() {
        return this.m_dateTimeFormatFactory;
    }

    public Set<CalendarComponent> getComponents() {
        return CollectionUtility.hashSet((Collection)this.propertySupport.getPropertySet("components"));
    }

    protected CalendarComponent createCalendarComponent(ICalendar calendar, ICalendarItemProvider producer, ICalendarItem item) {
        return new CalendarComponent(calendar, producer, item);
    }

    protected void updateComponentsInternal(List<ICalendarItemProvider> changedProviders) {
        Range<Date> d = this.getViewRange();
        if (d.getFrom() != null && d.getTo() != null) {
            for (ICalendarItemProvider p : changedProviders) {
                LinkedList components = new LinkedList();
                for (ICalendarItem iCalendarItem : p.getItems((Date)d.getFrom(), (Date)d.getTo())) {
                    components.add(this.createCalendarComponent(this, p, iCalendarItem));
                }
                this.m_componentsByProvider.put(p.getClass(), components);
            }
            HashSet<Class<? extends ICalendarItemProvider>> providerTypes = new HashSet<Class<? extends ICalendarItemProvider>>(changedProviders.size());
            for (ICalendarItemProvider provider : changedProviders) {
                providerTypes.add(provider.getClass());
            }
            this.interceptFilterCalendarItems(providerTypes, this.m_componentsByProvider);
            TreeMap<CompositeObject, CalendarComponent> sortMap = new TreeMap<CompositeObject, CalendarComponent>();
            int index = 0;
            for (Collection collection : this.m_componentsByProvider.values()) {
                for (CalendarComponent comp : collection) {
                    sortMap.put(new CompositeObject(new Object[]{comp.getFromDate(), index++}), comp);
                }
            }
            this.propertySupport.setPropertySet("components", (Set)CollectionUtility.hashSet(sortMap.values()));
            this.setSelectedComponent(this.getSelectedComponent());
        }
    }

    @Override
    @Deprecated
    public Object getContainer() {
        return this.getParent();
    }

    public Collection<CalendarItemConflict> findConflictingItems(Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider, Class<?> ... providerTypes) {
        if (providerTypes != null && providerTypes.length >= 2) {
            HashMap<String, List> classificationMap = new HashMap<String, List>();
            Class<?>[] classArray = providerTypes;
            int n = providerTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> providerType = classArray[n2];
                Collection<CalendarComponent> a = componentsByProvider.get(providerType);
                if (a != null) {
                    for (CalendarComponent comp : a) {
                        String key = StringUtility.emptyIfNull((Object)comp.getItem().getSubject()).toLowerCase().trim();
                        List list = classificationMap.computeIfAbsent(key, k -> new ArrayList());
                        list.add(comp);
                    }
                }
                ++n2;
            }
            ArrayList<CalendarItemConflict> conflicts = new ArrayList<CalendarItemConflict>();
            for (Map.Entry e : classificationMap.entrySet()) {
                if (((List)e.getValue()).size() < 2) continue;
                List list = (List)e.getValue();
                HashMap groups = new HashMap();
                for (CalendarComponent c : list) {
                    if (groups.containsKey(c.getProvider())) {
                        ((ArrayList)groups.get(c.getProvider())).add(c);
                        continue;
                    }
                    ArrayList<CalendarComponent> tmp = new ArrayList<CalendarComponent>();
                    tmp.add(c);
                    groups.put(c.getProvider(), tmp);
                }
                ArrayList<CalendarComponent> groupComp = new ArrayList<CalendarComponent>();
                for (List g : groups.values()) {
                    if (g.size() <= 1) continue;
                    groupComp.addAll(g);
                }
                if (groupComp.isEmpty()) {
                    groupComp.add((CalendarComponent)list.get(0));
                }
                for (CalendarComponent ref : groupComp) {
                    ArrayList<CalendarComponent> matchList = new ArrayList<CalendarComponent>();
                    double matchSum = 0.0;
                    matchList.add(ref);
                    for (CalendarComponent test : list) {
                        if (ref == test || test.getProvider() == ref.getProvider() || !DateUtility.intersects((Date)test.getFromDate(), (Date)test.getToDate(), (Date)ref.getFromDate(), (Date)ref.getToDate())) continue;
                        matchList.add(test);
                        double minOfStart = Math.min(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double maxOfStart = Math.max(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double minOfEnd = Math.min(test.getToDate().getTime(), ref.getToDate().getTime());
                        double maxOfEnd = Math.max(test.getToDate().getTime(), ref.getToDate().getTime());
                        if (maxOfEnd - minOfStart > 1.0E-6) {
                            matchSum += (minOfEnd - maxOfStart) / (maxOfEnd - minOfStart);
                            continue;
                        }
                        matchSum += 1.0;
                    }
                    if (matchList.size() < 2) continue;
                    conflicts.add(new CalendarItemConflict(componentsByProvider, matchList, matchSum / (double)(matchList.size() - 1)));
                }
            }
            return conflicts;
        }
        return CollectionUtility.emptyArrayList();
    }

    private void updateLoadInProgressInternal() {
        boolean b = false;
        for (ICalendarItemProvider p : this.m_providers) {
            if (!p.isLoadInProgress()) continue;
            b = true;
            break;
        }
        this.setLoadInProgress(b);
    }

    @Override
    public void reloadCalendarItems() {
        for (ICalendarItemProvider p : this.m_providers) {
            p.reloadProvider();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public IFastListenerList<CalendarListener> calendarListeners() {
        return this.m_listenerList;
    }

    private void fireCalendarComponentAction() {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null) {
            try {
                comp.getProvider().onItemAction(comp.getItem());
            }
            catch (RuntimeException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
            this.fireCalendarEventInternal(new CalendarEvent(this, 20, comp));
        }
    }

    private void fireCalendarEventInternal(CalendarEvent e) {
        if (this.isCalendarChanging()) {
            this.m_calendarEventBuffer.add(e);
        } else {
            this.calendarListeners().list().forEach(listener -> listener.calendarChanged(e));
        }
    }

    private void fireCalendarEventBatchInternal(List<CalendarEvent> batch) {
        if (this.isCalendarChanging()) {
            LOG.error("Illegal State: firing a event batch while calendar is changing");
        } else {
            this.calendarListeners().list().forEach(listener -> listener.calendarChangedBatch(batch));
        }
    }

    @Override
    public ICalendarUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected final void interceptFilterCalendarItems(Set<Class<? extends ICalendarItemProvider>> changedProviderTypes, Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider) {
        List<? extends ICalendarExtension<? extends AbstractCalendar>> extensions = this.getAllExtensions();
        CalendarChains.CalendarFilterCalendarItemsChain chain = new CalendarChains.CalendarFilterCalendarItemsChain(extensions);
        chain.execFilterCalendarItems(changedProviderTypes, componentsByProvider);
    }

    protected final void interceptDisposeCalendar() {
        List<? extends ICalendarExtension<? extends AbstractCalendar>> extensions = this.getAllExtensions();
        CalendarChains.CalendarDisposeCalendarChain chain = new CalendarChains.CalendarDisposeCalendarChain(extensions);
        chain.execDisposeCalendar();
    }

    protected final void interceptInitCalendar() {
        List<? extends ICalendarExtension<? extends AbstractCalendar>> extensions = this.getAllExtensions();
        CalendarChains.CalendarInitCalendarChain chain = new CalendarChains.CalendarInitCalendarChain(extensions);
        chain.execInitCalendar();
    }

    protected static class LocalCalendarExtension<OWNER extends AbstractCalendar>
    extends AbstractExtension<OWNER>
    implements ICalendarExtension<OWNER> {
        public LocalCalendarExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execFilterCalendarItems(CalendarChains.CalendarFilterCalendarItemsChain chain, Set<Class<? extends ICalendarItemProvider>> changedProviderTypes, Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider) {
            ((AbstractCalendar)this.getOwner()).execFilterCalendarItems(changedProviderTypes, componentsByProvider);
        }

        @Override
        public void execDisposeCalendar(CalendarChains.CalendarDisposeCalendarChain chain) {
            ((AbstractCalendar)this.getOwner()).execDisposeCalendar();
        }

        @Override
        public void execInitCalendar(CalendarChains.CalendarInitCalendarChain chain) {
            ((AbstractCalendar)this.getOwner()).execInitCalendar();
        }
    }

    protected class P_UIFacade
    implements ICalendarUIFacade {
        private int m_uiProcessorCount = 0;

        protected P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void setSelectionFromUI(Date d, CalendarComponent comp) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setSelectedDate(d);
                AbstractCalendar.this.setSelectedComponent(comp);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setViewRangeFromUI(Range<Date> viewRange) {
            this.setViewRangeFromUI((Date)viewRange.getFrom(), (Date)viewRange.getTo());
        }

        @Override
        public void setSelectedDateFromUI(Date date) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setSelectedDate(date);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setDisplayModeFromUI(int displayMode) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setDisplayMode(displayMode);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setViewRangeFromUI(Date from, Date to) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setViewRange(from, to);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireReloadFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.reloadCalendarItems();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentActionFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentMoveFromUI(CalendarComponent comp, Date newDate) {
            try {
                this.pushUIProcessor();
                comp = AbstractCalendar.this.resolveComponent(comp);
                if (comp != null) {
                    comp.getProvider().onItemMoved(comp.getItem(), newDate);
                }
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

